<?php
/*
Plugin Name: نصب دمو های قالب بازی نیوز
Description: به وسیله این افزونه میتوانید , دموهای مربوط قالب شاپیت را درون ریزی کنید 
Author: Saoshyant-Web
Version: 1.1
License: GPLv2 or later
Text Domain: bazinewsdemoimport
*/

/*
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more dSTails.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin StreST, Fifth Floor, Boston, MA  02110-1301, USA.
 
*/


if( !defined('bazinews_DI_PATH') ){
	define( 'bazinews_DI_PATH', plugin_dir_path(__FILE__) );
}
if( !defined('bazinews_DI_DIR') ){
	define( 'bazinews_DI_DIR', plugin_dir_url(__FILE__) );
}	

if( ! function_exists( 'bazinewsdemoimport_importer_get_path_locate' ) ) {
  function bazinewsdemoimport_importer_get_path_locate() {
    $dirname        = wp_normalize_path( dirname( __FILE__ ) );
    $plugin_dir     = wp_normalize_path( WP_PLUGIN_DIR );
    $located_plugin = ( preg_match( '#'. $plugin_dir .'#', $dirname ) ) ? true : false;
    $directory      = ( $located_plugin ) ? $plugin_dir : bazinews_DI_PATH;
    $directory_uri  = ( $located_plugin ) ? WP_PLUGIN_URL : bazinews_DI_DIR;
    $basename       = str_replace( wp_normalize_path( $directory ), '', $dirname );
    $dir            = $directory . $basename;
    $uri            = $directory_uri . $basename;
    return apply_filters( 'bazinews_DI_IMPORTER_get_path_locate', array(
      'basename' => wp_normalize_path( $basename ),
      'dir'      => wp_normalize_path( $dir ),
      'uri'      => $uri
    ) );
  }
}

/**
 * Scripts and styles for admin
 */
if ( ! function_exists( 'bazinewsdemoimport_enqueue_scripts' ) ) {

function bazinewsdemoimport_enqueue_scripts() {

    wp_enqueue_script( 'bazinewsdemoimport-import-js', bazinews_DI_DIR . 'assets/js/dt-importer.js', array( 'jquery' ), '25', true);
    wp_enqueue_style( 'bazinewsdemoimport-importer-css', bazinews_DI_DIR . 'assets/css/dt-importer.css', null);
}

add_action( 'admin_enqueue_scripts', 'bazinewsdemoimport_enqueue_scripts' );
}
/**
 *
 * Decode string for backup options (Source from codestar)
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if ( ! function_exists( 'cs_decode_string' ) ) {
  function cs_decode_string( $string ) {
    return unserialize( gzuncompress( stripslashes( call_user_func( 'base'. '64' .'_decode', rtrim( strtr( $string, '-_', '+/' ), '=' ) ) ) ) );
  }
}

/**
 * Importer constants
 */

$get_path = bazinewsdemoimport_importer_get_path_locate();

define( 'bazinews_DI_IMPORTER_VER' , '1.0.0' );
define( 'bazinews_DI_IMPORTER_DIR' , $get_path['dir'] );
define( 'bazinews_DI_IMPORTER_URI' , $get_path['uri'] );
define( 'bazinews_DI_IMPORTER_CONTENT_DIR' , bazinews_DI_IMPORTER_DIR . '/demos/' );
define( 'bazinews_DI_IMPORTER_CONTENT_URI' , bazinews_DI_IMPORTER_URI . '/demos/' );


if( ! function_exists( 'bazinewsdemoimport_number_replace' ) ) {
 function bazinewsdemoimport_number_replace($English_Number){
	$WPLANG = get_option('WPLANG');
	$con = 'fa';
	$number1 = 'I';
	$number2 = 'R';
 	$number = str_replace(
		array('0','1','2','3','4','5','6','7','8','9'),
		array('۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'),
		$English_Number
	);

		return $number;
	 
 }

}
  
  

load_plugin_textdomain('bazinewsdemoimport', false, basename(dirname(__FILE__)).'/languages');
 
 


require_once bazinews_DI_PATH . 'classes/abstract.class.php';
require_once bazinews_DI_PATH . 'classes/importer.class.php';
require_once bazinews_DI_PATH . 'classes/import.php';
require_once bazinews_DI_PATH . 'classes/widgets.php';
require_once bazinews_DI_PATH . 'classes/menu-export.php';
include_once bazinews_DI_PATH . 'demo.php';
 