<?php 
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																	Register Widget Blog
 
*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
add_action( 'widgets_init', 'reza_register_widget_game_image' );
function reza_register_widget_game_image() {
    register_widget( 'reza_widget_game_image' );
}

class reza_widget_game_image extends WP_Widget {
 	function __construct() {
		parent::__construct(
			'bazinews_game_images',
			 esc_html__('Theme','reza').' - '. esc_html__('Game Image', 'reza') 
		);
	}
 
 
 	public  function option(){
		$option=array();
      	$option[]=array(
				'name' =>__('Title' , 'reza' ),
 				'id' => 'title',
 				'type' => 'text'
		);
		$option[]= array( 
			"name"			=> esc_html__('Number of Posts to show','reza'),
			"id"			=> "number",
 			"type"			=> "number",
			  
		);
		$option[]= array( 
			"name"			=> esc_html__('Select Game','reza'),
			"id"			=> "game_id",
			"type"			=> "chosen",
			"options" 		=> reza_category_array_options('game'), 
 		); 	
	 
	 
	 
		$column=__('Column','reza');
	 /**********************Layout************************/
		$option[]= array( 
			"name"			=> esc_html__('Columns','reza'),
			"id"			=> "column",
			"type"			=> "select",
			"options"		=> array(
					""	=> __('Default','reza'), 
					"1"	=> "1 $column", 
					"2"	=> "2 $column", 
					"3"	=> "3 $column", 
 				),
					
					  
		); 
		$option[]= array( 
			"name"			=> esc_html__('Column Width in Tablet and Mobile','reza'),
			"id"			=> "responsive_column",
			"type"			=> "select",
			"options" 		=> reza_array_options('responsive_column',true), 
 		); 	
	 
  			
		$option[]= array( 
			"name"			=> esc_html__('Space Between Item','reza'),
			"id"			=> "between",
			"type"			=> "select",
			"default"		=>  '',
			"options"		=>  reza_array_options('between',true),						
		);
		
	 
	 
	
	 
		
		$option[]= array( 
			"name"			=> esc_html__('Image Size','reza'),
			"id"			=> "thumb",
			"type"			=> "select",
			"default"		=>  'full',
			"options" 		=>	reza_all_image_sizes(),
			 
		); 	  
	 
	 
		 
 		 
		return $option;
    }
   /********** Update the widget info from the admin panel *******/
 	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
  		return	reza_widget_options_save( $new_instance, $old_instance,$this->option() );
 	}
 
	/********** Display the widget update form *******/
 	public function form( $instance ) { 
		$defaults = array( 'title'=>__('Title' , 'reza' ),'number' => '5', 'thumb' => 'full' );
		$instance = wp_parse_args( (array) $instance, $defaults );
 
		reza_widget_options($instance,$this->id_base,$this->number,$this->option());
  
 	}
 
    /**********  The widget For Display *******/
 	public function widget( $args, $instance ) {
		extract( $args );
 		$title = apply_filters( 'widget_title', $instance[ 'title' ] );
 		$rabo_data =$instance;
 		$count = 0;
		 $args=array();
  		$args['key'] = 'widget_game_image';
  		$column = !empty( $instance['column'] ) ? $instance['column'] : '3';
		
		$game_id = !empty( $instance['game_id'] ) ? $instance['game_id']:'';
	 
		$post = get_page_by_path($game_id, OBJECT, 'game');
		$option =array(
 			'title' => !empty( $instance['title'] ) ? $instance['title'] : '',				
 			'number' => !empty( $instance['number'] ) ? $instance['number'] : '6',
 			'game_id' => !empty($post->ID)?$post->ID:'',
 	 
  			'featured_layout' 		=>  'featured_'.$column,
  			'responsive_column'=> !empty( $instance['responsive_column'] ) ? $instance['responsive_column'] : '',	
			'between'=> !empty( $instance['between'] ) ? $instance['between'] : '',	
 			'thumb' => !empty( $instance['thumb'] ) ? $instance['thumb'] : 'full',
  			 
		) ; 
 
 		global $smof_data; 
			 	$widget_id = !empty($widget_id)?' id="'.esc_attr($widget_id).'"':'';

		?>
		<div  <?php echo $widget_id  ?> class="rd-element-blog_1 rd-widget-post rd-element-item">
 			 <?php 	echo reza_game_image($option, true);?>
		</div>
	<?php 
	
	}
	
  
} 