<?php 
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																	Register Widget Blog
 
*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
add_action( 'widgets_init', 'reza_register_widget_game_featured' );
function reza_register_widget_game_featured() {
    register_widget( 'reza_widget_game_featured' );
}

class reza_widget_game_featured extends WP_Widget {
 	function __construct() {
		parent::__construct(
			'bazinews_game_featured',
			 esc_html__('Theme','reza').' - '. esc_html__('Game Glider', 'reza') 
		);
	}
 
 
 	public  function option(){
		$option=array();
      	$option[]=array(
				'name' =>__('Title' , 'reza' ),
 				'id' => 'title',
 				'type' => 'text'
		);
		$option[]= array( 
			"name"			=> esc_html__('Number of Posts to show','reza'),
			"id"			=> "number",
 			"type"			=> "number",
			  
		);
	
		 
		$option[]= array( 
			"name"			=> esc_html__('Category','reza'),
			"id"			=> "cats",
			"type"			=> "select",
			"options"		=>  reza_category_array_options('game_category'),						
		);
			
		$option[]= array( 
			"name"			=> esc_html__('Orderby','reza'),
			"id"			=> "orderby",
			"type"			=> "select",
			"options"		=>  reza_category_array_options('game_orderby'),						
		); 		
		
		$option[]= array( 
			"name"			=> esc_html__('Platforms','reza'),
			"id"			=> "platforms",
			"type"			=> "select",
			"options"		=>  reza_category_array_options('platforms'),						
		);
		
 		$option[]= array( 
			"name"			=> esc_html__('Limit Title length','reza'),
			"id"			=> "title_limit", 	
			"type"			=> "number",
		); 
		
		
		$option[]= array( 
				"name"			=> esc_html__('Show Excerpt Posts','reza'),
				"id"			=> "excerpt",
				"type"			=> "checkbox",
		);
		
		$option[]= array( 
			"name"			=> esc_html__('Limit Excerpt length','reza'),
			"id"			=> "excerpt_limit",
			"type"			=> "number",
		); 
		
		
		
		$option[]= array( 
				"name"			=> esc_html__('Relesae Date','reza'),
				"id"			=> "meta_relesae",
				"type"			=> "checkbox",
		);
		
		$option[]= array( 
				"name"			=> esc_html__('Platforms','reza'),
				"id"			=> "meta_platforms",
				"type"			=> "checkbox",
		);
			
		$option[]= array( 
				"name"			=> esc_html__('Developer','reza'),
				"id"			=> "meta_developer",
				"type"			=> "checkbox",
		);
		
		$option[]= array( 
				"name"			=> esc_html__('Publisher','reza'),
				"id"			=> "meta_publisher",
				"type"			=> "checkbox",
		);	
	
		$option[]= array( 
				"name"			=> esc_html__('Genre','reza'),
				"id"			=> "meta_genre",
				"type"			=> "checkbox",
		);	
		
		$option[]= array( 
				"name"			=> esc_html__('Review Score','reza'),
				"id"			=> "meta_review",
				"type"			=> "checkbox",
		);	
		
		
		$option[]= array( 
				"name"			=> esc_html__('Metascore','reza'),
				"id"			=> "meta_metascore",
				"type"			=> "checkbox",
		);	
	
		$option[]= array( 
				"name"			=> esc_html__('Show Sub Score','reza'),
				"id"			=> "meta_subscore",
				"type"			=> "checkbox",
		);	
					
 
		$column=__('Column','reza');
	
		$option[]= array( 
			"name"			=> esc_html__('Column Width in Tablet and Mobile','reza'),
			"id"			=> "responsive_column",
			"type"			=> "select",
			"options" 		=> reza_array_options('responsive_column',true), 
 		); 	
	 
  			
		$option[]= array( 
			"name"			=> esc_html__('Space Between Item','reza'),
			"id"			=> "between",
			"type"			=> "select",
			"default"		=>  '',
			"options"		=>  reza_array_options('between',true),						
		);
		
	 
		$option[]= array( 
			"name"			=> esc_html__('Image Ratio','reza'),
			"id"			=> "ratio",
			"group"			=>  esc_html__('Layout','reza'),
			"default"		=>  'rd-ratio75',
			"type"			=> "select",
			"options"		=>  reza_array_options('ratio',true),						
			
		); 	 
	
		$option[]= array( 
			"name"			=> esc_html__('Image Width','reza'),
			"id"			=> "image_width",
			"type"			=> "select",
			"options"		=>  reza_array_options('image_width',true),		 
 		); 	 	
		
		$option[]= array( 
			"name"			=> esc_html__('Image Size','reza'),
			"id"			=> "thumb",
			"group"			=>  esc_html__('Layout','reza'),
			"type"			=> "select",
			"default"		=>  'full',
			"options" 		=>	reza_all_image_sizes(),
			 
		); 	  
	 
	 
		$option[]= array( 
			'name'			=> esc_html__('Details Alignment','reza'),
			'id'			=> 'alignment',
			"type"			=> "select",
 			"options"		=>  reza_array_options('alignment_justify_rtl',true),						
		 
		); 
		$option[]= array( 
			"name"			=> esc_html__('Box Layout','reza'),
			"id"			=> "box_layout", 		
			"type"			=> "select",
			"options"		=>  reza_array_options('box_layout',true),						
		); 		
	 
 
 		 
		return $option;
    }
   /********** Update the widget info from the admin panel *******/
 	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
  		return	reza_widget_options_save( $new_instance, $old_instance,$this->option() );
 	}
 
	/********** Display the widget update form *******/
 	public function form( $instance ) { 
		$defaults = array( 'title'=>__('Title' , 'reza' ),'number' => '5', 'thumb' => 'full' );
		$instance = wp_parse_args( (array) $instance, $defaults );
 
		reza_widget_options($instance,$this->id_base,$this->number,$this->option());
  
 	}
 
    /**********  The widget For Display *******/
 	public function widget( $args, $instance ) {
		extract( $args );
 		$title = apply_filters( 'widget_title', $instance[ 'title' ] );
 		$rabo_data =$instance;
 		$count = 0;
		 $args=array();
  		$args['key'] = 'widget_game_featured';
  		$column = !empty( $instance['column'] ) ? $instance['column'] : '1';
		
		$args['option'] =array(
 			'title' => !empty( $instance['title'] ) ? $instance['title'] : '',				
 			'number' => !empty( $instance['number'] ) ? $instance['number'] : '5',
 			'category' => !empty( $instance['cats'] ) ? $instance['category'] : '',
 			'orderby' => !empty( $instance['orderby'] ) ? $instance['orderby'] : '',
 			'platforms' => !empty( $instance['platforms'] ) ? $instance['platforms'] : '',
			
			'ignore_sticky_posts'=> true,
  			'excerpt' => !empty( $instance['excerpt'] ) ? $instance['excerpt'] : '',
  			'excerpt_limit' => !empty( $instance['excerpt_limit'] ) ? $instance['excerpt_limit'] : '',
			'meta_category' => !empty( $instance['meta_category'] ) ? $instance['meta_category'] : '', 
 			'title_limit' => !empty( $instance['title_limit'] ) ? $instance['title_limit'] : '',
  	'game_meta'=> array(
				'meta_relesae'					=> 	!empty( $instance['meta_relesae'] ) ? $instance['meta_relesae'] : '',
  				'meta_platforms'				=>	!empty( $instance['meta_platforms'] ) ? $instance['meta_platforms'] : '',
				'meta_developer'				=>	!empty( $instance['meta_developer'] ) ? $instance['meta_developer'] : '',
				'meta_publisher'				=>	!empty( $instance['meta_publisher'] ) ? $instance['meta_publisher'] : '',
				'meta_genre'					=>	!empty( $instance['meta_genre'] ) ? $instance['meta_genre'] : '',
			),
  			'game_score'=> array(
				'meta_review'					=> !empty( $instance['meta_review'] ) ? $instance['meta_review'] : '',
  				'meta_metascore'				=>	!empty( $instance['meta_metascore'] ) ? $instance['meta_metascore'] : '',
				'meta_subscore'					=>	!empty( $instance['meta_subscore'] ) ? $instance['meta_subscore'] : '',
 			),
   			'more_posts' 				=> !empty( $instance['more_posts'] ) ? $instance['more_posts'] : '',

 			'hover_post_icon' => !empty( $instance['hover_post_icon'] ) ? $instance['hover_post_icon'] : '',
 			'layout' 		=>  'featured_1',
  			'responsive_column'=> !empty( $instance['responsive_column'] ) ? $instance['responsive_column'] : '',	
			'between'=> !empty( $instance['between'] ) ? $instance['between'] : '',	
 			'thumb' => !empty( $instance['thumb'] ) ? $instance['thumb'] : 'full',
			'ratio' => !empty( $instance['ratio'] ) ? $instance['ratio'] : '',
 			'image_width' => !empty( $instance['image_width'] ) ? $instance['image_width'] : '',
			'alignment' => !empty( $instance['alignment'] ) ? $instance['alignment'] : '',
			'box_layout' => !empty( $instance['box_layout'] ) ? $instance['box_layout'] : '',
 			 
		) ; 
 
 
		global $smof_data; 
		?>
		<div id="<?php echo esc_attr($widget_id) ?>" class="rd-element-blog_1 rd-widget-post rd-element-item">
 			 <?php 	echo reza_game_featured_config($args, true);?>
		</div>
	<?php 
	
	}
	
  
} 