<?php 
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																	Register Widget Blog
 
*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
add_action( 'widgets_init', 'reza_register_widget_blog_featured' );
function reza_register_widget_blog_featured() {
    register_widget( 'reza_widget_blog_featured' );
}

class reza_widget_blog_featured extends WP_Widget {
 	function __construct() {
		parent::__construct(
			'bazinews_post_featured',
			 esc_html__('Theme','reza').' - '. esc_html__('Blog Glider', 'reza') 
		);
	}
 
 
 	public  function option(){
		$option=array();
      	$option[]=array(
				'name' =>__('Title' , 'reza' ),
 				'id' => 'title',
 				'type' => 'text'
		);
		$option[]= array( 
			"name"			=> esc_html__('Number of Posts to show','reza'),
			"id"			=> "number",
 			"type"			=> "number",
			  
		);
	
		 
		$option[]= array( 
			"name"			=> esc_html__('Category','reza'),
			"id"			=> "cats",
			"type"			=> "select",
			"options"		=>  reza_category_array_options('cats'),						
		);
			
		$option[]= array( 
			"name"			=> esc_html__('Orderby','reza'),
			"id"			=> "orderby",
			"type"			=> "select",
			"options"		=>  reza_array_options('orderby'),						
		); 		
		$option[]= array( 
			"name"			=> esc_html__('Platforms','reza'),
			"id"			=> "platforms",
			"type"			=> "select",
			"options"		=>  reza_category_array_options('platforms'),						
		); 
		$option[]= array( 
				"name"			=> esc_html__('Show Title Posts','reza'),
				"id"			=> "post_title",
				"type"			=> "checkbox",
		);
		
 		$option[]= array( 
			"name"			=> esc_html__('Limit Title length','reza'),
			"id"			=> "title_limit", 	
			"type"			=> "number",
		); 

 
	 
		
		$option[]= array( 
				"name"			=> esc_html__('Show Excerpt Posts','reza'),
				"id"			=> "excerpt",
				"type"			=> "checkbox",
		);
		
		$option[]= array( 
			"name"			=> esc_html__('Limit Excerpt length','reza'),
			"id"			=> "excerpt_limit",
			"type"			=> "number",
		); 
		
		
		
		$option[]= array( 
				"name"			=> esc_html__('Show Category Meta','reza'),
				"id"			=> "meta_category",
				"type"			=> "checkbox",
		);
		
		$option[]= array( 
				"name"			=> esc_html__('Show Author Meta','reza'),
				"id"			=> "meta_author",
				"type"			=> "checkbox",
		);
			
		$option[]= array( 
				"name"			=> esc_html__('Show Date Meta','reza'),
				"id"			=> "meta_date",
				"type"			=> "checkbox",
		);
		
		$option[]= array( 
				"name"			=> esc_html__('Show View Meta','reza'),
				"id"			=> "meta_view",
				"type"			=> "checkbox",
		);	
	
		$option[]= array( 
				"name"			=> esc_html__('Show Comments Meta','reza'),
				"id"			=> "meta_comments",
				"type"			=> "checkbox",
		);	
		
		$option[]= array( 
			"name"			=> __('Icon in Hover post','reza'),
			"id"			=> "hover_post_icon",
			"type"			=> "select",
			"options"		=>  array(
									'' 		=>   __('Default', 'reza' ),
									'show'	=>   __('Show', 'reza' ),
									'hide'	=>   __('Hide', 'reza' ),
						)					
		);  		
		
	 
		$column=__('Column','reza');
	 /**********************Layout************************/
		$option[]= array( 
			"name"			=> esc_html__('Columns','reza'),
			"id"			=> "column",
			"type"			=> "select",
			"options"		=> array(
					"1"	=> "1 $column", 
					"2"	=> "2 $column", 
					"3"	=> "3 $column", 
 				),
					
					  
		); 
		$option[]= array( 
			"name"			=> esc_html__('Column Width in Tablet and Mobile','reza'),
			"id"			=> "responsive_column",
			"type"			=> "select",
			"options" 		=> reza_array_options('responsive_column',true), 
 		); 	
	 
  			
		$option[]= array( 
			"name"			=> esc_html__('Space Between Item','reza'),
			"id"			=> "between",
			"type"			=> "select",
			"default"		=>  '',
			"options"		=>  reza_array_options('between',true),						
		);
		
	 
		$option[]= array( 
			"name"			=> esc_html__('Image Ratio','reza'),
			"id"			=> "ratio",
 			"type"			=> "select",
			"options"		=>  reza_array_options('ratio',true),						
			
		); 	 
	
	 
		
		$option[]= array( 
			"name"			=> esc_html__('Image Size','reza'),
			"id"			=> "thumb",
			"type"			=> "select",
			"default"		=>  'full',
			"options" 		=>	reza_all_image_sizes(),
			 
		); 	  
	 
	 
		$option[]= array( 
			'name'			=> esc_html__('Details Alignment','reza'),
			'id'			=> 'alignment',
			"type"			=> "select",
 			"options"		=>  reza_array_options('alignment_justify_rtl',true),						
		 
		); 
		$option[]= array( 
			"name"			=> esc_html__('Box Layout','reza'),
			"id"			=> "box_layout", 		
			"type"			=> "select",
			"options"		=>  reza_array_options('box_layout',true),						
		); 		
	 
 
		return $option;
    }
   /********** Update the widget info from the admin panel *******/
 	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
  		return	reza_widget_options_save( $new_instance, $old_instance,$this->option() );
 	}
 
	/********** Display the widget update form *******/
 	public function form( $instance ) { 
		$defaults = array( 'title'=>__('Title' , 'reza' ),'number' => '5','post_title'=>1, 'thumb' => 'full' );
		$instance = wp_parse_args( (array) $instance, $defaults );
 
		reza_widget_options($instance,$this->id_base,$this->number,$this->option());
  
 	}
 
    /**********  The widget For Display *******/
 	public function widget( $args, $instance ) {
		extract( $args );
 		$title = apply_filters( 'widget_title', $instance[ 'title' ] );
 		$rabo_data =$instance;
 		$count = 0;
		 $args=array();
  		$args['key'] = 'widget_blog_featured';
  		$column = !empty( $instance['column'] ) ? $instance['column'] : '1';
		
		$args['option'] =array(
 			'title' => !empty( $instance['title'] ) ? $instance['title'] : '',				
 			'number' => !empty( $instance['number'] ) ? $instance['number'] : '5',
 			'cats' => !empty( $instance['cats'] ) ? $instance['cats'] : '',
 			'orderby' => !empty( $instance['orderby'] ) ? $instance['orderby'] : '',
 			'platforms' => !empty( $instance['platforms'] ) ? $instance['platforms'] : '',
			'post_title' => 1,
			'ignore_sticky_posts'=> true,
  			'post_title' => !empty( $instance['post_title'] ) ? $instance['post_title'] : '',
  			'excerpt' => !empty( $instance['excerpt'] ) ? $instance['excerpt'] : '',
  			'excerpt_limit' => !empty( $instance['excerpt_limit'] ) ? $instance['excerpt_limit'] : '',
			'title_limit' => !empty( $instance['title_limit'] ) ? $instance['title_limit'] : '',
			'meta_category' => !empty( $instance['meta_category'] ) ? $instance['meta_category'] : '', 			
   			'meta'  =>  array( 
				'meta_author' => !empty( $instance['meta_author'] ) ? $instance['meta_author'] : '', 
				'meta_date' =>  !empty( $instance['meta_date'] ) ? $instance['meta_date'] : '',
				'meta_view' =>  !empty( $instance['meta_view'] ) ? $instance['meta_view'] : '',
				'meta_comments' =>  !empty( $instance['meta_comments'] ) ? $instance['meta_comments'] : '',
			),
 			'hover_post_icon' => !empty( $instance['hover_post_icon'] ) ? $instance['hover_post_icon'] : '',
 			'layout' 		=>  'featured_'.$column,
  			'responsive_column'=> !empty( $instance['responsive_column'] ) ? $instance['responsive_column'] : '',	
			'between'=> !empty( $instance['between'] ) ? $instance['between'] : '2px',	
 			'thumb' => !empty( $instance['thumb'] ) ? $instance['thumb'] : 'full',
			'ratio' => !empty( $instance['ratio'] ) ? $instance['ratio'] : '',
 			'image_width' => !empty( $instance['image_width'] ) ? $instance['image_width'] : '',
			'alignment' => !empty( $instance['alignment'] ) ? $instance['alignment'] : '',
 			'vertical' => !empty( $instance['vertical'] ) ? $instance['vertical'] : '',
 			 
		) ; 
 
 
		global $smof_data; 
		?>
		<div id="<?php echo esc_attr($widget_id) ?>" class="rd-element-blog_1 rd-widget-post rd-element-item">
 			 <?php 	echo reza_blog_featured_config($args, true);?>
		</div>
	<?php 
	
	}
	
  
} 