<?php
if(is_admin()){

/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Product Carousel
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_element_item', 'reza_element_item_product_carousel');
function reza_element_item_product_carousel( $element ) {
 	
 	$element[]= array(
 		'name'			=> 	esc_html__('Product Carousel','reza'),
 		'id'			=> 'bazinews_product_carousel',
		'group'			=> esc_html__('Theme','reza'),
		'img'			=>  REZA_DIR.'/admin/assets/images/element-product-carousel.jpg',
  	); 
	return $element;
}  
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Product Carousel Options
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_element_options_bazinews_product_carousel', 'reza_product_carousel_options');
function reza_product_carousel_options( $option ) {
 	 
	$element='product_carousel';
	$option[]= array( 
 		"group"			=>  esc_html__('General','reza'),		  
	);	
	$option[]= array( 
 		"group"			=>  esc_html__('Slider','reza'),		  
	);
	$option[]= array( 
 		"group"			=>  esc_html__('Layout','reza'),		  
	);	
 			
	 $option[]= array( 
 		"group"			=>  esc_html__('Title Box','reza'),		  
	);	
 
	$option[]= array( 
 		"group"			=>  esc_html__('Product Style','reza'),		  
	);		
 
	$option[]= array( 
 		"group"			=>  esc_html__('Typography','reza'),		  
	);	
	$option[]= array( 
 		"group"			=>  esc_html__('Attribute','reza'),		  
	);							
	
	 
     	
   	include REZA_PATH . '/sao-builder/product/sao-product-general.php'; 
	
	 
	 
	include REZA_PATH . '/sao-builder/general/sao-slider.php'; 
	
	$option[]= array( 
		"name"			=> esc_html__('Layout','reza'),
 		"id"			=> "layout",
 		"group"			=>  esc_html__('Layout','reza'),
  		"default"		=> 'list',
		"type"			=> "radio_image",
   		"options"		=>  array( 
  			"list"		=> REZA_DIR.'/admin/assets/images/list/list_1.jpg',
 			"grid"		=> REZA_DIR.'/admin/assets/images/grid/grid_1.jpg',
  		  
 		),						
				  
	); 
$column=__('Column','reza');
	$option[]= array( 
		"name"			=> esc_html__('Column Layout','reza'),
 		"id"			=> "column",
 		"group"			=>  esc_html__('Layout','reza'),
  		"default"		=> '3',
		"type"			=> "select",
   		"options"		=>  array( 
 			"1"	=> "1 $column", 
 			"2"	=> "2 $column", 
 			"3"	=> "3 $column", 
 			"4"	=> "4 $column",  
 			"5"	=> "5 $column", 
 			"6"	=> "6 $column", 
			"7"	=> "7 $column", 
 			"8"	=> "8 $column", 
 		  
 		),						
				  
	);  
	
	
	$option[]= array( 
		"name"			=> __('Row Layout','reza'),
 		"id"			=> "row",
 		"group"			=>  esc_html__('Layout','reza'),
  		"default"		=> '1',
		"type"			=> "select",
   		"options"		=>  array( 
 			"1"	=> 1, 
 			"2"	=> 2, 
 			"3"	=> 3,  
 		  
 		),						
				  
	);   	   
	
	
	
	$option[]=  array( 
		"name"			=> esc_html__('Column Width in Tablet and Mobile','reza'),
 		"id"			=> "responsive_column",
 		"group"			=>  esc_html__('Layout','reza'),
 		"type"			=> "select",
		"options"		=>  array(
				''						=>	esc_html__('Default','reza'),
				"150"			=> '150px',
   				"200"			=> '200px',
   				"250"			=> '250px',
   				"300"			=> '300px',
   				"350"			=> '350px',
   				"400"			=> '400px',    
				)
 	);
	
 	   
   	include REZA_PATH . '/sao-builder/product/sao-product-layout.php'; 
	
 	
	include REZA_PATH . '/sao-builder/general/sao-title-box.php'; 
 	include REZA_PATH . '/sao-builder/product/sao-product-style.php'; 
 	include REZA_PATH . '/sao-builder/product/sao-product-typography.php'; 
   	include REZA_PATH . '/sao-builder/general/sao-element.php';
  	 
 
    return $option;
} 
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Product Carousel Preview
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_builder_perview_bazinews_product_carousel', 'reza_builder_perview_product_carousel');
function reza_builder_perview_product_carousel( $args ) {
	 
	
  		$key = $args['key'];
 		$option = $args['option'];
		$output='';
		$css='';
			 if(!empty($option['title'])){
			$output.='<h4 class="rd-perview-header">'.$option['title'] .'</h4>'; 
		}
		if(!empty($option['layout']) && !empty($option['column'])){
			$output.='<img src="'.REZA_DIR.'/admin/assets/images/'.$option['layout'].'-carousel/'.$option['layout'].'_carousel_'.esc_attr($option['column']).'.jpg">'; 
		}
	$css.= '.sao-element-'.$key.' {text-align: center;width: 100%;}'; 
  	$return['css']= $css;
	$return['output']= $output;
		return $return;
}
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Product Carousel Config
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_builder_bazinews_product_carousel', 'reza_product_carousel_config');
function reza_product_carousel_config($args,$out = false) {
 
	$option = $args['option'];
	$key = $args['key']; 
	wp_reset_query();
	wp_reset_postdata();
	if(reza_element_show($option)=='show'){
		
 		$option['post_type']='product';
 		$layout =!empty($option['layout'])?$option['layout']:'list';
		$column =!empty($option['column'])?$option['column']:3;
		$row =!empty($option['row'])?$option['row']:1;
		$row_class =!empty($row )? 'rd_row_'.$row :'';

 		$between_class =!empty($option['between'])? $option['between']:reza_option('bazinews_product_between');
		$ratio_class =!empty($option['ratio'])?$option['ratio']:reza_option('bazinews_product_ratio');
		$alignment_class =!empty($option['alignment'])?$option['alignment']:reza_option('bazinews_product_alignment');
		$image_width =!empty($option['image_width'])? $option['image_width']:reza_option('bazinews_product_image_width');
		$second_image_class =!empty($option['second_image'])?'rd-has-second':'';
		$box_layout =!empty($option['box_layout'])?  $option['box_layout']:reza_option('bazinews_product_box_layout');
		$custom_class = !empty( $option['custom_class']) ? $option['custom_class'] : '';	
		
		
  		
		
		if($row=='3'){
			$ajax_load='slider_3';
		}elseif($row=='2'){
			$ajax_load='slider_2';
		}else{
			$ajax_load='main';
		}
				 
		$layout_class='';
		if($layout=='list'){
			$layout_class ='rd_img_width_'.$image_width;
			
		}  
		$classes = array(
			'rd-el-'.$key,
			'rd-slider',
			'rd-ajax-tab',
 			'rd-gap-'.$between_class,
			$ratio_class,
			reza_between_border($option,$box_layout ),		
			
			$second_image_class,
			'rd-align-'.reza_rtl_has($alignment_class),
			'rd-'.$box_layout,
			'woocommerce',
 			$layout_class,
 			$row_class,
 			reza_element_show($option,true),
			$custom_class		
		);
		
		ob_start(); 
 		?>
		
		 <aside class="<?php echo esc_attr(join( ' ', $classes ));?> " <?php echo reza_el_cssanime($option);?> >
			
            
            
            
 			<?php reza_post_title_tabs($option,'reza_post_'.$layout.'_'.$ajax_load);?>
			
			<div class="rd-gap-slider">
            	<div class="rd-gap-content ">
                <div class="rd-gap-warp dragscroll <?php  echo esc_attr(reza_post_carousel_class($option));?>">
                
                     <div class="rd-item-list rd-aw rd-item-carousel ">
                        
						<?php 
                        if($layout=='list'){
                             if($row=='1') reza_post_list_main($option); 
                             if($row=='2') reza_post_list_slider_2($option); 
                             if($row=='3')  reza_post_list_slider_3($option); 
                        }
                        if($layout=='grid'){
                              if($row=='1') reza_post_grid_main($option); 
                              if($row=='2')	reza_post_grid_slider_2($option); 
                              if($row=='3') reza_post_grid_slider_3($option); 
            
                        }
                        ?>
                        
                     </div>
                     
                     
                     
                    
                </div>
                </div>
                    
				<?php if(!empty($option['arrows'])  && empty(reza_ismobile())){?>
					<div class="rd-arrow-warp"><a class="rd-arrow-prev"></a><a class="rd-arrow-next"></a></div>
				<?php }?>
 
			</div>
 
               
			<?php
            $slider_options = array(); 	
            $slider_options['speed']=  !empty($option['speed']) ? $option['speed'] : '1000';
            $slider_options['pause']= !empty($option['pause']) ? $option['pause'] : '5000';
            $slider_options['between']=   '0';	
            $slider_options['pager']= true;
            $slider_options['timer']= false;	
            $slider_options['controls']=!empty($option['arrows']) ? true : '';
            $slider_options['auto']=  !empty($option['auto']) ? true : '';
            reza_lightslider($column,$slider_options);
			?>    
		   
		</aside> 
	
	 
	 <?php
		$item = '.rd-el-'.$key.'';
		$item_css = reza_title_box_css($option,$item);
		$item_css.= reza_post_css($option,$item);
		$item_css.= reza_product_css($option,$item);
 		$item_css.= reza_arrow_layout_css($option);
		$item_css.= reza_element_padding($option);
 		 
		$css =reza_item_css($item_css,$item);
		
		$return['output']=  ob_get_clean();
		$return['css']= $css;
		$return['emptybefore']= true;
		$return['emptyafter']= true;
	
	if( !empty($out)){
			$output = $return['output'];
			$output.=!empty($return['css'])?'<style>'.$return['css'].'</style>':'';
			return $output;
		}else{
			return $return;	
		}
	}
} 