<?php
if(is_admin()){

/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Product
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_element_item', 'reza_element_item_product');
function reza_element_item_product( $element ) {
 	
 	$element[]= array(
 		'name'			=> 	esc_html__('Product','reza'),
 		'id'			=> 'bazinews_product',
		'group'			=> esc_html__('Theme','reza'),
		'img'			=>  REZA_DIR.'/admin/assets/images/element-product.jpg',
  	); 
			
	return $element;
}  
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Product Options
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_element_options_bazinews_product', 'reza_product_options');
function reza_product_options( $option ) {
	$element='product';

				
	$option[]= array( 
 		"group"			=>  esc_html__('General','reza'),		  
	);	
	$option[]= array( 
 		"group"			=>  esc_html__('Layout','reza'),		  
	);	
	
 
	
	 $option[]= array( 
 		"group"			=>  esc_html__('Title Box','reza'),		  
	);	
 
	$option[]= array( 
 		"group"			=>  esc_html__('Product Style','reza'),		  
	);		
  	
	$option[]= array( 
 		"group"			=>  esc_html__('Typography','reza'),		  
	);	
	$option[]= array( 
 		"group"			=>  esc_html__('Attribute','reza'),		  
	);							
	
	 
     	
   	include REZA_PATH . '/sao-builder/product/sao-product-general.php'; 

	$option[]= array( 
		"name"			=> esc_html__('More Posts','reza'),
 		"id"			=> "more_posts",
		"type"			=> "select",
 		"options"		=>   array( 
			""			=> 	__('None','reza'),
			"load_more"		=> 	__('Load More','reza'),
			"pagenavi"		=>  esc_html__('Page Number','reza'),
  			 
		),										
		
 	);    
	$option[]= array( 
		"name"			=> esc_html__('Layout','reza'),
 		"id"			=> "layout",
 		"group"			=>  esc_html__('Layout','reza'),
  		"default"		=> 'list',
		"type"			=> "radio_image",
   		"options"		=>  array( 
  			"list"		=> REZA_DIR.'/admin/assets/images/list/list_1.jpg',
 			"grid"		=> REZA_DIR.'/admin/assets/images/grid/grid_1.jpg',
   		  
 		),						
				  
	); 
	
 	
	$option[]= array( 
		"name"			=> esc_html__('List Layout','reza'),
 		"id"			=> "list_layout",
 		"group"			=>  esc_html__('Layout','reza'),
  		"default"		=> 'list_1',
 		"fold"			=>	array( 	
  			"list"				=> "layout",
   		), 
		"type"			=> "radio_image",
   		"options"		=>  array( 
 			"list_1"	=> REZA_DIR.'/admin/assets/images/list/list_1.jpg',
 			"list_2"	=> REZA_DIR.'/admin/assets/images/list/list_2.jpg',
 			"list_3"	=> REZA_DIR.'/admin/assets/images/list/list_3.jpg',
 			"list_4"	=> REZA_DIR.'/admin/assets/images/list/list_4.jpg',
 		  
 		),						
				  
	); 
	

	$option[]= array( 
		"name"			=> esc_html__('Grid Layout','reza'),
 		"id"			=> "grid_layout",
 		"group"			=>  esc_html__('Layout','reza'),
  		"default"		=> 'grid_3',
 		"fold"			=>	array( 	
  			"grid"				=> "layout",
   		), 
		"type"			=> "radio_image",
   		"options"		=>  array( 
 			"grid_1"	=> REZA_DIR.'/admin/assets/images/grid/grid_1.jpg',
 			"grid_2"	=> REZA_DIR.'/admin/assets/images/grid/grid_2.jpg',
 			"grid_3"	=> REZA_DIR.'/admin/assets/images/grid/grid_3.jpg',
 			"grid_4"	=> REZA_DIR.'/admin/assets/images/grid/grid_4.jpg',
 			"grid_5"	=> REZA_DIR.'/admin/assets/images/grid/grid_5.jpg',
 			"grid_6"	=> REZA_DIR.'/admin/assets/images/grid/grid_6.jpg',
 			"grid_7"	=> REZA_DIR.'/admin/assets/images/grid/grid_7.jpg',
 			"grid_8"	=> REZA_DIR.'/admin/assets/images/grid/grid_8.jpg', 
 			"grid_8"	=> REZA_DIR.'/admin/assets/images/grid/grid_8.jpg',
 			"grid_9"	=> REZA_DIR.'/admin/assets/images/grid/grid_9.jpg',
 			"grid_10"	=> REZA_DIR.'/admin/assets/images/grid/grid_10.jpg',
 			"grid_11"	=> REZA_DIR.'/admin/assets/images/grid/grid_11.jpg',
 			"grid_12"	=> REZA_DIR.'/admin/assets/images/grid/grid_12.jpg',
 			"grid_13"	=> REZA_DIR.'/admin/assets/images/grid/grid_13.jpg',
 			"grid_14"	=> REZA_DIR.'/admin/assets/images/grid/grid_14.jpg',
 			"grid_15"	=> REZA_DIR.'/admin/assets/images/grid/grid_15.jpg',
 		),						
				  
	); 
	$option[]=  array( 
		"name"			=> esc_html__('Column in Tablet and Mobile','reza'),
 		"id"			=> "responsive_column",
 		"group"			=>  esc_html__('Layout','reza'),
 		"type"			=> "select",
		"options" 		=> reza_array_options('first_responsive_column',true), 

	);
 
		 
	 	
 	include REZA_PATH . '/sao-builder/product/sao-product-layout.php'; 
 	
	include REZA_PATH . '/sao-builder/general/sao-title-box.php'; 
 	include REZA_PATH . '/sao-builder/product/sao-product-style.php'; 
 	include REZA_PATH . '/sao-builder/product/sao-product-typography.php'; 
   	include REZA_PATH . '/sao-builder/general/sao-element.php';
  	 
 
    return $option;
} 
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Product Preview
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_builder_perview_bazinews_product', 'reza_builder_perview_product');
function reza_builder_perview_product( $args ) {
 	
	$key = $args['key'];
	$option = $args['option'];
	$output='';
	$css='';
	if(!empty($option['title'])){
		$output.='<h4 class="rd-perview-header">'.$option['title'] .'</h4>'; 
	}
	if(!empty($option['layout'])){
		if($option['layout'] =='list' && !empty($option['list_layout'])){
				$output.='<img src="'.REZA_DIR.'/admin/assets/images/list/'.esc_attr($option['list_layout']).'.jpg">'; 
		}
		if($option['layout'] =='grid' && !empty($option['grid_layout'])){
			$output.='<img src="'.REZA_DIR.'/admin/assets/images/grid/'.esc_attr($option['grid_layout']).'.jpg">'; 
		}
	}
	$css.= '.sao-element-'.$key.' {text-align: center;width: 100%;}'; 
  	$return['css']= $css;
	$return['output']= $output;
	return $return;
}
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Product Config
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_builder_bazinews_product', 'reza_product_config');
function reza_product_config( $args,$out = false) {
 	wp_reset_query();
	wp_reset_postdata();
	$option = $args['option'];
	$key = $args['key']; 
	
	if(reza_element_show($option)=='show'){
		$option['post_type']='product';
		$more_posts =!empty($option['more_posts'])? $option['more_posts']:'';
		$data_key=$more_posts =="pagenavi"?' data-key="'.$key.'" ':'';
		
		
		$layout =!empty($option['layout'])?$option['layout']:'list';
		
		$between_class =!empty($option['between'])? $option['between']:reza_option('bazinews_product_between');
		$ratio_class =!empty($option['ratio'])?$option['ratio']:reza_option('bazinews_product_ratio');
		$ratio_second_class =!empty($option['ratio_2'])?$option['ratio_2'].'-second':'';
		
		
		$alignment_class =!empty($option['alignment'])?$option['alignment']:reza_option('bazinews_product_alignment');
		$image_width =!empty($option['image_width'])? $option['image_width']:reza_option('bazinews_product_image_width');
		$second_image_class =!empty($option['second_image'])?'rd-has-second':'';
		$box_layout =!empty($option['box_layout'])?  $option['box_layout']:reza_option('bazinews_product_box_layout');
		$custom_class = !empty( $option['custom_class']) ? $option['custom_class'] : '';			 
		 $layout_class='';
		if($layout=='list'){
			$layout_class ='rd_img_width_'.$image_width;
			
		} 
 
		$classes = array(
			'rd-el-'.$key,
			'rd-ajax-tab',
			'woocommerce',
			'rd-gap-'.$between_class,
			$ratio_class,
			reza_between_border($option,$box_layout ),		
			
			$ratio_second_class,
			$second_image_class,
 			'rd-align-'.reza_rtl_has($alignment_class),
			'rd-'.$box_layout,
			$layout_class,
			reza_element_show($option,true),
			$custom_class		
	
		);
		
		
		ob_start(); 
		?>
		
		 <aside <?php  reza_el_id($option);?> class="<?php echo esc_attr(join( ' ', $classes ));?> " <?php echo reza_el_cssanime($option).wp_kses_post($data_key);?> >
			
 			<?php reza_post_title_tabs($option,'reza_post_'.$layout);?>
			<div class="rd-gap-content">
 			<div class="rd-gap-warp">
			
 
                <div class="rd-item-list rd-aw rd-flex <?php  echo esc_attr(reza_post_class($option));?>">
				 
					<?php 
					if($layout=='list'){
						reza_post_list($option);
					}
					if($layout=='grid'){
						 reza_post_grid($option);
					}
 					?>
					
				</div>
				
             
				<?php 
				if($more_posts == 'load_more'){
					reza_load_more($option,'reza_post_'.$layout);						
				}elseif($more_posts =="pagenavi"){
					reza_pagenavi($option);  
				}	
				?>
 				
 			</div>
			</div>
		</aside> 
	
	 
		<?php
		$item = '.rd-el-'.$key.'';
		$item_css = reza_title_box_css($option,$item);
		$item_css.= reza_post_css($option,$item);
		$item_css.= reza_product_css($option,$item);
		$item_css.= reza_element_padding($option);
		$css =reza_item_css($item_css,$item);
		$return['output']=  ob_get_clean();
		$return['css']= $css;
		$return['emptybefore']= true;
		$return['emptyafter']= true;
	
		if( !empty($out)){
			$output = $return['output'];
			$output.=!empty($return['css'])?'<style>'.$return['css'].'</style>':'';
			return $output;
		}else{
			return $return;	
		}
	}
} 