<?php
if(is_admin()){
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Comments
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_element_item', 'reza_element_item_comments');
function reza_element_item_comments( $element ) {
 	
 	$element[]=  array(
 		'name'			=> 	esc_html__('Comments','reza'),
 		'id'			=> 'bazinews_comments',
		'group'			=> esc_html__('Theme','reza'),
		'img'			=>  REZA_DIR.'/admin/assets/images/element-comments.jpg',
		
   	); 
  
	return $element;
}  
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Comments Options
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_element_options_bazinews_comments', 'reza_comments_options');
function reza_comments_options( $option ) {
  
	$option[]= array( 
		"name"			=> esc_html__('Comments Layout','reza'),
 		"id"			=> "comments_layout_type",
		"group"			=>  esc_html__('Layout','reza'),
		
  		"type"			=> "select",
 		"options"		=>  array(
			"" 				=>  esc_html__('Default','reza'),
			'rd-thread' 	=> esc_html__('Thread' , 'reza'),
			'rd-list' 		=> esc_html__('List' , 'reza'),
		),						
 	);	
 
	$option[]= array( 
		"name"			=> esc_html__('Box Layout','reza'),
 		"id"			=> "box_layout",
		"group"			=>  esc_html__('Layout','reza'),
 		"type"			=> "select",
 		"options" 		=>	array(
			"" 				=>  esc_html__('Default','reza'),
			"none"			=> esc_html__('None','reza'),
 			"boxed" 		=> esc_html__('Boxed','reza'),
    		 ),
  	); 	

 	$option[]= array( 
		"name"			=> __('Field Height','reza'),
 		"id"			=> "height",
  		"group"			=>  __('Layout','reza'),
 		"type"			=> "number",
  	);	
	
	$option[]= array( 
		"name"			=> __('Textarea Height','reza'),
 		"id"			=> "textarea_height",
  		"group"			=>  __('Layout','reza'),
 		"type"			=> "number",
  	);		
	
	
	$option[]= array( 
		"name"			=> __('Background Color','reza'),
 		"id"			=> "background_color",
		"group"			=>  esc_html__('Style','reza'),
 		"type"			=> "color_rgba",
	);
	$option[]= array( 
		"name"			=> __('Author Color','reza'),
 		"id"			=> "author_color",
		"group"			=>  esc_html__('Style','reza'),
 		"type"			=> "color",
	); 		
	$option[]= array( 
		"name"			=> __('Label Color','reza'),
 		"id"			=> "label_color",
		"group"			=>  esc_html__('Style','reza'),
 		"type"			=> "color",
	); 	
	$option[]= array( 
		"name"			=> __('Text Color','reza'),
 		"id"			=> "text_color",
		"group"			=>  esc_html__('Style','reza'),
 		"type"			=> "color",
	); 		 
 					 
	

 
	$option[]= array( 
		"name"			=> __('Field Background Color','reza'),
 		"id"			=> "field_background_color",
		"group"			=>  esc_html__('Style','reza'),
 		"type"			=> "color_rgba",
	); 	
	$option[]= array( 
		"name"			=> __('Field Text Color','reza'),
 		"id"			=> "field_text_color",
		"group"			=>  esc_html__('Style','reza'),
 		"type"			=> "color",
	); 		 
 					
 
	
	$option[]= array( 
		"name"			=> __('Button color','reza'),
 		"id"			=> "button_color",
		"group"			=>  esc_html__('Style','reza'),
		"type"			=> "multi_options",
		"options"			=>	array( 	
							array( 
								"name"			=> 	__('Background Color','reza'),
								"id"			=> "background",
								"type"			=> "color_rgba",
							),	
							array( 
								"name"			=> __('Text Color','reza'),			
								"id"			=> "text",
								"type"			=> "color_rgba",
							), 
					),						
	); 	 
 	 
	$option[]= array( 
		"name"			=> __('Border Color','reza'),
 		"id"			=> "border_color",
		"group"			=>  esc_html__('Style','reza'),
 		"type"			=> "color_rgba",
	); 	 
	
	$option[]= array( 
		"name"			=> __('Box Sahdow Color','reza'),
 		"id"			=> "box_border_color",
		"group"			=>  esc_html__('Style','reza'),
 		"type"			=> "color_rgba",
	); 	 
	
	$option[]= array(
		"name"			=> esc_html__('Input and Button Border Radius','reza'),
		"id"			=> "border_radius", 
		"type"		=> "select",
		"group"			=>  esc_html__('Style','reza'),
		"options"	=>  reza_array_options('radius',true),
	);
	$option[] = array(
		"name" 		=> esc_html__('Border Radius' , 'reza'),
		"id" 		=> "radius",
		"type"		=> "select",
		"group"		=>  esc_html__('Style','reza'),
		"options"	=>  reza_array_options('radius_mini',true),
	);   		
				
  	$option[]= array( 
		"name"			=> esc_html__('Author Typography','reza'),
 		"id"			=> "author_typo",
  		"group"			=>  esc_html__('Typography','reza'),
   		"type"			=> "multi_options",
		"options"		=>	reza_multi_array_options('typo')
		 
	);	
$option[]= array( 
		"name"			=> esc_html__('Comments Typography','reza'),
 		"id"			=> "comments_typo",
  		"group"			=>  esc_html__('Typography','reza'),
   		"type"			=> "multi_options",
		"options"		=>	reza_multi_array_options('typo')
		 
	);
	$option[]= array( 
		"name"			=> esc_html__('Text Typography','reza'),
 		"id"			=> "text_typo",
  		"group"			=>  esc_html__('Typography','reza'),
   		"type"			=> "multi_options",
		"options"		=>	reza_multi_array_options('typo')
		 
	);
	include REZA_PATH . '/sao-builder/general/sao-element.php';

    return $option;
 
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Comments Preview 
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_builder_perview_bazinews_comments', 'reza_builder_perview_comments');
function reza_builder_perview_comments( $args ) {
	 
	$key = $args['key'];
	$option = $args['option'];
	$output='';
	$css='';
		 
	$output.='<img src="'.REZA_DIR.'/admin/assets/images/element-comments.jpg">'; 
 			 
	$css.= '.sao-element-'.$key.' {text-align: center;width: 100%;}'; 
  	$return['css']= $css;
	$return['output']= $output;
	return $return;
}
}
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Comments Config
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_builder_bazinews_comments', 'reza_comments_config');
function reza_comments_config( $args , $out = false ) {
  	wp_reset_query();
	wp_reset_postdata(); 
 	$option = $args['option'];
	$key = $args['key'];
	if(reza_element_show($option)=='show'){
		$output='';
		$css ='';
		global $smof_data;
		$comments_layout_type = !empty( $option['comments_layout_type']) ? $option['comments_layout_type'] : reza_option('comments_layout_type');
		$box_layout =!empty($option['box_layout'])? $option['box_layout']:reza_option('blog_box_layout');
		$box_layout_class = $box_layout!=='none'?'rd-single-boxed':'rd-none';
 		$custom_class = !empty( $option['custom_class']) ? $option['custom_class'] : '';
	
		$classes = array(
			'rd-el-'.$key,
			'rd-comments',
			'rd-have-comments',
			$comments_layout_type,
			'rd-gap-20',
			'rd-aw',
				$box_layout_class,
			reza_element_show($option,true),
			$custom_class		
		);
	
		ob_start(); 
		?>
	 
		<aside <?php  reza_el_id($option);?>  class="<?php echo esc_attr(join( ' ', $classes ));?> " <?php echo reza_el_cssanime($option);?>>
 			<?php comments_template(  '/inc/el-comments.php', true ); ?>
		</aside>
	 
		<?php
 		$item = '.rd-el-'.$key.'';
	 
		$item_css=
			reza_var_unit('--rd-input-ht',$option,'height').
			reza_var_unit('--rd-textarea-ht',$option,'textarea_height').
			reza_var('--rd-post-bg',$option,'background_color').
			reza_var('--rd-main-hl',$option,'author_color').
			reza_var('--rd-main-lk',$option,'label_color').
			reza_var('--rd-main-txt',$option,'text_color').
			reza_var('--rd-form-bg',$option,'field_background_color').
			reza_var('--rd-form-txt',$option,'field_text_color').
			reza_var('--rd-main-br-cr',$option,'border_color').
			reza_var_2('--rd-primary-bg',$option,'button_color','background').
			reza_var_2('--rd-primary-txt',$option,'button_color','text').
			reza_var('--rd-mian-btn-rd',$option,'border_radius').
			reza_var('--rd-post-sd',$option,'box_border_color').
			reza_var('--rd-main-rd',$option,'textarea_radius').
			reza_var_font_typo('--rd-form',$option,'text_typo').
			reza_var_font_typo('--rd-at',$option,'author_typo').
			reza_var_font_typo('--rd-cm',$option,'comments_typo');
			
		$item_css.= reza_element_padding($option);
		$css =reza_item_css($item_css,$item);
		$return['output']=  ob_get_clean();
		$return['css']= $css;
		$return['emptybefore']= true;
		$return['emptyafter']= true;
	
		if( !empty($out)){
			$output = $return['output'];
			$output.=!empty($return['css'])?'<style>'.$return['css'].'</style>':'';
			return $output;
		}else{
			return $return;	
		}
	}
}
 