<?php
if(is_admin()){
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_element_item', 'reza_element_item_blog_text');
function reza_element_item_blog_text( $element ) {
 	
 	$element[]=  array(
 		'name'			=> 	esc_html__('Blog Text','reza'),
 		'id'			=> 'bazinews_post_text',
		'group'			=> esc_html__('Theme','reza'),
		'img'			=>  REZA_DIR.'/admin/assets/images/element-blog-text.jpg',
  	); 
	
	return $element;
} 
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog Options
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_element_options_bazinews_post_text', 'reza_blog_text_options');
function reza_blog_text_options( $option) {
 
 
	$element='blog_text';
	
	
	$option[]= array( 
 		"group"			=>  esc_html__('General','reza'),		  
	);	
	$option[]= array( 
 		"group"			=>  esc_html__('Layout','reza'),		  
	);	
	 $option[]= array( 
 		"group"			=>  esc_html__('Title Box','reza'),		  
	);	
 
	$option[]= array( 
 		"group"			=>  esc_html__('Post Style','reza'),		  
	);		
 
	$option[]= array( 
 		"group"			=>  esc_html__('Typography','reza'),		  
	);		
	$option[]= array( 
 		"group"			=>  esc_html__('Attribute','reza'),		  
	);							
	
		$excerpt =true;
 	$meta_text =true;
   	$more_page_posts=true;	
 	$box_layout_text =true;
 		
   	include REZA_PATH . '/sao-builder/blog/sao-blog-general.php'; 
 
 
	$option[]= array( 
		"name"			=> esc_html__('Layout','reza'),
 		"id"			=> "layout",
 		"group"			=>  esc_html__('Layout','reza'),
  		"default"		=> 'text_1',
 		"type"			=> "radio_image",
   		"options"		=>  array( 
 			"text_1"	=> REZA_DIR.'/admin/assets/images/text/text_1.jpg',
 			"text_2"	=> REZA_DIR.'/admin/assets/images/text/text_2.jpg',
 			"text_3"	=> REZA_DIR.'/admin/assets/images/text/text_3.jpg',
 			"text_4"	=> REZA_DIR.'/admin/assets/images/text/text_4.jpg',
 		  
 		),						
				  
	); 
	
 
	$option[]=  array( 
		"name"			=> esc_html__('Column in Tablet and Mobile','reza'),
 		"id"			=> "responsive_column",
 		"group"			=>  esc_html__('Layout','reza'),
 		"type"			=> "select",
 		"options" 		=> reza_array_options('responsive_column',true), 

	);
 
		
 	
 		 
 	include REZA_PATH . '/sao-builder/blog/sao-blog-layout.php'; 
	
	include REZA_PATH . '/sao-builder/general/sao-title-box.php'; 
 	include REZA_PATH . '/sao-builder/blog/sao-blog-post-style.php'; 
 	include REZA_PATH . '/sao-builder/blog/sao-blog-typography.php'; 
  
   	include REZA_PATH . '/sao-builder/general/sao-element.php';
   	 
 
    return $option;

}
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog Preview
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_builder_perview_bazinews_post_text', 'reza_builder_perview_blog_text');
function reza_builder_perview_blog_text( $args ) {
	 
	
  		$key = $args['key'];
 		$option = $args['option'];
		$output='';
		$css='';
		if(!empty($option['title'])){
			$output.='<h4 class="rd-perview-header">'.$option['title'] .'</h4>'; 
		}
			if(!empty($option['layout'])){
				$output.='<img src="'.REZA_DIR.'/admin/assets/images/text/'.esc_attr($option['layout']).'.jpg">'; 
			}
			 
		
	$css.= '.sao-element-'.$key.' {text-align: center;width: 100%;}'; 
  	$return['css']= $css;
	$return['output']= $output;
	return $return;
}
}
  /*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog Config
																		
*/////////////////////////////////////// /////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_builder_bazinews_post_text', 'reza_blog_text_config');
function reza_blog_text_config( $args,$out=false) {
	wp_reset_query();
	wp_reset_postdata();
	$option = $args['option'];
	$key = $args['key']; 
	if(reza_element_show($option)=='show'){
		
  		$option['post_type']='post';
		$more_posts =!empty($option['more_posts'])? $option['more_posts']:'';
		$data_key=$more_posts =="pagenavi"?' data-key="'.$key.'" ':'';
		
		
		$layout ='text';
    	$option['text_layout'] = !empty($option['layout'] )?$option['layout']:'';
		$between_class =!empty($option['between'])? $option['between']:reza_option('bazinews_blog_between');
		$alignment_class =!empty($option['alignment'])?$option['alignment']:reza_option('bazinews_blog_alignment');
		$box_layout =!empty($option['box_layout'])? $option['box_layout']:reza_option('bazinews_blog_box_layout');
		$custom_class = !empty( $option['custom_class']) ? $option['custom_class'] : '';			 

		
	 
	
		$layout_class='';
 
			$layout_class.= ' rd-'.$box_layout; 	
			
		
		
		$classes = array(
			'rd-el-'.$key,
			'rd-ajax-tab',
 			reza_between_border($option,$box_layout ),
 			'rd-gap-'.$between_class,
			'rd-align-'.reza_rtl_has($alignment_class),
			$layout_class,
			$custom_class,
			reza_image_caption_effect($option),	
			reza_element_show($option,true),
		); 
		
		ob_start(); 
		?>
		
		 <aside <?php  reza_el_id($option);?> class="<?php echo esc_attr(join( ' ', $classes ));?> " <?php echo reza_el_cssanime($option).wp_kses_post($data_key);?> >
			
			
			<?php reza_post_title_tabs($option,'reza_post_'.$layout);?>
			<div class="rd-gap-content">
			<div class="rd-gap-warp">
				<div class="rd-item-list rd-flex rd-aw <?php  echo esc_attr(reza_post_text_class($option));?>">
				
					<?php 
 						reza_post_text($option);
						?>
					
				</div>
				
				
				<?php 
				if($more_posts == 'load_more'){
					reza_load_more($option,'reza_post_'.$layout);						
				}elseif($more_posts =="pagenavi"){
					reza_pagenavi($option);  
				}	
				?>
                
			</div> 
			</div> 
			
		</aside>  
		
		
		<?php
		$item = '.rd-el-'.$key.'';
		$item_css = reza_title_box_css($option,$item);
		$item_css.= reza_post_css($option,$item);
		$item_css.= reza_element_padding($option);
		$css =reza_item_css($item_css,$item);
		$return['output']=  ob_get_clean();
		$return['css']= $css;
		$return['emptybefore']= true;
		$return['emptyafter']= true;
		
		if( !empty($out)){
			$output = $return['output'];
			$output.=!empty($return['css'])?'<style>'.$return['css'].'</style>':'';
			return $output;
		}else{
			return $return;	
		}
	}
}
 