<?php
if(is_admin()){
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_element_item', 'reza_element_item_blog_list');
function reza_element_item_blog_list( $element ) {
 	
 	$element[]=  array(
 		'name'			=> 	esc_html__('Blog List','reza'),
 		'id'			=> 'bazinews_post_list',
		'group'			=> esc_html__('Theme','reza'),
		'img'			=>  REZA_DIR.'/admin/assets/images/element-blog-list.jpg',
  	); 
	
	return $element;
} 
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog Options
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_element_options_bazinews_post_list', 'reza_blog_list_options');
function reza_blog_list_options( $option) {
 
 
	$element='blog_list';
	
	
	$option[]= array( 
 		"group"			=>  esc_html__('General','reza'),		  
	);	
	$option[]= array( 
 		"group"			=>  esc_html__('Layout','reza'),		  
	);	
	 $option[]= array( 
 		"group"			=>  esc_html__('Title Box','reza'),		  
	);	
 
	$option[]= array( 
 		"group"			=>  esc_html__('Post Style','reza'),		  
	);		
 
	$option[]= array( 
 		"group"			=>  esc_html__('Typography','reza'),		  
	);		
	$option[]= array( 
 		"group"			=>  esc_html__('Attribute','reza'),		  
	);							
	
	
	
	$masonry_fold='';
	$layout_2_fold=array(	"list_5"			=> "layout",
							"list_6"			=> "layout");	
 	$meta=true;	
 	$excerpt=true;	
 	$excerpt_2=true;	
 	$more_page_posts=true;	
	$ratio =true;	
	$ratio_2 =true;	
	$image_width =true;	
	$image_width_2 =true;	
	$image_size_2 =true;	
	$box_layout =true;
	$image =true;
		
   	include REZA_PATH . '/sao-builder/blog/sao-blog-general.php'; 
 
 
	$option[]= array( 
		"name"			=> esc_html__('List Layout','reza'),
 		"id"			=> "layout",
 		"group"			=>  esc_html__('Layout','reza'),
  		"default"		=> 'list_1',
 		"type"			=> "radio_image",
   		"options"		=>  array( 
 			"list_1"	=> REZA_DIR.'/admin/assets/images/list/list_1.jpg',
 			"list_2"	=> REZA_DIR.'/admin/assets/images/list/list_2.jpg',
 			"list_3"	=> REZA_DIR.'/admin/assets/images/list/list_3.jpg',
 			"list_4"	=> REZA_DIR.'/admin/assets/images/list/list_4.jpg',
 			"list_5"	=> REZA_DIR.'/admin/assets/images/list/list_5.jpg',
 			"list_6"	=> REZA_DIR.'/admin/assets/images/list/list_6.jpg',
 		  
 		),						
				  
	); 
	
 
	$option[]=  array( 
		"name"			=> esc_html__('Column in Tablet and Mobile','reza'),
 		"id"			=> "responsive_column",
 		"group"			=>  esc_html__('Layout','reza'),
 		"type"			=> "select",
 		"options" 		=> reza_array_options('first_responsive_column',true), 

	);
 
		
 	
 		 
 	include REZA_PATH . '/sao-builder/blog/sao-blog-layout.php'; 
	
	include REZA_PATH . '/sao-builder/general/sao-title-box.php'; 
 	include REZA_PATH . '/sao-builder/blog/sao-blog-post-style.php'; 
 	include REZA_PATH . '/sao-builder/blog/sao-blog-typography.php'; 
  
   	include REZA_PATH . '/sao-builder/general/sao-element.php';
   	 
 
    return $option;

}
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog Preview
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_builder_perview_bazinews_post_list', 'reza_builder_perview_blog_list');
function reza_builder_perview_blog_list( $args ) {
	 
	
  		$key = $args['key'];
 		$option = $args['option'];
		$output='';
		$css='';
		if(!empty($option['title'])){
			$output.='<h4 class="rd-perview-header">'.$option['title'] .'</h4>'; 
		}
			if(!empty($option['layout'])){
				$output.='<img src="'.REZA_DIR.'/admin/assets/images/list/'.esc_attr($option['layout']).'.jpg">'; 
			}
			 
		
	$css.= '.sao-element-'.$key.' {text-align: center;width: 100%;}'; 
  	$return['css']= $css;
	$return['output']= $output;
	return $return;
}
}
  /*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog Config
																		
*/////////////////////////////////////// /////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_builder_bazinews_post_list', 'reza_blog_list_config');
function reza_blog_list_config( $args,$out=false) {
	wp_reset_query();
	wp_reset_postdata();
	$option = $args['option'];
	$key = $args['key']; 

	if(reza_element_show($option)=='show'){
		
  		$option['post_type']='post';
		$more_posts =!empty($option['more_posts'])? $option['more_posts']:'';
		$data_key=$more_posts =="pagenavi"?' data-key="'.$key.'" ':'';
		
		
		$layout ='list';
 	   	$option['list_layout'] = !empty($option['layout'] )?$option['layout']:'';
	
		$between_class =!empty($option['between'])? $option['between']:reza_option('bazinews_blog_between');
		$ratio_class =!empty($option['ratio'])?$option['ratio']:reza_option('bazinews_blog_ratio');
		$ratio_second_class =!empty($option['ratio_2'])?$option['ratio_2'].'-second':'';
		$alignment_class =!empty($option['alignment'])?$option['alignment']:reza_option('bazinews_blog_alignment');
		$image_width =!empty($option['image_width'])? $option['image_width']:reza_option('bazinews_blog_image_width');
		$image_width_2 =!empty($option['image_width_2'])? $option['image_width_2']:'';
		$box_layout =!empty($option['box_layout'])? $option['box_layout']:reza_option('bazinews_blog_box_layout');
		$caption_layout =!empty($option['caption_layout'])? $option['caption_layout']: reza_option('bazinews_blog_caption_layout');
 
		
		$custom_class = !empty( $option['custom_class']) ? $option['custom_class'] : '';			 
	
		$layout_class='';
			$layout_class ='rd_img_width_'.$image_width;
			if(!empty($image_width_2)){
				$layout_class.=' rd_img_width_'.$image_width_2.'-second ';
			}
			$layout_class.= ' rd-'.$box_layout; 	
			
		
		
		$classes = array(
			'rd-el-'.$key,
			'rd-ajax-tab',
 			'rd-gap-'.$between_class,
			reza_between_border($option,$box_layout ),
		
			$ratio_class,
			$ratio_second_class,
			'rd-align-'.reza_rtl_has($alignment_class),
			$layout_class,
			$custom_class,
			reza_image_caption_effect($option),	
			reza_element_show($option,true),
		); 
		
		ob_start(); 
		?>
		
		 <aside <?php  reza_el_id($option);?> class="<?php echo esc_attr(join( ' ', $classes ));?> " <?php echo reza_el_cssanime($option).wp_kses_post($data_key);?> >
			
			
			<?php 	reza_post_title_tabs($option,'reza_post_'.$layout);?>
			<div class="rd-gap-content">
			<div class="rd-gap-warp">
				<div class="rd-item-list rd-flex rd-aw <?php  echo esc_attr(reza_post_list_class($option));?>">
				
					<?php  reza_post_list($option); ?>
					
				</div>
				
				
				<?php 
				if($more_posts == 'load_more'){
					reza_load_more($option,'reza_post_'.$layout);						
				}elseif($more_posts =="pagenavi"){
					reza_pagenavi($option);  
				}	
				?>
                
			</div> 
			</div> 
			
		</aside>  
		
		
		<?php
		$item = '.rd-el-'.$key.'';
		$item_css = reza_title_box_css($option,$item);
		$item_css.= reza_post_css($option,$item);
 		$item_css.= reza_element_padding($option);
		$css =reza_item_css($item_css,$item);
		$return['output']=  ob_get_clean();
		$return['css']= $css;
		$return['emptybefore']= true;
		$return['emptyafter']= true;
		
		if( !empty($out)){
			$output = $return['output'];
			$output.=!empty($return['css'])?'<style>'.$return['css'].'</style>':'';
			return $output;
		}else{
			return $return;	
		}
	}
}
 