<?php
if(is_admin()){
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_element_item', 'reza_element_item_blog_featured_grid');
function reza_element_item_blog_featured_grid( $element ) {
 	
 	$element[]=  array(
 		'name'			=> 	__('Blog Glider and Grid','reza'),
 		'id'			=> 'bazinews_post_featured_grid',
		'group'			=> esc_html__('Theme','reza'),
		'img'			=>  REZA_DIR.'/admin/assets/images/element-blog-featured-grid.jpg',
  	); 
	
	return $element;
} 
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog Options
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_element_options_bazinews_post_featured_grid', 'reza_blog_featured_grid_options');
function reza_blog_featured_grid_options( $option) {
 
	$element='blog';
	
	
	$option[]= array( 
 		"group"			=>  esc_html__('General','reza'),		  
	);	
	$option[]= array( 
 		"group"			=>  esc_html__('Layout','reza'),		  
	);	
	 $option[]= array( 
 		"group"			=>  esc_html__('Title Box','reza'),		  
	);	
 
	$option[]= array( 
 		"group"			=>  esc_html__('Post Style','reza'),		  
	);		
 
	$option[]= array( 
 		"group"			=>  esc_html__('Typography','reza'),		  
	);		
	$option[]= array( 
 		"group"			=>  esc_html__('Attribute','reza'),		  
	);							
	$masonry_fold='';
	$layout_2_fold='';
	
	
	$excerpt_featured=true;	
 	$excerpt_grid=true;	
 
	
 	$meta=true;	
 	$more_page_posts=true;	
	
 	$ratio_featured =true;	
 	$ratio_grid =true;	
	
   	$image_size_featured =true;	
  	$image_size_grid =true;	
	
	$box_layout =true;
	$caption_layout =true;
	$image =true;
		 
		
   	include REZA_PATH . '/sao-builder/blog/sao-blog-general.php'; 
 
 	$option[]= array( 
		"name"			=> esc_html__('Layout','reza'),
 		"id"			=> "layout",
 		"group"			=>  esc_html__('Layout','reza'),
  		"default"		=> 'featured_grid_1',
 
		"type"			=> "radio_image",
   		"options"		=>  array( 
 			"featured_grid_1"	=> get_template_directory_uri().'/admin/assets/images/featured-grid/featured_grid_1.jpg',
 			"featured_grid_2"	=> get_template_directory_uri().'/admin/assets/images/featured-grid/featured_grid_2.jpg',
 			"featured_grid_3"	=> get_template_directory_uri().'/admin/assets/images/featured-grid/featured_grid_3.jpg',
 			"featured_grid_4"	=> get_template_directory_uri().'/admin/assets/images/featured-grid/featured_grid_4.jpg',
 			"featured_grid_5"	=> get_template_directory_uri().'/admin/assets/images/featured-grid/featured_grid_5.jpg',
 			"featured_grid_6"	=> get_template_directory_uri().'/admin/assets/images/featured-grid/featured_grid_6.jpg',
 			"featured_grid_7"	=> get_template_directory_uri().'/admin/assets/images/featured-grid/featured_grid_7.jpg',
 			"featured_grid_8"	=> get_template_directory_uri().'/admin/assets/images/featured-grid/featured_grid_8.jpg',
 			"featured_grid_9"	=> get_template_directory_uri().'/admin/assets/images/featured-grid/featured_grid_9.jpg',
 			"featured_grid_10"	=> get_template_directory_uri().'/admin/assets/images/featured-grid/featured_grid_10.jpg',
 			"featured_grid_11"	=> get_template_directory_uri().'/admin/assets/images/featured-grid/featured_grid_11.jpg',
 			"featured_grid_12"	=> get_template_directory_uri().'/admin/assets/images/featured-grid/featured_grid_12.jpg',
 			"featured_grid_13"	=> get_template_directory_uri().'/admin/assets/images/featured-grid/featured_grid_13.jpg',
 			"featured_grid_14"	=> get_template_directory_uri().'/admin/assets/images/featured-grid/featured_grid_14.jpg',
 			"featured_grid_15"	=> get_template_directory_uri().'/admin/assets/images/featured-grid/featured_grid_15.jpg',
 			"featured_grid_16"	=> get_template_directory_uri().'/admin/assets/images/featured-grid/featured_grid_16.jpg',
 			"featured_grid_17"	=> get_template_directory_uri().'/admin/assets/images/featured-grid/featured_grid_17.jpg',
 			"featured_grid_18"	=> get_template_directory_uri().'/admin/assets/images/featured-grid/featured_grid_18.jpg',
  		  
 		),						
				  
	); 
	$option[]=  array( 
		"name"			=> esc_html__('Column in Tablet and Mobile','reza'),
 		"id"			=> "responsive_column",
 		"group"			=>  esc_html__('Layout','reza'),
 		"type"			=> "select",
 		"options" 		=> reza_array_options('first_responsive_column_2',true), 

	);
 
		
 	include REZA_PATH . '/sao-builder/blog/sao-blog-layout.php'; 
	
	include REZA_PATH . '/sao-builder/general/sao-title-box.php'; 
 	include REZA_PATH . '/sao-builder/blog/sao-blog-post-style.php'; 
 	include REZA_PATH . '/sao-builder/blog/sao-blog-typography.php'; 
  
   	include REZA_PATH . '/sao-builder/general/sao-element.php';
   	 
 
    return $option;

}
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog Preview
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_builder_perview_bazinews_post_featured_grid', 'reza_builder_perview_blog_featured_grid');
function reza_builder_perview_blog_featured_grid( $args ) {
	 
	
  		$key = $args['key'];
 		$option = $args['option'];
		$output='';
		$css='';
		if(!empty($option['title'])){
			$output.='<h4 class="rd-perview-header">'.$option['title'] .'</h4>'; 
		}
 	
			if(  !empty($option['layout'])){
				$output.='<img src="'.REZA_DIR.'/admin/assets/images/featured-grid/'.esc_attr($option['layout']).'.jpg">'; 
			}
			
	 
	$css.= '.sao-element-'.$key.' {text-align: center;width: 100%;}'; 
  	$return['css']= $css;
	$return['output']= $output;
	return $return;
}
}
  /*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog Config
																		
*/////////////////////////////////////// /////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
add_filter('sao_builder_bazinews_post_featured_grid', 'reza_blog_featured_grid_config');
function reza_blog_featured_grid_config( $args,$out=false) {
	wp_reset_query();
	wp_reset_postdata();
	$option = $args['option'];
	$key = $args['key']; 
	if(reza_element_show($option)=='show'){
		
  		$option['post_type']='post';
  		$option['post_title']=true;
		
		$more_posts =!empty($option['more_posts'])? $option['more_posts']:'';
		$data_key=$more_posts =="pagenavi"?' data-key="'.$key.'" ':'';
		
		$layout ='featured_grid';
 		$option['featured_grid_layout'] = !empty($option['layout'] )?$option['layout']:'';
 
 
 
		$option['excerpt'] =!empty($option['excerpt_featured'])?$option['excerpt_featured']:'';
		$option['excerpt_2'] =!empty($option['excerpt_grid'])?$option['excerpt_grid']:'';
	
		$option['ratio'] =!empty($option['ratio_featured'])?$option['ratio_featured']:'';
		$option['ratio_2'] =!empty($option['ratio_grid'])?$option['ratio_grid']:'';
		
		$option['thumb'] =!empty($option['thumb_featured'])?$option['thumb_featured']:'';
		$option['thumb_2'] =!empty($option['thumb_grid'])?$option['thumb_grid']:'';
		
		
		
		
		$between_class =!empty($option['between'])? $option['between']:reza_option('bazinews_blog_between');
 		$ratio_class =!empty($option['ratio'])?$option['ratio']:reza_option('bazinews_blog_ratio');
  		$ratio_second_class =!empty($option['ratio_2'])?$option['ratio_2'].'-second':'';
		
		
		$alignment_class =!empty($option['alignment'])?$option['alignment']:reza_option('bazinews_blog_alignment');
		
		
	
		$style =!empty($option['style'])? $option['style']:'';
		if( $style=='style-1' ){
			$option['box_layout']='boxed-details';
		} 
 
		$box_layout =!empty($option['box_layout'])? $option['box_layout']:reza_option('bazinews_blog_box_layout');
 		$caption_class =!empty($option['vertical'] ) ? 'rd-cap-middle':'rd-cap-gradient-bottom';
		$custom_class = !empty( $option['custom_class']) ? $option['custom_class'] : '';			 
 
	
  			$layout_class = 'rd-'.$box_layout.' '.$caption_class; 
  		
		$classes = array(
			'rd-el-'.$key,
			'rd-ajax-tab',
			reza_between_border($option,$box_layout ),
 			'rd-gap-'.$between_class,
			 'rd-el-second',
			 'rd-el-featured-second',
			
			$ratio_class,
			$ratio_second_class,
			'rd-align-'.reza_rtl_has($alignment_class),
			$layout_class,
			$custom_class,
			reza_image_caption_effect($option),	
			reza_element_show($option,true),
		); 
		
		ob_start(); 
		?>
		
		 <aside <?php  reza_el_id($option);?> class="<?php echo esc_attr(join( ' ', $classes ));?> " <?php echo reza_el_cssanime($option).wp_kses_post($data_key);?> >
			
			
			<?php reza_post_title_tabs($option,'reza_post_'.$layout);?>
			<div class="rd-gap-content">
			<div class="rd-gap-warp">
				<div class="rd-item-list rd-flex rd-aw <?php  echo esc_attr(reza_post_featured_grid_class($option));?>">
				
					<?php reza_post_featured_grid($option);?>
					
				</div>
				
				
				<?php 
				if($more_posts == 'load_more'){
					reza_load_more($option,'reza_post_'.$layout);						
				}elseif($more_posts =="pagenavi"){
					reza_pagenavi($option);  
				}	
				?>
                
			</div> 
			</div> 
			
		</aside>  
		
		
		<?php
		$item = '.rd-el-'.$key.'';
		$item_css = reza_title_box_css($option,$item);
		$item_css.= reza_post_css($option,$item);
 		$item_css.= reza_element_padding($option);
		$css =reza_item_css($item_css,$item);
		$return['output']=  ob_get_clean();
		$return['css']= $css;
		$return['emptybefore']= true;
		$return['emptyafter']= true;
		
		if( !empty($out)){
			$output = $return['output'];
			$output.=!empty($return['css'])?'<style>'.$return['css'].'</style>':'';
			return $output;
		}else{
			return $return;	
		}
	}
}
 