(function($) {

     function first_auto_width(id) {
        var flex = id;
        if (window.matchMedia('(max-width: 1024px) and (min-width: 359px)').matches) {
            if (flex.hasClass('rd_first_full')) {
                var first = id.find('.rd-item:first-child');
                if (first.hasClass('rd-aw')) {} else {
                    first.addClass('rd-aw');
                    first.reza_auto_width_warp();
                }
            }
        }
    }



    function auto_width_flex(width, id, res) {
        var flex = id;

        var width_return = width;

        if (flex.hasClass('rd-flex') || flex.hasClass('rd-group') || flex.hasClass('dragscroll')|| id.hasClass('rd-item-carousel')  ||  flex.hasClass('rd-masonry')) {
            if (flex.hasClass('rd_' + res + '_1_2')) {
                width_return = width * 0.5;

            } else if (flex.hasClass('rd_' + res + '_1_3')) {
                width_return = width * 0.33;

            } else if (flex.hasClass('rd_' + res + '_1_4')) {
                width_return = width * 0.25;

            } else if (flex.hasClass('rd_' + res + '_1_5')) {
                width_return = width * 0.2;

            } else if (flex.hasClass('rd_' + res + '_2_5')) {
                width_return = width * 0.4;

            } else if (flex.hasClass('rd_' + res + '_3_5')) {
                width_return = width * 0.6;

            } else if (flex.hasClass('rd_' + res + '_4_5')) {
                width_return = width * 0.8;

            } else if (flex.hasClass('rd_' + res + '_1_6')) {
                width_return = width * 0.16;

            } else if (flex.hasClass('rd_' + res + '_5_6')) {
                width_return = width * 0.83;
            } else if (flex.hasClass('rd_' + res + '_1_7')) {
                width_return = width / 7;

            } else if (flex.hasClass('rd_' + res + '_1_8')) {
                width_return = width / 8;
            }
        }
        return width_return;
    }





    function auto_width_post(width, id) {
        var width_return = width;

        if (id.hasClass('rd-flex') || id.hasClass('rd-group') || id.hasClass('rd-item') || id.hasClass('dragscroll') || id.hasClass('rd-item-carousel') || id.hasClass('rd-single-summary') ) {

            var width_return = width;
            if (id.hasClass('rd-module-1')) {
                var module_1 = id;
            } else {
                var module_1 = id.find('.rd-item.rd-module-1:not(.rd-aw)');
            }
			 
			
            var module_1_details = module_1.find('.rd-details');
            var module_1_width = module_1_details.width();
			
            if (!isNaN(module_1_width)) {
                width_return = module_1_width;
            }

            if (id.hasClass('rd-module-2')) {
                var module_2 = id;
            } else {
                var module_2 = id.find('.rd-item.rd-module-2:not(.rd-aw)');
            }

            var module_2_details = module_2.find('.rd-details');
            var module_2_width = module_2_details.width();

            if (!isNaN(module_2_width)) {
                width_return = module_2_width;
            }




            if (id.hasClass('rd-glider')) {
                var glider = id;
            } else {
                var glider = id.find('.rd-item.rd-glider:not(.rd-aw)');
            }
			
			
  				var glider_thumb = glider.find('.rd-thumb');
				var glider_thumb_ratio = (glider_thumb.height() / glider_thumb.width()) + 0.3;
 				if (!isNaN(glider_thumb_ratio)) {
					if(glider_thumb_ratio > 1){
	
					width_return = (glider_thumb.width() * glider_thumb_ratio) - 35;
 					
					}else{
			
					width_return = (glider_thumb.width() * glider_thumb_ratio) - 0;
		
					}
				 } 
				
				
	  
			 
		}
		
		if(id.hasClass('rd-single-summary')){
			var summary_height = id.prev().find('.woocommerce-product-gallery__image').height();
  				width_return = (width_return + summary_height) / 2;
  		}
		
        return width_return;

    }
	
	
	
	
	
	
    $.fn.reza_auto_width_warp = function() {

        first_auto_width($(this));

        var widths = $(this).width();
        var body_width = $('body').width();

        if (window.matchMedia('(max-width: 1024px) and (min-width: 768px)').matches) {
            widths = auto_width_flex(widths, $(this), 'tab') - 40;
        } else if (window.matchMedia('(max-width: 767px) and (min-width: 360px)').matches) {
            widths = auto_width_flex(widths, $(this), 'mob') - 40;

        } else if (window.matchMedia('(max-width: 359px) and (min-width: 1px)').matches) {
            widths = widths - 40;
        } else {
            widths = auto_width_flex(widths, $(this), 'col') - 40;
        }

        var new_widths = auto_width_post(widths, $(this));


        widths = new_widths;


        if (900 < widths) {
            $(this).addClass('rd-1200');


        } else if (700 < widths && widths <= 900) {
            $(this).addClass('rd-900');

        } else if (500 < widths && widths <= 700) {
            $(this).addClass('rd-700');

        } else if (400 < widths && widths <= 500) {
            $(this).addClass('rd-500');

        } else if (300 < widths && widths <= 400) {
            $(this).addClass('rd-400');

        } else if (250 < widths && widths <= 300) {
            $(this).addClass('rd-300');

        } else if (200 < widths && widths <= 250) {
            $(this).addClass('rd-250');
			
 		 } else if (150 < widths && widths <= 200) {
            $(this).addClass('rd-200');

        } else if (0 < widths && widths <= 150) {
            $(this).addClass('rd-150');

        } 
	};











    $.fn.reza_remove_auto_width_warp = function() {
        var widths = $(this).width();
        $(this).removeClass('rd-1200').removeClass('rd-900').removeClass('rd-700').removeClass('rd-500').removeClass('rd-400').removeClass('rd-300').removeClass('rd-200').removeClass('rd-250').removeClass('rd-150').removeClass('rd-000');
    }
   function reza_icon_width(width) {
 		if (900 < width ) {
            return (width / 14);
         }else if (600 < width && width <= 900) {
            return (width / 10);

        
        } else if (300 < width && width <= 600) {
            return (width / 8);

        } else if (150 < width && width <= 300) {
            return (width / 7);

        } else   {
 			return (width / 5);
        }
	}

    $.fn.reza_review = function() {
 	$(this).find('.rd-circular').each(function(index, element) {
 		var parent_color =  $(this).parents('.rd-post,.rd-game');
		var maincolor =$(this).css('--rd-primary-bg'); 
			var maincolor_2 =$(this).css('--rd-primary-bg');		
		var empty='rgba(0, 10, 20, 0.1)';
		if( parent_color.hasClass('rd-rand-1')){
				  maincolor =	$('body').css('--rd-rand-bg-1');
				  maincolor_2 =	$('body').css('--rd-rand-bg-1');
		}else if( parent_color.hasClass('rd-rand-2')){
				  maincolor =	$('body').css('--rd-rand-bg-1');
				  maincolor_2 =	$('body').css('--rd-rand-bg-2');
		}else if( parent_color.hasClass('rd-rand-3')){
				  maincolor =	$('body').css('--rd-rand-bg-3');
				  maincolor_2=	$('body').css('--rd-rand-bg-3');
				
		}else if( parent_color.hasClass('rd-rand-4')){
				  maincolor =	$('body').css('--rd-rand-bg-4');
				  maincolor_2= $('body').css('--rd-rand-bg-4');
		} 
	
	var percent =$(this).attr('data-percent');
	
 
	if($(this).parents('.rd-post-blog').hasClass('rd-post-blog')){
		var size_width = ( reza_icon_width($(this).parent().width())) + 10;
  	}else{ 
		var size_width = $(this).width();
	 }
	
	
	var size_thickness = parseInt(size_width) / 10 ;
 		if($(this).hasClass('rd-circular-single')){
			var maincolor =$(this).css('--rd-primary-txt'); 
			var maincolor_2 =$(this).css('--rd-primary-txt');
				var empty='rgba(255, 255, 255, 0.0)';
		}
		
		var width =  parseInt(size_width);
			 if(width < 40){
				 width = width * 1.3;
            	 $(this).parents('.rd-post-blog').addClass('rd-icon-center');
 			 }else{
             	$(this).parents('.rd-post-blog').removeClass('rd-icon-center');
			 }
            $(this).attr('style', '--rd-icn-sz:' + width + 'px;');
		
 		 $(this).circleProgress({
			value: percent,
		 	animation: false,
			size:width ,
			thickness: size_thickness,
			emptyFill:empty,
 			fill: {gradient: [maincolor,maincolor_2]}
		  });  
		  
		  
		  
	  });
	 
	} 
	




    $.fn.reza_auto_width = function() {
        $(this).find('.rd-aw').each(function() {
            $(this).reza_remove_auto_width_warp();
            $(this).reza_auto_width_warp();
         });
		 
        $(this).find('.rd-icon-video').each(function() {
 				var size_width = ( reza_icon_width($(this).parent().width())) + 10;
  		 
			var width =  parseInt(size_width);
			 if(width < 40){
				 width = width * 1.3;
            	 $(this).parents('.rd-post-blog').addClass('rd-icon-center');
 			 }else{
             	$(this).parents('.rd-post-blog').removeClass('rd-icon-center');
			 }
				
             $(this).attr('style', '--rd-icn-sz:' + width + 'px;');
			 
        }); 
		
    };
 

})(jQuery);