<?php

include_once REZA_PATH . '/inc/post-layout/post-type.php';
include_once REZA_PATH . '/inc/post-layout/post-list.php';
include_once REZA_PATH . '/inc/post-layout/post-text.php';
include_once REZA_PATH . '/inc/post-layout/post-grid.php';
include_once REZA_PATH . '/inc/post-layout/post-grid-list.php';
include_once REZA_PATH . '/inc/post-layout/post-grid-text.php';
include_once REZA_PATH . '/inc/post-layout/post-featured.php';
include_once REZA_PATH . '/inc/post-layout/post-featured-grid.php';
include_once REZA_PATH . '/inc/post-layout/post-featured-list.php';
include_once REZA_PATH . '/inc/post-layout/post-featured-text.php';


include_once REZA_PATH . '/inc/post-layout/post-class.php';
include_once REZA_PATH . '/inc/post-layout/post-carousel-class.php';
include_once REZA_PATH . '/inc/post-layout/post-masonry-class.php';

 add_filter( 'wp_calculate_image_srcset_meta', '__return_null' ); 
 function the_post_thumbnail_remove_class($output) {
        $output = preg_replace('/class=".*?"/', '', $output);
        return $output;
}
add_filter('post_thumbnail_html', 'the_post_thumbnail_remove_class');

/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																Element ID
																	 	
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
function reza_el_id($option =false) {
   if(!empty( $option['element_id'])){
		echo ' id="'.esc_attr($option['element_id']).'"  ' ;
   }
} 
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																Element Show
																	 	
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
function reza_element_show($option,$clsas=false) {
	$display='show';
	if(reza_ismobile() && !empty($option['tablet_hide']) && !empty($option['phone_hide'])){
		$display ='hide';
 	}else{
		$display ='show';
	}
 
	if(!empty($clsas)){
		$class_hide='';
		if(!empty($option['hide_desktop'])){
			$class_hide.= 'rd_col_hide ';
		}
		if(!empty($option['hide_tablet'])){
			$class_hide.= 'rd_tab_hide ';
		}
		if(!empty($option['hide_mobile'])){
				$class_hide.= 'rd_mob_hide';
		}
		return $class_hide;
	}else{
		return  $display;
	}
}

/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																Data
																	 	
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
function reza_data($option=false,$id=false,$def = false){
   	$option_id = !empty( $option[esc_html($id)] ) ? $option[esc_html($id)] : $def;
	$ajax_sao_evalue_id = !empty($_POST[$id])  ? $_POST[$id] : $option_id; 
	return $ajax_sao_evalue_id;
	
}    
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																Settings
																	 	
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
function reza_settings($settings,$id=false){
	$settings_id=!empty( $settings[ $id] )? $settings[$id] : '';
	if($settings_id=='no'){
		$settings_id='';
	}
	return $settings_id;
 }    
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																Title Tabs
																	 	
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
function reza_multi_cats_array($array){
	$new_array=array();
	if(!empty($array) && is_array($array)){
	foreach($array as $key => $value){
		$new_array[esc_html($value)]=1;
	}
	}
	return $new_array;
 
}    
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																  El Css Anime
 
*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_el_cssanime($option =false) {
   if(!empty( $option['cssanime'])){
	   	global $sao_aos_script;
		$sao_aos_script++;
		echo ' data-aos="'.esc_attr(reza_rtl_has($option['cssanime'])).'" ' ;
   }
} 
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																Post title Tabs
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_post_title_tabs($option,$id =false){
	global  $post;
  
	$option['action']= $id;
	$option['post_status']='publish';
	unset($option['query_single']);
	unset($option['query_video']);

 	$multi_cats = !empty($option['multi_cats'])?$option['multi_cats']:'';
 	$tabs = !empty($option['tabs'])?$option['tabs']:'';
      
	  
   	$title_box_list_all = !empty($option['title_box_list_all'])?$option['title_box_list_all']:'';
	$link = reza_query($option,'',true);
	
 	$orderby = !empty($option['orderby'])?'data-orderby="'.$option['orderby'].'"':'';
 	$platforms = !empty($option['platforms'])?'data-platform="'.$option['platforms'].'"':'';
 	$platform = !empty($option['platform'])?'data-platform="'.$option['platform'].'"':$platforms;
 	$tag = !empty($option['tag'])?'data-platforms="'.$option['tag'].'"':'';
	
	 
  	$max_page = 'data-max_page="'.reza_query($option)->max_num_pages.'"';	
  	$max_page = 'data-max_post="'.reza_query($option)->found_posts.'"';	
	
	 
	
	$element_key = !empty($option['key'])?$option['key']:'123456'; 

	if(!empty($multi_cats)){
		$key_cats = implode(", ", array_keys($multi_cats));
  		$option['cats']=$key_cats;
	} else{
		$key_cats='';
	}
       	$title_box_tag = !empty($option['title_box_tag'])?$option['title_box_tag']:'h4';
	 
 	$title_box_type = !empty($option['title_box_type'])?$option['title_box_type']:'main-tabs';
	$title_box_style = !empty($option['title_box_style'])?$option['title_box_style']:reza_option('bazinews_title_box_style');
	$class = ' rd-'.$title_box_type.' rd-tbox-'.$title_box_style.' '.reza_rand_color();
  
   	/*---------------------------------------------------------------------------------------------------------------------------
	Title Start-------------------------------------------------------------------------------------------------------------------
	----------------------------------------------------------------------------------------------------------------------------*/
 	if(!empty($option['title']) && $title_box_type!=='hide'){
		?>
		
		
	 <div class="<?php echo esc_attr($class);?>"  >
		<?php echo wp_kses_post("<$title_box_tag class='rd-title-box'>");?>	
			
				<?php
				/*---------------------------------------------------------------------------------------------------------------------------
				Tab Main-------------------------------------------------------------------------------------------------------------------
				----------------------------------------------------------------------------------------------------------------------------*/
				if(	$title_box_type =='main-right' ||
					$title_box_type =='main-center' ||
					$title_box_type =='main-tabs' 
 				){?>
 				 	<div class="rd-tab-main"><span><?php echo wp_kses_post($option['title']);?></span></div>
 		
 
				<?php } ?>
			
            		<?php
 					/*---------------------------------------------------------------------------------------------------------------------------
					Tabs-------------------------------------------------------------------------------------------------------------------
					----------------------------------------------------------------------------------------------------------------------------*/
					if( 
						
						$title_box_type =='tabs-center' ||
 						$title_box_type =='main-tabs' ||
						!empty($title_box_list_all)
					){
						
						$option['title']= !empty($option['title_box_all'])?$option['title_box_all']:reza_t('all');
						 
						if(!empty($tabs)  || $title_box_type =='tabs-center' || !empty($title_box_list_all) || !empty($option['arrows']) ){
						?>
						
						<ul class="rd-tabs">
					 		<?php 
							if(	$title_box_type =='tabs-center' ||
 						$title_box_type =='main-tabs' ){
							if(!empty($option['tabs']) && is_array($option['tabs']) ):
							
							?><li class="rd-tab-active rd-tab-item"  <?php echo wp_kses_post($orderby);?> <?php echo wp_kses_post($platforms);?>  <?php echo wp_kses_post($max_page);?> ><a><?php echo esc_html($option['title']);?></a></li><?php
 							foreach ($option['tabs'] as  $key => $value) : 
							
															$tab_value = $option;

							$tab_cats = !empty($value['cats']) ? ' data-cats="'.$value['cats'].'" ':'';
							$tab_orderby = !empty($value['orderby']) ? ' data-orderby="'.$value['orderby'].'" ':'';
							$tab_platform = !empty($value['platform']) ? ' data-platform="'.$value['platform'].'" ':'';
							$tab_tag = !empty($value['tag']) ? ' data-tag="'.$value['tag'].'" ':'';
							
							$tabs_title =  !empty($value['title'])?$value['title']:'';
							
							
							
								$tab_value['cats']= !empty($value['cats'])?$value['cats']:'';
								$tab_value['orderby']= !empty($value['orderby'])?$value['orderby']:'';
								$tab_value['platform']= !empty($value['platform'])?$value['platform']:'';
								$tab_value['tag']= !empty($value['tag'])?$value['tag']:'';
														
							
							
							
							$tab_max_page = !empty(reza_query($tab_value)->max_num_pages)? ' data-max_page="'.reza_query($tab_value)->max_num_pages.'" ':'';
							$tab_max_post = !empty(reza_query($tab_value)->found_posts)? ' data-max_post="'.reza_query($tab_value)->found_posts.'" ':'';
              				 
 						 
                 			 	?><li class="rd-tab-item" <?php echo wp_kses_post($tab_cats.$tab_orderby.$tab_platform.$tab_tag.$tab_max_page.$tab_max_post);?> ><a><?php echo esc_html($tabs_title);?></a></li><?php
         				
						 
                            endforeach;
                            endif;  
						}
                            ?>
                            
                            <?php if(!empty($title_box_list_all)){?>
                            	<li class="rd-tab-item rd-view-all"><a href="<?php echo esc_url($link);?>"><?php echo reza_t('full_list');?></a></li>
                            <?php }?>
         
	 
						</ul>
		 
                <?php
  			
				}
				}
				/*---------------------------------------------------------------------------------------------------------------------------
				END Tabs-------------------------------------------------------------------------------------------------------------------
				----------------------------------------------------------------------------------------------------------------------------*/
 				 ?>  
			 
		<?php echo wp_kses_post("</$title_box_tag>");?>		
			
            <div class="rd-data-json"><?php echo json_encode(reza_array_filter_recursive($option));?></div>

		</div>
  	<?php
	}
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																Title Box
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_title_box($title =false){
	global  $reza_data;
	
	$title_box_type = 'main-tabs';
	$title_box_style = reza_option('title_box_style');
	$class = ' rd-'.$title_box_type.' rd-tbox-'.$title_box_style.' ';
	if(!empty($title)){?>
		
  		 <div class="<?php echo esc_attr($class);?>">
		 <h4><div class="rd-tab-main"><span><?php echo esc_html($title);?></span></div></h4>
         </div>
     <?php    
	}
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																Reza array Filter Recursive
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 function reza_array_filter_recursive($input){
    foreach ($input as &$value)
    {
        if (is_array($value))
        {
            $value = reza_array_filter_recursive($value);
        }
    }

    return array_filter($input);
}
 
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																Load More
																	 	
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
function reza_load_more($option,$id= false){
 	global  $post;
   	$max_page= reza_query($option)->max_num_pages;
   	$max_post= reza_query($option)->found_posts;
  	if($max_post <= reza_data($option,'number','5')){
		$class=' rd-load-more-hide ';
	}else{
		$class=' ';
	}
   		$option['action']=$id;
 
 		$option['post_status']='publish';?>
 		 <div class="rd-load-more <?php echo esc_attr($class);?>" ><a  data-page="2" data-max_page="<?php echo esc_attr($max_page);?>" data-max_post="<?php echo esc_attr($max_post);?>" ><?php echo esc_html(reza_t('load_more'));?></a><div class="rd-data-json"><?php echo wp_kses_post(json_encode(reza_array_filter_recursive($option)));?></div></div>
 <?php	 
}
 

/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																Query
																	 	
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
function reza_query($option =false,$pagenumber= false,$archive_link=false){
  	$qurey = reza_data($option,'qurey');

 	$more_posts = reza_data($option,'more_posts');
	if(!empty($pagenumber) || $more_posts =="pagenavi" ){
   		$page = is_front_page() ? get_query_var( 'page') :get_query_var( 'paged');
	}else{
   		$page = isset($_REQUEST['pageNumber']) ? $_REQUEST['pageNumber'] : 1;
	}
 	$publish = (isset($_REQUEST['post_status'])) ? $_REQUEST['post_status'] : 'publish';
	$number = reza_data($option,'number','5');
 	$sliders = reza_data($option,'sliders');
	$cats = reza_data($option,'cats');
	$tag = reza_data($option,'tag');
	$post_type = reza_data($option,'post_type');
	$multi_cats = reza_data($option,'multi_cats');
	$platforms = reza_data($option,'platforms');
	$platform = reza_data($option,'platform',$platforms);
	$genre = reza_data($option,'genre');
	$publisher = reza_data($option,'publisher');
	$developer = reza_data($option,'developer');
  	$category = reza_data($option,'category');
	
	
	
   	if(!empty($multi_cats)){
	  unset($multi_cats['']);
	}
 	$args = array();
 	$archive_args = array();
	$args['post_type'] = $post_type;
	$archive_args['post_type'] = $post_type;
  	$args['posts_per_page']=$number;
	$args['ignore_sticky_posts'] = 1;
	$archive_args['ignore_sticky_posts'] = 1;
  	if(!empty($qurey)){
		$args =$qurey;
	}
	/*---------------------------------------------------------------------------------------------------------------------------
	Testimonial-------------------------------------------------------------------------------------------------------------------
	----------------------------------------------------------------------------------------------------------------------------*/	
 	elseif($post_type=='testimonial'){
   		 
		
		$args['post_type']= 'testimonial';
 			
 			if(!empty($cats)){	
 
  			$tax_query_category =array(
					'taxonomy' => 'testimonial_category',
					'terms' => $cats,
					'field' => 'slug',
				);		
				$args['tax_query'][0][] =	$tax_query_category;		 
			} 
  
  		 
 		$args['paged']=$page; 
		
 	 
	}	
	/*---------------------------------------------------------------------------------------------------------------------------
	Staff-------------------------------------------------------------------------------------------------------------------
	----------------------------------------------------------------------------------------------------------------------------*/		
 	elseif($post_type=='staff'){
   		 
		
		$args['post_type']= 'staff';
 			
 			if(!empty($cats)){	
 
 				 
 			$tax_query_category =array(
					'taxonomy' => 'staff_category',
					'terms' => $cats,
					'field' => 'slug',
				);		
				$args['tax_query'][0][] =	$tax_query_category;		 
			} 
  
  		 
 		$args['paged']=$page; 
		
 	 
	}	
	/*---------------------------------------------------------------------------------------------------------------------------
	Portfolio-------------------------------------------------------------------------------------------------------------------
	----------------------------------------------------------------------------------------------------------------------------*/	
	elseif($post_type=='portfolio'){
		$orderby = reza_orderby($option);
		$date_query = reza_date_query($option);
		$meta_key = reza_meta_key($option);	
		
		$args['post_type']= 'portfolio';
 	 		$array =array();
			
			
			if(!empty($cats)){	
   
 				$array = $cats;
				}elseif(!empty($multi_cats) && is_array($multi_cats)){
					foreach($multi_cats as $key => $value){
						if(!empty($key)){
						$array[] = $key;
					}
					}
				}
				if(!empty($array)){
  					$tax_query_category =array(
						'taxonomy' => 'portfolio_category',
						'terms' =>  $array,
						'field' => 'slug',
					);		
					$args['tax_query'][0][] =	$tax_query_category;
 				}
   				$archive_args['portfolio_category'] = implode(",", $array);

  		$args['paged']=$page; 
		
 	 
	}
	/*---------------------------------------------------------------------------------------------------------------------------
	Slide-------------------------------------------------------------------------------------------------------------------
	----------------------------------------------------------------------------------------------------------------------------*/		
	elseif($post_type=='sao_slide'){
		
		$args['post_type'] = 'sao_slide';
 		$args['no_found_rows'] = 1;
		if(!empty($sliders)){
			$args['tax_query'] =  array(
				array(
					'taxonomy' => 'sao_sliders',
					'terms' => $sliders,
					'field' => 'slug',
				)
			);
		}
 	}elseif($post_type=='image'){
		$args['post_type'] = 'sao_image';
 		$args['no_found_rows'] = 1;
 		
		
  		if(!empty($cats)){
			$args['tax_query'] =  array(
				array(
					'taxonomy' => 'sao_images',
					'terms' => $cats,
					'field' => 'slug',
				)
			);
		}
	/*---------------------------------------------------------------------------------------------------------------------------
	Product-------------------------------------------------------------------------------------------------------------------
	----------------------------------------------------------------------------------------------------------------------------*/	 		
 	} elseif($post_type=='game'){
   		 
		
		$args['post_type']= 'game';
			
		$args['tax_query'] =array(
    		'relation' => 'AND',
		 );
			 
		if(!empty($platform)  ){
	 
				$tax_query_platform =array(
					'taxonomy' => 'platform',
					'terms' => $platform,
					'field' => 'slug',
				);
				$args['tax_query'][0][] = $tax_query_platform;		 
		}	
		
		if(!empty($genre)  ){
	 
				$tax_query_genre =array(
					'taxonomy' => 'genre',
					'terms' => $genre,
					'field' => 'slug',
				);
				$args['tax_query'][0][] = $tax_query_genre;		 
		}	
		
		if(!empty($publisher)  ){
	 
				$tax_query_publisher =array(
					'taxonomy' => 'publisher',
					'terms' => $publisher,
					'field' => 'slug',
				);
				$args['tax_query'][0][] = $tax_query_publisher;		 
		}	
				
		if(!empty($developer)  ){
	 
				$tax_query_developer =array(
					'taxonomy' => 'developer',
					'terms' => $developer,
					'field' => 'slug',
				);
				$args['tax_query'][0][] = $tax_query_developer;		 
		}	
 
		 
		if(!empty($category)){
			$tax_query_category =array(
					'taxonomy' => 'game_category',
					'terms' => $category,
					'field' => 'slug',
				);		
			$args['tax_query'][0][] =	$tax_query_category;		 
		};
  
		 
		 
 		 
   		$order = reza_game_order($option);
		$args['order']=$order;
		$args['orderby']=  reza_game_orderby($option);
		$args['meta_key']= reza_game_meta_key($option);
 		$args['meta_query']= reza_game_meta_query($option);
  
			$args['paged']= $page; 

 
	}elseif($post_type=='product'){
		$orderby = reza_data($option,'orderby');
		$args['post_type']= 'product';
		$search=reza_data('','search');
		if(isset($search)){
		$args['s']= $search;
		}
		if(!empty($cats)){	
			$args['product_cat'] = $cats;
				$archive_args['product_cat'] = $cats;
		}elseif(!empty($multi_cats)){	
			$key_cats = implode(",", array_keys($multi_cats));
			$args['product_cat'] = $key_cats;
				$archive_args['product_cat'] = implode(",", array_keys($multi_cats));
			
		} 
		 
 
		if(!empty($orderby)){
			
			if($orderby== 'popularity'){
				
				$args['orderby'] =   'meta_value_num date';
				$args['meta_key'] =   'total_sales';
				if(reza_data($option,'hide_stock')){
					$args['meta_query']  = array(
						array('key' => '_stock_status','value' => 'instock'),
						array('key' => '_backorders','value' => 'no')
					);
				} 
				$archive_args['orderby'] = 'popularity';
				
 			}elseif($orderby== 'rating'){
				
				$args['orderby'] =   'meta_value_num date';
				$args['meta_key'] =   '_wc_average_rating';
				if(reza_data($option,'hide_stock')){
					$args['meta_query']  = array(
						array('key' => '_stock_status','value' => 'instock'),
						array('key' => '_backorders','value' => 'no')
					);
				} 
				$archive_args['orderby'] = 'rating';
				
			}elseif($orderby== 'price'){
				$args['orderby']= 'meta_value_num date';
				$args['meta_key']= '_price';
				$args['order']= 'asc';
				if(reza_data($option,'hide_stock')){
					$args['meta_query']  = array(
						array('key' => '_stock_status','value' => 'instock'),
						array('key' => '_backorders','value' => 'no')
					);
				} 
				
				$archive_args['orderby'] = 'price';
				
			}elseif($orderby== 'price_desc'){
				$args['orderby']= 'meta_value_num date';
				$args['meta_key']= '_price';
 				$archive_args['orderby'] = 'price-desc';
				if(reza_data($option,'hide_stock')){
					$args['meta_query']  = array(
						array('key' => '_stock_status','value' => 'instock'),
						array('key' => '_backorders','value' => 'no')
					);
				} 
				
			}elseif($orderby== 'featured'){
				$args['tax_query'] = array(array(
					'taxonomy' => 'product_visibility',
					'field'    => 'name',
					'terms'    => 'featured',
					),
				);
				
				if(reza_data($option,'hide_stock')){
					$args['meta_query']  = array(
						array('key' => '_stock_status','value' => 'instock'),
						array('key' => '_backorders','value' => 'no')
					);
				} 
				$args['orderby']='date';
		
			}elseif($orderby== 'onsale'){
				if(reza_data($option,'hide_stock')){
					$args['meta_query']  = array(
 						array('key' => '_stock_status','value' => 'instock'),
						array('key' => '_backorders','value' => 'no')
					);
				}else{ 
					$args['meta_query'] = array();
				}
					$args['meta_query'][] = array(
						'relation' => 'OR',
						array( // Simple products type
							'key' => '_sale_price',
							'value' => 0,
							'compare' => '>',
							'type' => 'numeric'
						),
						array( // Variable products type
							'key' => '_min_variation_sale_price',
							'value' => 0,
							'compare' => '>',
							'type' => 'numeric'
						)
					);
					$args['orderby']='date';
					
			}elseif($orderby== 'onsale_variation'){
				if(reza_data($option,'hide_stock')){
 				  $args['meta_query'] = array(
 						array('key' => '_stock_status','value' => 'instock'),
						array('key' => '_backorders','value' => 'no')
 				   );
				}else{
					$args['meta_query']=array();
				}
				if(function_exists('is_woocommerce')){
				 $args['meta_query'] = array_merge($args['meta_query'], WC()->query->get_meta_query());
					$args['post__in'] = array_merge(array(0), wc_get_product_ids_on_sale());
				}
				$args['orderby']='date';
					
			}elseif($orderby== 'stock'){
 					$args['meta_query']  = array(
							array('key' => '_stock_status','value' => 'instock'),
							array('key' => '_backorders','value' => 'no')
					);
					
					$args['orderby']='date';
			}else{
				$args['orderby']=$orderby;
				if(reza_data($option,'hide_stock')){
					$args['meta_query']  = array(
						array('key' => '_stock_status','value' => 'instock'),
						array('key' => '_backorders','value' => 'no')
					);
				}
  				$archive_args['orderby'] = $orderby;
			}
			 
		}
		 
		$args['paged']=$page; 
		 			
		 			
 	}else{
		$orderby = reza_orderby($option);
		$date_query = reza_date_query($option);
		$meta_key = reza_meta_key($option);	
		
		if(!empty($tag)){
			$args['tag']=$tag;
		}
			
		if(!empty($cats)){
			$args['category_name']=$cats;
			$archive_args['category_name'] = 'date';

		 }elseif(!empty($multi_cats)){
			$key_multi = implode(", ", array_keys($multi_cats));
 			$args['category_name']=$key_multi;
			$archive_args['category_name'] = implode(", ", array_keys($multi_cats));
		}
		if(!empty($orderby)){
			$args['orderby']=$orderby;
			$archive_args['orderby'] = $orderby;
		}
		
		if( !empty($date_query)){
			$args['date_query']=$date_query;
			$archive_args['date_query'] = $date_query;
		}
		
		if(!empty($meta_key)){
			$args['meta_key']= $meta_key;
			$args['date_query']= $meta_key;
		}
		
		if(!empty($platform)  ){
	 
				$tax_query_platform =array(
					'taxonomy' => 'platform',
					'terms' => $platform,
					'field' => 'slug',
				);
				$args['tax_query'][0][] = $tax_query_platform;		 
		}			
		
		
			$args['paged']= $page; 

	}
	 
 
	$archive = reza_data($option,'archive');
	
	if(!empty(reza_data($option,'query_single'))){
 		return reza_data($option,'query_single');
	}elseif(!empty(reza_data($option,'query_video'))){
  		
		return  reza_data($option,'query_video');
	}elseif(!empty($archive_link)){
  		unset($args['number']);
 		unset($args['page']);
  		unset($args['paged']);
 		unset($args['posts_per_page']);
 		unset($args['post_status']);
    	return home_url( '/').''.add_query_arg($archive_args,'','');
		
 	}elseif(!empty($archive)){
		global  $wp_query;
		return  $wp_query;
	}else{
 
		
		return new WP_Query($args );
	}
				
} 
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																Date Query
																	 	
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
function reza_date_query($option=false,$custom = false){
	if(!empty($custom)){
		$orderby =   isset( $custom['orderby'] ) ? $custom['orderby'] : null;
	} else{
		$orderby = reza_data($option,'orderby');
	}
		
	if($orderby =='rand-day' || $orderby =='last-comment-day'||$orderby =='most-comment-day'||$orderby =='views-day'||$orderby =='best-reviews-day'){
			$date_query = array(array('after' => '1 day ago' )) ;
			
	} elseif($orderby =='rand-week'|| $orderby =='last-comment-week'|| $orderby =='most-comment-week'|| $orderby =='views-week'|| $orderby =='best-reviews-day'){
			$date_query = array(array('after' => '1 week ago' )) ;
			
	} elseif( $orderby =='rand-month'|| $orderby =='last-comment-month'|| $orderby =='most-comment-month'|| $orderby =='views-day'|| $orderby =='best-reviews-month'){
			$date_query = array(array('after' => '1 month ago' )) ;
 		
	} elseif( $orderby =='rand-year'|| $orderby =='last-comment-year'|| $orderby =='most-comment-year'|| $orderby =='views-year'|| $orderby =='best-reviews-year'){
			$date_query = array(array('after' => '1 year ago' )) ;
	}else{
 			$date_query='';
	}
	return $date_query;
	
} 

/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															 Query
																	 	
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
function reza_orderby($option=false,$custom = false){
	if(!empty($custom)){
		$orderby =   isset( $custom['orderby'] ) ? $custom['orderby'] : null;
	} else{
		$orderby = reza_data($option,'orderby');
	}
 	
	if( $orderby == 'rand'|| $orderby =='rand-day'|| $orderby =='rand-week'|| $orderby =='rand-month'|| $orderby =='rand-year'){
		$order='rand';
		
	}elseif( $orderby == 'most-comment'|| $orderby =='most-comment-day'|| $orderby =='most-comment-week'|| $orderby =='most-comment-month'|| $orderby =='most-comment-year'){
		$order='comment_count date';
			
	}elseif( $orderby == 'views'|| $orderby =='views-day'|| $orderby =='views-week'|| $orderby =='views-month'|| $orderby =='views-year'
		|| $orderby == 'best-reviews'|| $orderby =='best-reviews-day'|| $orderby =='best-reviews-week'|| $orderby =='best-reviews-month'|| $orderby =='best-reviews-year'){
		$order='meta_value_num date';					
			
	} else {
 		$order=$orderby;
	}
	
	return $order;
	
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															 Meta Key
																	 	
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
function reza_meta_key($option=false,$custom = false){
	if(!empty($custom)){
		$orderby =   isset( $custom['orderby'] ) ? $custom['orderby'] : null;
	} else{
		$orderby = reza_data($option,'orderby');
	}
	
  	if( $orderby == 'views'|| $orderby =='views-day'|| $orderby =='views-week'|| $orderby =='views-month'|| $orderby =='views-year'){
		if(function_exists('the_views')) {
     $meta_key = 'views';
	}else{
  	  $meta_key	 = 'bazinews_views_count';
	}
			
	} elseif($orderby == 'best-reviews'|| $orderby =='best-reviews-day'|| $orderby =='best-reviews-week'|| $orderby =='best-reviews-month'|| $orderby =='best-reviews-year'){
		$meta_key='bazinews_review_score';	
							
	} else{
		$meta_key='';
			
 	}
	return $meta_key;
	
}  
 
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															 Post View
																	 	
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////  
function reza_getPostViews($postID,$only_count =false){
 	if(function_exists('the_views')) {

     $count_key = 'views';

	}else{

  	  $count_key = 'bazinews_views_count';

	}
    $count = get_post_meta($postID, $count_key, true);
	
    if($count=='' || $count=='0'){
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
		if(!empty($only_count)){
        	return __("0",'reza');
		}else{
        	return __('0','reza').' '.reza_t('view');
		}
	}
	if(!empty($only_count)){
     	return reza_number_replace(round($count));
	}else{
     	return reza_number_replace(round($count)).' '. reza_t('views') ;
 	}
}
 
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															 light slider
																	 	
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
 function reza_lightslider($item,$slider_options=false) {
	if(empty(reza_ismobile())){

		$number = isset( $sao_evalue['number'] ) ? $sao_evalue['number'] : '5'; 
 		wp_enqueue_script('sao_lightslider_script',REZA_DIR. '/js/lib/lightslider.min.js','',1); 
 	
		$slider_options["item"] = (int)$item;
		$slider_options["slideMove"] = 1;
		$slider_options["loop"] = false;
		$slider_options["rtl"] = true;
		$slider_options["slideMargin"] = 0;
 		?>
		<div class="rd-slider-options" ><?php echo wp_kses_post(json_encode($slider_options));?></div>
		<?php
		 

	}
} 


/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															 Get Time
																	 	
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
function reza_get_time(){
  	if(  reza_option('time_format') == 'morden'  ){	
			echo reza_number_replace(reza_time_elapsed_string());
   	}else{
		echo  esc_html(reza_number_replace(get_the_time(get_option('date_format'))));
 	}
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															   Time Elased String
																	 	
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
 function reza_time_elapsed_string( )
{
		$to = current_time('timestamp'); //time();
		$from = get_the_time('U') ;
		
		$diff = (int) abs($to - $from);
		$etime=$diff ;
   	 if ($etime < 1)
    {
        return __('0 Second','reza');
    }

    $a = array( 365 * 24 * 60 * 60  => 'year' ,
                 30 * 24 * 60 * 60  => 'month' ,
                      24 * 60 * 60  => 'day' ,
                           60 * 60  => 'hour' ,
                                60  => 'minute' ,
                                 1  => 'second' ,
                );
    $a_dates = array( 'year'   => esc_html(reza_t('years')),
                       'month'  => esc_html(reza_t('months')),
                       'day'    => esc_html(reza_t('days')),
                       'hour'   => esc_html(reza_t('hours')),
                       'minute' => esc_html(reza_t('minutes' )),
                       'second' => esc_html(reza_t('seconds')),
                );
    $a_date = array( 'year'   => esc_html(reza_t('year')),
                       'month'  => esc_html(reza_t('month')),
                       'day'    => esc_html(reza_t('day')),
                       'hour'   => esc_html(reza_t('hour')),
                       'minute' => esc_html(reza_t('minute' )),
                       'second' => esc_html(reza_t('second')),
                );

    foreach ($a as $secs => $str)
    {
        $d = $etime / $secs;
        if ($d >= 1)
        {
            $r = round($d);
            return $r . ' ' . ($r > 1 ? $a_dates[$str] : $a_date[$str]) . " ". esc_html(reza_t('ago'));
        }
    }
}

/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															   Post Hover Link
																	 	
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
function reza_post_hover_link($link=false){
	global $post;
 	$img_link =get_the_post_thumbnail_url($post->ID,'full');
 	$the_permalink = reza_meta('staff_external',reza_meta('portfolio_external', get_permalink()));
  	?>
    <div class="rd-hover-icon">
		<a class="rd-hover-img" href="<?php echo esc_url($img_link);?>"></a><a class="rd-hover-post"  href="<?php echo esc_url($the_permalink);?>"></a>
	</div>
	<?php
}

/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Caption Effect
																	 	
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
 function reza_image_caption_effect($option =false){ 
  	$image_effect= !empty($option['image_effect']) ? $option['image_effect'] :reza_option('bazinews_image_effect');;
 	$image_effect_class = !empty($image_effect)? 'rd-hover-'.$image_effect:'';	 
	$caption_effect =!empty($option['caption_effect'])? $option['caption_effect']: reza_option('bazinews_caption_effect');
 	$caption_effect_class = $caption_effect!== 'imghvr-fade'?'rd-'.$caption_effect:'';
 	
	return $image_effect_class.' '.$caption_effect_class;
 }
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																		Thumbnail Image
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_remove_rel_attr($content) {
    return preg_replace('/\s+rel="attachment wp-att-[0-9]+"/i', '', $content);
}
add_filter('the_content', 'reza_remove_rel_attr');
function reza_filter_image_sizes( $sizes) {
    unset( $sizes['yith-woocompare-image']);
    return $sizes;
}

add_filter('intermediate_image_sizes_advanced', 'reza_filter_image_sizes');	
function reza_filter_post_thumbnail_html( $html ) {
 
    if ( '' == $html ) {
        return '<img src="' . REZA_DIR . '/images/default-thumbnail.jpg" width="640px" height="384px" class="image-size-name" />';
    } 
    return $html;
}
add_filter( 'post_thumbnail_html', 'reza_filter_post_thumbnail_html' );
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Get Search Form
																	 	
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
function reza_get_search_form( $form ) {
  	$searchform_post_type=    reza_option('bazinews_searchform_type') ;
	$classes = array(
 		'rd-search-fexid-icon',
		'rd-searchfield',
		'rd-aw',
		'rd-align-center',
 		
   	);
 	ob_start();
	
	?>
	<aside  class="<?php echo esc_attr(join( ' ', $classes ));?> " >
        <form method="get" class="rd-search" action="<?php echo esc_url(home_url( '/') );?>">
            <input type="text" name="s"  value="" placeholder="<?php echo esc_attr(reza_t('searchitem'));?>" />
            <button type="submit" name="btnSubmit" ></button>
          
            <?php if(!empty($searchform_post_type)){?>
                <input type="hidden" name="post_type" value="<?php echo esc_attr($searchform_post_type);?>">
            <?php }?>
                         
		</form>
     </aside>
	<?php
	return ob_get_clean();

}
add_filter( 'get_search_form', 'reza_get_search_form' );
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Caption Effect
																	 	
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
 function reza_between_border($option =false,$box_layout=false){ 
 		$between_border =!empty($option['between_border'])?$option['between_border']:reza_option('bazinews_between_border');
		$border_class =$between_border !=='none' ? 'rd-bw-'.$between_border:'';
		if($box_layout=='none' || $box_layout=='boxed-all'|| $box_layout=='boxed-content'){
			return $border_class;
		}else{
			return '';
		}
	 
 }