<?php
/**
 * Nav Menu API: Walker_Nav_Menu class
 *
 * @package WordPress
 * @subpackage Nav_Menus
 * @since 4.6.0
 */
/**
 * Core class used to implement an HTML list of nav menu items.
 *
 * @since 3.0.0
 *
 * @see Walker
 */
 
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																	Walker Nav Menu
 
*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
class reza_Walker_Nav_Menu extends Walker {
 
        public $tree_type = array( 'post_type', 'taxonomy', 'custom' );
		public $db_fields = array( 'parent' => 'menu_item_parent', 'id' => 'db_id' );
        
        public function start_lvl( &$output, $depth = 0, $args = array() ) {
                $indent = str_repeat("\t", $depth);
				
                 $output .= '<ul class="rd-drop">';
				  
	    } 
        public function end_lvl( &$output, $depth = 0, $args = array() ) {
                $indent = str_repeat("\t", $depth);
                $output .= "$indent</ul>\n";
        } 
		
        public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
                $atts = array();
                 $atts['title']  = ! empty( $item->attr_title ) ? $item->attr_title : '';
                $atts['target'] = ! empty( $item->target )     ? $item->target     : '';
                $atts['rel']    = ! empty( $item->xfn )        ? $item->xfn        : '';
                $atts['href']   = ! empty( $item->url )        ? $item->url        : '';
	$slug=reza_slug();

				if($item->type == 'blog_grid'){
					include  REZA_PATH . '/inc/menu/config/blog_grid-start.php';   
				}elseif($item->type == 'widget'){
					include  REZA_PATH . '/inc/menu/config/widget-start.php';   
				}elseif($item->type == 'image_text'){
					include  REZA_PATH .'/inc/menu/config/image_text-start.php'; 	
						  
 				}elseif($item->type == 'image'){
					include  REZA_PATH . '/inc/menu/config/image-start.php';   
 				}elseif($item->type == 'page_builder'){
					include  REZA_PATH . '/inc/menu/config/page_builder-start.php';   
 				}elseif($item->type == 'section'){
					include  REZA_PATH . '/inc/menu/config/section-start.php';   
 				}else{ 
 					include  REZA_PATH . '/inc/menu/config/menu_item-start.php';   
				 
				 }
 				 
         }
       
        public function end_el( &$output, $item, $depth = 0, $args = array() ) {
    		  if($item->type == 'blog_grid'){
			  }elseif($item->type == 'widget'){
  			 }else if($item->type == 'image_text'){
  			 }elseif($item->type == 'image'){
  			 } elseif($item->type == 'page_builder'){
   			 }else if($item->type == 'section'){
				include  REZA_PATH .'/inc/menu/config/section-end.php';   
			}else{
   				$output .= "</li>";
			}
 			 
		}
} 
  
 /*****************************************************************************************************************************************************

 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																	Icon FontFamily
 
*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 function reza_menu_data($item =false,$id=false,$default=false) {
	return isset( $item->$id ) ? $item->$id : $default;

 }
 function reza_icon_fontfamily($value =false) {
 	 	if(!empty($value)){
			
			global $sao_fonticon_style;
			if(strpos($value,'fa-')!==false){
				$sao_fonticon_style['FontAwesome']=true;
			}
			if(strpos($value,'flaticonarrow-')!==false){
				$sao_fonticon_style['flaticonarrow']=true;
			}
			if(strpos($value,'flaticonmultimedia-')!==false){
				$sao_fonticon_style['flaticonmultimedia']=true;
			} 
			
			if(strpos($value,'flaticonbusiness-')!==false){
				$sao_fonticon_style['flaticonbusiness']=true;
			} 
				
			if(strpos($value,'flaticonoffice-')!==false){
				$sao_fonticon_style['flaticonoffice']=true;
			} 
			if(strpos($value,'flaticoninterface-')!==false){
				$sao_fonticon_style['flaticoninterface']=true;
			} 
			
			if(strpos($value,'flaticonessentialset-')!==false){
				$sao_fonticon_style['flaticonessentialset']=true;
			} 
			if(strpos($value,'flaticontechsupport-')!==false){
				$sao_fonticon_style['flaticontechsupport']=true;
			} 
			if(strpos($value,'flaticontech-')!==false){
				$sao_fonticon_style['flaticontech']=true;
			} 
			if(strpos($value,'flaticonstrategy-')!==false){
				$sao_fonticon_style['flaticonstrategy']=true;
			} 
			if(strpos($value,'flaticonhipster-')!==false){
				$sao_fonticon_style['flaticonhipster']=true;
			} 
			if(strpos($value,'flaticonfashion-')!==false){
				$sao_fonticon_style['flaticonfashion']=true;
			} 
			if(strpos($value,'flaticonwebdesign-')!==false){
				$sao_fonticon_style['flaticonwebdesign']=true;
			} 
			if(strpos($value,'flaticontravel-')!==false){
				$sao_fonticon_style['flaticontravel']=true;
			} 
			if(strpos($value,'flaticonnetwork-')!==false){
				$sao_fonticon_style['flaticonnetwork']=true;
			} 
			 
			if(strpos($value,'metrizeicon-')!==false){
				$sao_fonticon_style['metrizeicon']=true;
			}
			if(strpos($value,'typcn-')!==false){
				$sao_fonticon_style['typcn']=true;
			} 
		}
	 
 }
 
 function reza_icon_enqueue($var=false,$true=false) {
	global $sao_fonticon_style;
  	if(!empty($sao_fonticon_style['FontAwesome']) || !empty($true)) wp_enqueue_style('sao_fontawesome',REZA_DIR. '/css/fonts/fontawesome.css','',$var);  
 	if(!empty($sao_fonticon_style['flaticonarrow'])  || !empty($true)) wp_enqueue_style('sao_flaticonarrow',REZA_DIR . '/css/fonts/flaticonarrow.css','',$var);  
 	if(!empty($sao_fonticon_style['flaticonmultimedia'])  || !empty($true) ) wp_enqueue_style('sao_flaticonmultimedia',REZA_DIR. '/css/fonts/flaticonmultimedia.css','',$var);  
 	if(!empty($sao_fonticon_style['flaticonbusiness'])  || !empty($true)) wp_enqueue_style('sao_flaticonbusiness',REZA_DIR. '/css/fonts/flaticonbusiness.css','',$var);  
 	if(!empty($sao_fonticon_style['flaticonoffice'])  || !empty($true)) wp_enqueue_style('sao_flaticonoffice',REZA_DIR. '/css/fonts/flaticonoffice.css','',$var);  
 	if(!empty($sao_fonticon_style['flaticoninterface'])  || !empty($true) ) wp_enqueue_style('sao_flaticoninterface',REZA_DIR. '/css/fonts/flaticoninterface.css','',$var);  
 	if(!empty($sao_fonticon_style['flaticonessentialset']) || !empty($true)) wp_enqueue_style('sao_flaticonessentialset',REZA_DIR. '/css/fonts/flaticonessentialset.css','',$var);  
 	if(!empty($sao_fonticon_style['flaticontechsupport']) || !empty($true)) wp_enqueue_style('sao_flaticontechsupport',REZA_DIR. '/css/fonts/flaticontechsupport.css','',$var);  
 	if(!empty($sao_fonticon_style['flaticontech'])  || !empty($true)) wp_enqueue_style('sao_flaticontech',REZA_DIR. '/css/fonts/flaticontech.css','',$var);  
 	if(!empty($sao_fonticon_style['flaticonstrategy'])  || !empty($true)) wp_enqueue_style('sao_flaticonstrategy',REZA_DIR. '/css/fonts/flaticonstrategy.css','',$var);  
 	if(!empty($sao_fonticon_style['flaticonhipster'])  || !empty($true) ) wp_enqueue_style('sao_flaticonhipster',REZA_DIR. '/css/fonts/flaticonhipster.css','',$var);
  	if(!empty($sao_fonticon_style['flaticonfashion']) || !empty($true) ) wp_enqueue_style('sao_flaticonfashion',REZA_DIR. '/css/fonts/flaticonfashion.css','',$var);  
 	if(!empty($sao_fonticon_style['flaticonwebdesign']) || !empty($true) ) wp_enqueue_style('sao_flaticonwebdesign',REZA_DIR. '/css/fonts/flaticonwebdesign.css','',$var);  
 	if(!empty($sao_fonticon_style['flaticontravel']) || !empty($true) ) wp_enqueue_style('sao_flaticontravel',REZA_DIR. '/css/fonts/flaticontravel.css','',$var);  
 	if(!empty($sao_fonticon_style['flaticonnetwork']) || !empty($true)) wp_enqueue_style('sao_flaticonnetwork',REZA_DIR. '/css/fonts/flaticonnetwork.css','',$var);  
 	if(!empty($sao_fonticon_style['metrizeicon']) || !empty($true)) wp_enqueue_style('sao_metrizeicon',REZA_DIR. '/css/fonts/metrizeicon.css','',$var);  
 	if(!empty($sao_fonticon_style['typcn']) || !empty($true)) wp_enqueue_style('sao_typcn',REZA_DIR. '/css/fonts/typcn.css','',$var);   
}
add_action('wp_footer', 'reza_icon_enqueue'); 

