<?php
include_once REZA_PATH . '/inc/game/game-image.php';  
include_once REZA_PATH . '/inc/game/game-module-1.php';  
include_once REZA_PATH . '/inc/game/game-module-3.php';  

 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																	Game Post Title
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 function reza_game_post_title($option= false,$font=false) {
	 	$limit = reza_data($option,'title_limit');    

	$the_title = strip_tags(get_the_title());
  	if ( !empty($limit) && strlen($the_title) > $limit){
 		 $content= mb_substr($the_title, 0,$limit).'...';
		 
	} else {
		$content= $the_title;
		$dots='';
	}
  	?>
    
 	<h3 class="rd-title"><a href="<?php the_permalink(); ?>"><?php echo esc_html($content);?></a></h3>
 	 	
	<?php 
}
 
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																	Game Release
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_game_release() {
	$current = new DateTime();
 	$current->setTimestamp(current_time('timestamp'));
 	  $current->format('m');
   $current->format('d');
 	global $post;
 	$year = get_post_meta($post->ID, 'sao_game_release_year', true);  
	$month = get_post_meta($post->ID, 'sao_game_release_month', true);  
	$day = get_post_meta($post->ID, 'sao_game_release_day', true);  
	
	/*  
	*/
 	$date='';
 	$date='';
 	$release = 0;
	if(!empty($year) && !empty($month) && !empty($day) ){
 		if($year >= $current->format('Y') &&  $month >= $current->format('m') && $day > $current->format('d') ){
 			$release=2;
  		}elseif($year >= $current->format('Y') &&  $month >= $current->format('m') && $day <= $current->format('d') ){
 			$release=1;
  		}else{
 			$release=1;
		}
		if( function_exists ( "jdate" ) && reza_option('bazinews_date_type') == 'shamsi'){  
			$date = jdate('d F Y',$year.'-'.$month.'-'.$day);
		}else{
			$date = $day.' '.reza_game_month($month).' '.$year;
		}
	}
 	
	if(!empty($year) && !empty($month) && empty($day) ){
		if($year >= $current->format('Y') &&  $month >= $current->format('m') ){
 			$release=2;
		}else{
 			$release=1;
		}
		
				  
 		if( function_exists ( "jdate" ) && reza_option('bazinews_date_type') == 'shamsi'){  
			$date =  jdate('F Y',$year.'-'.$month.'-0');
		} else{
 			$date = reza_game_month($month).' '.$year;
		}
 		 
		
	}
	
	
	
	
	if((!empty($year) && empty($month) && empty($day)) || (!empty($year) && empty($month) && !empty($day)) ){
		if($year >= $current->format('Y') ){
 			$release=2;
		}else{
 			$release=1;
 		}
		if( function_exists ( "jdate" ) && reza_option('bazinews_date_type') == 'shamsi'){  
			$date =  jdate('Y',$year.'-00-00');
		} else{
			$date = $year;
		}
	}
	
	
	if(empty($year) && empty($month) && empty($day) ){
		$release=0;
	}
	
	if($release == 2){
 		 
 		$rls = reza_t('coming').' '.$date;
 	}elseif($release == 1){
		$frls =  !empty($first)? reza_t('firstrelease').' ':'';
 		$rls = $frls.$date;
 	}else{
 		$rls = reza_t('unknownreleasedate');
	}
	
	?>
    <div class="rd-game-meta">
		 <span><?php echo reza_t('relesaedate');?></span>
		 <span><?php echo esc_html(reza_number_replace($rls));?></span>
	</div>

    <?php	
   
}
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																  Game Month
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_game_month( $month ) { 
$data_array=array(
		'01'=> esc_html__('Jan','reza'),
		'02'=> esc_html__('Feb','reza'),
		'03'=> esc_html__('Mar','reza'),
		'04'=> esc_html__('Apr','reza'),
		'05'=> esc_html__('May','reza'),
		'06'=> esc_html__('Jun','reza'),
		'07'=> esc_html__('Jul','reza'),
		'08'=> esc_html__('Aug','reza'),
		'09'=> esc_html__('Sep','reza'),
		'10'=> esc_html__('Oct','reza'),
		'11'=> esc_html__('Nov','reza'),
		'12'=> esc_html__('Dec','reza'),
);
return $data_array[$month];
}
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																Game Platform
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_game_platform() {
	$terms = wp_get_post_terms( get_the_ID(),"platform");
  	$count=0;
	if(!empty($terms)){
	 ?>
	<div class="rd-game-meta">
		
        <span><?php echo reza_t('platform');?></span>
		
		 <span>
			 <?php foreach ( $terms as $term ) {
            $count++;
            if($count!=1){echo',';}; ?>
            <a href="<?php echo esc_url(get_term_link($term->term_id)); ?>"><?php echo esc_html($term->name);?></a>
            <?php } ?>
        </span>
	
    </div>
	 
	<?php 
	}
}
 

 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																Game Develpoer
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_game_developer() {
	$terms = wp_get_post_terms(get_the_ID(),"developer");
  	$count=0;
 	if(!empty($terms)){
	?>
	<div class="rd-game-meta">
    
        <span><?php echo reza_t('developed');?></span>
    
		<span>
        
			<?php foreach ( $terms as $term ) { $count++;?>
            <?php if($count!=1){echo',';};?>
         
				<a href="<?php echo esc_url(get_term_link($term->term_id)); ?>"><?php echo esc_html( $term->name);?></a>
		
			<?php } ?>
            
        </span>
            
	</div>
 
<?php }
}
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																Game Pubilsher
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_game_publisher() {
	$terms = wp_get_post_terms(get_the_ID(),"publisher");
  	$count=0;

	if(!empty($terms)){
		
	?>
	
    <div class="rd-game-meta">
    
        <span><?php echo reza_t('published');?></span>
		
        <span>
        
			<?php foreach ( $terms as $term ) { $count++;?>
            <?php if($count!=1){echo',';};?>
               
                <a href="<?php echo esc_url(get_term_link($term->term_id)); ?>"><?php echo esc_html( $term->name);?></a>
           
            <?php } ?>
            
		</span>

        
	</div>
 
<?php }
}
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																	Game Genre
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_game_genre() {
$terms = wp_get_post_terms(get_the_ID(),"genre");
  	$count=0;

	if(!empty($terms)){

 ?>
	<div class="rd-game-meta">
    
	<span><?php echo reza_t('genre');?></span>

        <span>

	<?php foreach ( $terms as $term ) {$count++;?>
	<?php if($count!=1){echo',';};?>
 
		<a href="<?php echo esc_url(get_term_link($term->term_id)); ?>"><?php echo esc_html( $term->name);?></a>
			<?php } ?>
	</span>
	</div>
 
<?php }
}
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																  Game Object Review
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_gameobject_review($subscore =true){
	global $post ;
	$reza_metas = get_post_meta( $post->ID );
	 
	echo '<div class="rd-gameobject-review">';
		//Review
  			 	if(!empty(reza_meta('sao_game_review_score'))){
						$score = reza_meta('sao_game_review_score');
					if( $score < 101 && $score > 0 ){
						$review_score = $score;
						$total_review_score =round( $review_score);
						$point =  $total_review_score/10;
						$mainpoint =  $total_review_score/100;
					}else{
						$point =  esc_html('--');
						$mainpoint =  00;
					}
 
	
				echo '<div class="rd-circular" data-percent="'.esc_attr(reza_str_number(reza_number_replace_en($mainpoint))).'">';
					echo '<span>'.esc_html(reza_str_number(reza_number_replace($point))).'</span>';
				echo '</div>';
				
  			} else{
 		
				echo '<div class="rd-circular" data-percent="00">';
					echo '<span>'.esc_html('--').'</span>';
				echo '</div>';
 			}
       
   		//Short	
		if(!empty($subscore)){
		echo '<div class="rd-review-short ">';
			if(!empty($reza_metas['sao_game_review_short'][0])){
				echo esc_html($reza_metas['sao_game_review_short'][0]);
			} else{
				echo reza_t('notreviewed');
			} 
		echo '</div>';
		}
	echo '</div>';
}
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																	Game Object Metarictic
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_gameobject_metacritic($subscore =true){
	
 
	
	global $post ;
	$reza_metas = get_post_meta( $post->ID );
	 
	echo '<div class="rd-gameobject-metacritic">';
		//Review
   				 
				$point = !empty($reza_metas['sao_game_metacritic'][0]) ?  $reza_metas['sao_game_metacritic'][0] : esc_html('--');
 				 
 			 
				echo '<div class="rd-circular " data-percent="00">';
					echo '<span>'.esc_html(reza_str_number(reza_number_replace($point))).'</span>';
				echo '</div>';
  			 
       
   		//Short	
		if(!empty($subscore)){
		echo '<div class="rd-review-short">';
 				echo reza_t('metacritic');
 		echo '</div>';
 		}
	echo '</div>';
	
}
 	 
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																  Game tracking
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_game_tracking(){
	global $post;
	$filder_list=array();
	$news =  reza_option('bazinews_game_news'  ) ;
	$news_title =  reza_option('bazinews_game_news_title'  ) ;
	$news_category =  reza_option('bazinews_game_news_category');
 	if($news == 'show'){
		$filder_list[sanitize_title($news_category)]=$news_title;
 	}

	$articles =  reza_option('bazinews_game_articles'  ) ;
	$articles_title =  reza_option('bazinews_game_articles_title' ) ;
	$articles_category =  reza_option('bazinews_game_articles_category');
 	if($articles == 'show'){
		$filder_list[sanitize_title($articles_category)]=$articles_title;
 	}
	
	$reviews =  reza_option('bazinews_game_reviews'  ) ;
	$reviews_title =  reza_option('bazinews_game_reviews_title') ;
	$reviews_category =  reza_option('bazinews_game_reviews_category');
 	if($reviews == 'show'){
		$filder_list[sanitize_title($reviews_category)]=$reviews_title;
 	}
	
	$videos =  reza_option('bazinews_game_videos'  ) ;
	$videos_title =  reza_option('bazinews_game_videos_title'  ) ;
	$videos_category =  reza_option('bazinews_game_videos_category');
 	if($videos == 'show'){
		$filder_list[sanitize_title($videos_category)]=$videos_title;
 	}

	//$gallery = get_post_meta($post->ID, 'sao_gallery_id', true);
 		 
 	$images =  reza_option('bazinews_game_images' ) ;
	$images_title =  reza_option('bazinews_game_images_title' ) ;
	//$images_category =  reza_option('reza_game_images_category','images');
 	if(   $images == 'show'){
		$filder_list['images']=$images_title;
 	}	
	return $filder_list;
 }
  /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																Game Icon
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_game_icon($icon){
	$filder_list='';
  	$news_category =  reza_option('bazinews_game_news_category');
 	if($icon == $news_category){
		$filder_list= 'fa fa-newspaper-o';
 	}

  	$articles_category =  reza_option('bazinews_game_articles_category');
 	if($icon == $articles_category){
		$filder_list='fa fa-file-text-o';
 	}
	
  	$reviews_category =  reza_option('bazinews_game_reviews_category');
 	if($icon == $reviews_category){
		$filder_list= 'fa fa-star-o';
 	}
	
 	$videos_category =  reza_option('bazinews_game_videos_category');
 	if($icon == $videos_category){
		$filder_list= 'fa fa-play-circle-o';
 	}

 	$images_category =  reza_option('bazinews_game_images_category');
 	if($icon == $images_category){
		$filder_list= 'fa fa-image';
 	}	
	return $filder_list;
 } 
 
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																  Game Profile
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 function reza_game_profile($game_id = false){
	$id = !empty($game_id)?$game_id:'';
	$args = array(
	  'name'        => $id,
	  'post_type'   => 'game',
	  'post_status' => 'publish',
	  'posts_per_page' => 1
	);
 
	 $query = new wp_query( $args );
  

	if( $query->have_posts() ) : 
	while ( $query->have_posts() ) : $query->the_post();
	global $post;
		$meta = get_post_meta( $post->ID );

		echo '<div class="rd-el-gameprofile rd-aw '.reza_option('bazinews_game_image_ratio').'">';
 			echo '<div class="rd-gameprofile-header">';
					reza_game_post_title();
		 			reza_game_thumb('full',reza_option('bazinews_game_image_ratio'));

			echo '</div>';
			
			echo '<div class="rd-gameprofile-score">';
			
                         reza_gameobject_review();
                             reza_gameobject_metacritic();
  			
			
			echo '</div>';			
 
			reza_game_excerpt();
 			$meta_platforms = wp_get_post_terms(get_the_ID(),"platform");
			$meta_developer = wp_get_post_terms(get_the_ID(),"developer");
			$meta_publisher = wp_get_post_terms(get_the_ID(),"publisher");
			$meta_genre = wp_get_post_terms(get_the_ID(),"genre");
	
	 
 
				echo '<div class="rd-game-details">';
			
 					 
				 reza_game_release();
				 reza_game_platform();
				reza_game_developer();
				reza_game_publisher();
				reza_game_genre();
			  
				echo '</div>';	
 	 
				if(!empty(reza_meta('sao_game_shop'))){
 				echo '<a class="rd-game-shop" href="'.esc_url(reza_meta('sao_game_shop')).'">'.reza_t('buyproduct').'</a>';
 				} 
			 
 		echo '</div>';
	endwhile;
	endif;
	
	wp_reset_postdata();       	 

	
}
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																  Game Thumb
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_game_thumb( $thumb='thumb',$ratio='rd-ratio-auto') { 
	if(has_post_thumbnail()){
		
 		global $post;
		
	 
  		$style='';
  		
		$thumbnail= wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), $thumb );
		$the_permalink = get_permalink();
 		if(!empty($thumbnail[0])){
 		?>
            <div class="rd-thumb" > 
                  <a <?php if(!empty($the_permalink)){?>href="<?php echo esc_url($the_permalink) ?>"  <?php } ?> >
                     <?php the_post_thumbnail($thumb,array('alt'=>esc_attr(get_the_title())));	?>
                    <?php if($ratio !=='rd-ratio-auto'){?>
					<figure style="background-image:url('<?php echo get_the_post_thumbnail_url($post->ID, $thumb);?>');"></figure>
                    <?php }?>
                  </a>
             </div>
		<?php
		}
	}
	 
}
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																  Game Background
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_game_background( $option=false) { 
 		
 		global $post;
		
		$thumb =  reza_data($option,'thumb','full'); 
  		$style='';
  		
	$thumbnail= wp_get_attachment_image_src( reza_meta('sao_game_body_background_image'), $thumb );
 	$image_url= !empty($thumbnail[0])?$thumbnail[0]:'';
		$the_permalink = get_permalink();
 		if(!empty($thumbnail[0])){
 		?>
            <div class="rd-thumb" > 
                  <a <?php if(!empty($the_permalink)){?>href="<?php echo esc_url($the_permalink) ?>"  <?php } ?> >
 					<figure style="background-image:url('<?php echo esc_url($image_url);?>');"></figure>
                  </a>
             </div>
		<?php
		}
 
	 
}
 
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																  Game Excerpt
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_game_excerpt($option=false) {
	global $post;
 	$sao_game_summary = reza_meta('sao_game_summary');
	
	if(empty(reza_meta('sao_show_page_builder')) || $sao_game_summary){		  
		 $limit = reza_data($option,'excerpt_limit');
   		$the_excerpt = strip_tags($sao_game_summary);
		if ( !empty($limit) && strlen($the_excerpt) > $limit){
			 $content= mb_substr($the_excerpt, 0,$limit).'...';
			 
		}else{
			$content= $the_excerpt;
		}
		if(!empty($content)){?>
		<div class="rd-excerpt"><?php echo esc_html($content);?></div>
		<?php 
		}
	}
}
 

 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																Game Meta Query
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_game_meta_query($option=false){
 
	$orderby = reza_data($option,'orderby');
	$array =array();
 
	if( $orderby == 'last-reviews-week' || $orderby == 'best-reviews-week' || $orderby == 'last-metacritic-week'  ||$orderby == 'best-metacritic-week'){
		$date = array(date( 'Y-m-d', strtotime( '-1 weeks' )), date("Y-m-d"));
		
  	}elseif($orderby == 'last-reviews-month' || $orderby == 'best-reviews-month' || $orderby == 'last-metacritic-month'  ||$orderby == 'best-metacritic-month'){
		$date = array(date( 'Y-m-d', strtotime( '-1 months' )), date("Y-m-d"));
		
 	}elseif($orderby == 'last-reviews-month-3' || $orderby == 'best-reviews-month-3' || $orderby == 'last-metacritic-month-3'  ||$orderby == 'best-metacritic-month-3'){
		$date = array(date( 'Y-m-d', strtotime( '-3 months' )), date("Y-m-d"));
	
	}elseif($orderby == 'last-reviews-month-6' || $orderby == 'best-reviews-month-6' || $orderby == 'last-metacritic-month-6'  ||$orderby == 'best-metacritic-month-6'){
		$date = array(date( 'Y-m-d', strtotime( '-6 months' )), date("Y-m-d")); 
		
	}elseif($orderby == 'last-reviews-year' || $orderby == 'best-reviews-year' || $orderby == 'last-metacritic-year'  ||$orderby == 'best-metacritic-year'){
		$date = array(date( 'Y-m-d', strtotime( '-1 year' )), date("Y-m-d")); 
		
	}else{
		$date =array('0001-01-01', date("Y-m-d"));
 	}
	
	
	if( $orderby == 'allgames' ){
		$array='';
	}
  	elseif( $orderby == 'upcoming'){
	 	$array = array( 
				'relation' => 'AND',
					array(
						'key'     => 'sao_game_release',
						'value'   =>  array(date("Y-m-d"),'9999-01-01'),
						'compare' => 'BETWEEN',
						'type'    => 'date',
        		),
				 'orderby' => array(
        'post_title' => 'ASC', // ترتیب بر اساس post_title
        'ID'         => 'ASC', // ترتیب بر اساس post_id
    ),
		);
	 
 	 
	} elseif( $orderby == 'date'){
	 
	 	$array = array( 
				'relation' => 'OR',
					array(
						'key'     => 'sao_game_release',
						'value'   => array(date("Y-m-d"),'9999-01-01'),
						'compare' => 'BETWEEN',
						'type'    => 'date',
        			),array(
						'key'     => 'sao_game_release',
						'value'   => $date,
						'compare' => 'BETWEEN',
						'type'    => 'date',
        			)
				);
 	 
	}elseif( $orderby == 'last-reviews' || $orderby == 'last-reviews-week' || $orderby == 'last-reviews-month' || $orderby == 'last-reviews-month-3' || $orderby == 'last-reviews-month-6' || $orderby == 'last-reviews-year' ){
	 	$array = array(
					'relation' => 'AND',
						array(
 							'key'     => 'sao_game_release',
							'value'   =>  $date,
							'compare' => 'BETWEEN',
							'type'    => 'date',
						),
						array(  
							'key' => 'sao_game_review_score',
							'value' => array( 1, 100 ),
							'type' => 'numeric',
							'compare' => 'BETWEEN'
						)
					);
 	 
	}
	elseif( $orderby == 'last-metacritic' || $orderby == 'last-metacritic-week' || $orderby == 'last-metacritic-month' || $orderby == 'last-metacritic-month-3' || $orderby == 'last-metacritic-month-6' || $orderby == 'last-metacritic-year' ){
	 	$array = array(
					'relation' => 'AND',
						array(
 							'key'     => 'sao_game_release',
							'value'   =>  $date,
							'compare' => 'BETWEEN',
							'type'    => 'date',
						),
						array(  
							'key' => 'sao_game_metacritic',
							'value' => array( 1, 100 ),
							'type' => 'numeric',
							'compare' => 'BETWEEN'
						)
					);
 	 
	} else{
		
		$array = array( 
				'relation' => 'AND',
					array(
						'key'     => 'sao_game_release',
						'value'   => $date,
						'compare' => 'BETWEEN',
						'type'    => 'date',
        			)
				);
	}
 	return $array;
}
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																Game Orderby
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_game_orderby($option=false){
	$orderby = reza_data($option,'orderby');
 	if( $orderby == 'allgames' ){
		$order='date';
	}
 	elseif( $orderby == 'best-reviews' 					|| 
		$orderby == 'best-reviews-week' 			|| 
		$orderby == 'best-reviews-month'			|| 
		$orderby == 'best-reviews-month-3'			|| 
		$orderby == 'best-reviews-month-6'			|| 
		$orderby == 'best-reviews-year'				||  	
		$orderby == 'best-metacritic' 				|| 
		$orderby == 'best-metacritic-week' 			|| 
		$orderby == 'best-metacritic-month'			|| 
		$orderby == 'best-metacritic-month-3'		|| 
		$orderby == 'best-metacritic-month-6'		|| 
		$orderby == 'best-metacritic-year' 	
	){
		$order='meta_value_num title date';
		
	} else {
 		$order='meta_value title date';
	}
	
 	
	return $order;

} 
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																Game Meta Key
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_game_meta_key($option=false){
	$orderby = reza_data($option,'orderby');
	if( $orderby == 'allgames' ){
		$order='';
	}
 	elseif( $orderby == 'best-reviews' 					|| 
		$orderby == 'best-reviews-week' 			|| 
		$orderby == 'best-reviews-month'			|| 
		$orderby == 'best-reviews-month-3'			|| 
		$orderby == 'best-reviews-month-6'			|| 
		$orderby == 'best-reviews-year'				
	){
		$order='sao_game_review_score';
		
	}elseif(
		$orderby == 'best-metacritic' 			|| 
		$orderby == 'best-metacritic-week' 			|| 
		$orderby == 'best-metacritic-month'			|| 
		$orderby == 'best-metacritic-month-3'		|| 
		$orderby == 'best-metacritic-month-6'		|| 
		$orderby == 'best-metacritic-year' 	
	){
		$order='sao_game_metacritic';
		
	} else {
 		$order='';
	}
	return $order;
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																Game Order
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_game_order($option=false){
	$orderby = reza_data($option,'orderby');
	 
	if( $orderby == 'allgames' ){
		$order='';
	}
 	elseif( $orderby == 'upcoming' ){
		$order='ASC';
		
	} elseif( $orderby == 'date' ){
		$order='DESC';
		
	} else {
 		$order='DESC';
	}
	return $order;
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																Game Meta
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_game_meta($option =false,$font =false){ 
	$platform = wp_get_post_terms(get_the_ID(),"platform");
 	$developer = wp_get_post_terms(get_the_ID(),"developer");
 	$publisher = wp_get_post_terms(get_the_ID(),"publisher");
 	$genre = wp_get_post_terms(get_the_ID(),"genre");
 
 	$meta = reza_data($option,'game_meta');

 	$meta_relesae = !empty($meta['meta_relesae'] )? $meta['meta_relesae']:'' ;
  	$meta_platforms = !empty($meta['meta_platforms'] )   ? $meta['meta_platforms']:'' ;
 	$meta_developer =!empty( $meta['meta_developer'])   ? $meta['meta_developer']:'' ; 
 	$meta_publisher =!empty( $meta['meta_publisher'])    ? $meta['meta_publisher']:'' ; 
   	$meta_genre =!empty( $meta['meta_genre'])  ? $meta['meta_genre']:'' ; 
	
	
  	if( !empty($meta_relesae) || !empty($meta_platforms) ||!empty($meta_developer) || !empty($meta_publisher) || !empty($meta_genre) ){ 
 
 	
		if(!empty($meta_relesae)){
				 reza_game_release();
		}
		if(!empty($meta_platforms)  ){
 				 reza_game_platform();
		}
		if(!empty($meta_developer)){
 				reza_game_developer();
		}
		if(!empty($meta_publisher)){
				reza_game_publisher();
		}
		if(!empty($meta_genre)){
				reza_game_genre();
 		}
 
	}
}
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																  Game Paged
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_game_paged(   $use_forwarded_host = false ){
	global $post,$wp;
  	$s =$_SERVER;
	$absolute_url = reza_game_url_origin( $s, $use_forwarded_host ) . $s['REQUEST_URI'];
  	$array = explode('/', trim($absolute_url,'/')); 

 $page_number = end($array);
$fruit = array_pop($array);
$page_str = end($array);
	if(is_numeric($page_number) &&  $page_str =='page'){;
		$numpaged = $page_number;
	}else{
		$numpaged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
	}
 return $numpaged;
}
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																  Url Origin
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_game_url_origin( $s, $use_forwarded_host = false ){
    $ssl      = ( ! empty( $s['HTTPS'] ) && $s['HTTPS'] == 'on' );
    $sp       = strtolower( $s['SERVER_PROTOCOL'] );
    $protocol = substr( $sp, 0, strpos( $sp, '/' ) ) . ( ( $ssl ) ? 's' : '' );
    $port     = $s['SERVER_PORT'];
    $port     = ( ( ! $ssl && $port=='80' ) || ( $ssl && $port=='443' ) ) ? '' : ':'.$port;
    $host     = ( $use_forwarded_host && isset( $s['HTTP_X_FORWARDED_HOST'] ) ) ? $s['HTTP_X_FORWARDED_HOST'] : ( isset( $s['HTTP_HOST'] ) ? $s['HTTP_HOST'] : null );
    $host     = isset( $host ) ? $host : $s['SERVER_NAME'] . $port;
    return $protocol . '://' . $host;
}
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																Game Rewrite
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_rewrite_rule() {
	$game_tracking = reza_game_tracking();
  		
 		if(!empty($game_tracking)){
		foreach($game_tracking as $kay => $name):
 
   		  add_rewrite_rule( 'game/([^/]+)/'.$kay, 'index.php?game=$matches[1]&'.$kay.'=yes', 'top' );

 		endforeach;
 		}
   
}

add_action( 'init', 'reza_rewrite_rule' ); 
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																Game Redicet
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_custom_disable_redirect_canonical($redirect_url) { 
    return false;
}
add_filter('redirect_canonical','reza_custom_disable_redirect_canonical');
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																Game Qurey var
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_register_query_var( $vars ) {

	 $game_tracking = reza_game_tracking();
  		
 		if(!empty($game_tracking)){
		foreach($game_tracking as $kay => $name):
    $vars[] = $kay;

 		endforeach;
 		}
    return $vars;
	
}
 
add_filter( 'query_vars', 'reza_register_query_var' );
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																Filter Query
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_filter_query($sql){
	global $post,$wpdb;
	
 	$game_tracking = reza_game_tracking();
	if(!empty($game_tracking)){
	foreach($game_tracking as $kay => $name):
		if( get_query_var( $kay ) && is_singular( 'game' )){
 				$slug = $kay;
		}
	endforeach;
	} 
	if(!empty($slug)){	 
	$category = $wpdb->get_results("
		SELECT $wpdb->terms.term_id 
		FROM $wpdb->terms
		LEFT JOIN $wpdb->term_taxonomy ON $wpdb->terms.term_id = $wpdb->term_taxonomy.term_id 
		WHERE $wpdb->terms.slug = '".sanitize_title($slug)."'
		AND $wpdb->term_taxonomy.taxonomy = 'category'
		" 
	);
	}
  		 
 
	$sql['join'] = " 
		LEFT JOIN $wpdb->postmeta ON($wpdb->posts.ID = $wpdb->postmeta.post_id)
		LEFT JOIN {$wpdb->term_relationships} ON {$wpdb->posts}.ID = {$wpdb->term_relationships}.object_id
        LEFT JOIN {$wpdb->term_taxonomy} ON {$wpdb->term_taxonomy}.term_taxonomy_id = {$wpdb->term_relationships}.term_taxonomy_id
        LEFT JOIN {$wpdb->terms} ON {$wpdb->terms}.term_id = {$wpdb->term_taxonomy}.term_id 
 		LEFT JOIN $wpdb->term_relationships AS tt1 ON ($wpdb->posts.ID = tt1.object_id)
	";
	$term = !empty($category[0]->term_id) ?' AND tt1.term_taxonomy_id IN ('.$category[0]->term_id.') ':'';
		
	$sql['where']= "AND (({$wpdb->terms}.name LIKE '".get_the_title()."' ".$term." ) OR ( $wpdb->postmeta.meta_key = 'sao_game_id' AND $wpdb->postmeta.meta_value = '".$post->post_name."' ".$term." ) )";	
 	 
    return $sql;
}
  /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																Game Query
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_game_query(){

 

	global $post,$_GET;

	$posts_per_page = get_option('posts_per_page');

 	$main_query = array(
		'posts_per_page'	=> !empty($posts_per_page)?$posts_per_page:'5',
		'paged'				=> reza_game_paged(),
 		'tax_query'  

	);
	
	
	$bazinews_tracking= reza_option('bazinews_tracking')?reza_option('bazinews_tracking'):'tags';
 	if($bazinews_tracking==='tags'){
		$main_query['tax_query']=  array(
 				array(
					'taxonomy' => 'post_tag',
					'field'    => 'slug',
					'terms'    => $post->post_name,
					'operator' => 'IN'
				),

		 );
		
 	 $query = new wp_query( $main_query );

		
		
	}
	if($bazinews_tracking==='meta' || $bazinews_tracking==='tags-meta'){
		 $main_query['meta_query'] =  array(
					'relation' => 'OR',
					array(
					'key' => 'sao_game_id',
					'value' =>  $post->post_name,
					'compare' => '='			
					) 
			);	
			
	if($bazinews_tracking==='tags-meta'){add_filter('get_meta_sql', 'reza_filter_query', 10, 1);};
		 $query = new wp_query( $main_query );
		if($bazinews_tracking==='tags-meta'){remove_filter('get_meta_sql', 'reza_filter_query');};
		
		
	}
	
 	
 	 return $query;

}
  /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																Game Query Single
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_game_query_single(){

	

	global $post,$_GET;

	$posts_per_page = get_option('posts_per_page');

  	$game_tracking = reza_game_tracking();

	if(!empty($game_tracking)){

	foreach($game_tracking as $kay => $name):

		if( get_query_var( $kay ) && is_singular( 'game' )){

 				$cats = $kay;
		}

	endforeach;

	} 
 
	$main_query = array(
		'posts_per_page'	=> !empty($posts_per_page)?$posts_per_page:'5',
		'paged'				=>reza_game_paged(),
		'category_name'				=> !empty($cats)?$cats:'',
 	  
	);
	$bazinews_tracking= reza_option('bazinews_tracking')?reza_option('bazinews_tracking'):'tags';
 	if($bazinews_tracking==='tags'){
		$main_query['tax_query']=  array(
 				array(
					'taxonomy' => 'post_tag',
					'field'    => 'slug',
					'terms'    => $post->post_name,
					'operator' => 'IN'
				),

		 );
		
 	 $query = new wp_query( $main_query );

		
		
	}
	if($bazinews_tracking==='meta' || $bazinews_tracking==='tags-meta'){
		 $main_query['meta_query'] =  array(
					'relation' => 'OR',
					array(
					'key' => 'sao_game_id',
					'value' =>  $post->post_name,
					'compare' => '='			
					) 
			);	
		if($bazinews_tracking==='tags-meta'){add_filter('get_meta_sql', 'reza_filter_query', 10, 1);};
		 $query = new wp_query( $main_query );
		if($bazinews_tracking==='tags-meta'){remove_filter('get_meta_sql', 'reza_filter_query');};
		
	}
	
	return $query;
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
																Query Video

 *//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function reza_game_query_video(){

	global $post,$_GET;
	$posts_per_page = get_option('posts_per_page');
	$main_query = array(
		'posts_per_page'	=>  '5',
		'category_name'				=> reza_option('bazinews_game_videos_category'),			 
 
	);
	$bazinews_tracking= reza_option('bazinews_tracking')?reza_option('bazinews_tracking'):'tags';
 	if($bazinews_tracking==='tags'){
		$main_query['tax_query']=  array(
 				array(
					'taxonomy' => 'post_tag',
					'field'    => 'slug',
					'terms'    => $post->post_name,
					'operator' => 'IN'
				),

		 );
		
 	 $query = new wp_query( $main_query );

		
		
	}
	if($bazinews_tracking==='meta' || $bazinews_tracking==='tags-meta'){
		 $main_query['meta_query'] =  array(
					'relation' => 'OR',
					array(
					'key' => 'sao_game_id',
					'value' =>  $post->post_name,
					'compare' => '='			
					) 
			);	
	if($bazinews_tracking==='tags-meta'){add_filter('get_meta_sql', 'reza_filter_query', 10, 1);};
		 $query = new wp_query( $main_query );
		if($bazinews_tracking==='tags-meta'){remove_filter('get_meta_sql', 'reza_filter_query');};
		
		
	}
	
	return $query;
}
/*****************************************************************************************************************************************************

******************************************************************************************************************************************************
																Query Single Video

*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

 function reza_game_query_single_video(){

	global $post,$_GET;
	$posts_per_page = get_option('posts_per_page');
  	$videos_slug =  reza_option('bazinews_game_videos_category');
	$main_query = array(
		'posts_per_page'	=> !empty($posts_per_page)?$posts_per_page:'5',
		'paged'				=> reza_game_paged(),
		'category_name'		=> $videos_slug,
 		 
	);
	
$bazinews_tracking= reza_option('bazinews_tracking')?reza_option('bazinews_tracking'):'tags';
 	if($bazinews_tracking==='tags'){
		$main_query['tax_query']=  array(
 				array(
					'taxonomy' => 'post_tag',
					'field'    => 'slug',
					'terms'    => $post->post_name,
					'operator' => 'IN'
				),

		 );
		
 	 $query = new wp_query( $main_query );

		
		
	}
	if($bazinews_tracking==='meta' || $bazinews_tracking==='tags-meta'){
		 $main_query['meta_query'] =  array(
					'relation' => 'OR',
					array(
					'key' => 'sao_game_id',
					'value' =>  $post->post_name,
					'compare' => '='			
					) 
			);	
	if($bazinews_tracking==='tags-meta'){add_filter('get_meta_sql', 'reza_filter_query', 10, 1);};
		 $query = new wp_query( $main_query );
		if($bazinews_tracking==='tags-meta'){remove_filter('get_meta_sql', 'reza_filter_query');};
		
		
	}
	
	
	
  	 $query = new wp_query( $main_query );
	 return $query;
}

/*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
															Query Videos
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_filter_query_videos($sql){
	global $post,$wpdb;
	
	$videos_slug =  reza_option('bazinews_game_videos_category');

	if(!empty($videos_slug)){	 
	$category = $wpdb->get_results("
		SELECT $wpdb->terms.term_id 
		FROM $wpdb->terms
		LEFT JOIN $wpdb->term_taxonomy ON $wpdb->terms.term_id = $wpdb->term_taxonomy.term_id 
		WHERE $wpdb->terms.slug = '".$videos_slug."'
		AND $wpdb->term_taxonomy.taxonomy = 'category'
		" 
	);
	}
  		 
 
	$sql['join'] = " 
		LEFT JOIN $wpdb->postmeta ON($wpdb->posts.ID = $wpdb->postmeta.post_id)
		LEFT JOIN {$wpdb->term_relationships} ON {$wpdb->posts}.ID = {$wpdb->term_relationships}.object_id
        LEFT JOIN {$wpdb->term_taxonomy} ON {$wpdb->term_taxonomy}.term_taxonomy_id = {$wpdb->term_relationships}.term_taxonomy_id
        LEFT JOIN {$wpdb->terms} ON {$wpdb->terms}.term_id = {$wpdb->term_taxonomy}.term_id 
 		LEFT JOIN $wpdb->term_relationships AS tt1 ON ($wpdb->posts.ID = tt1.object_id)
	";
	$term = !empty($category[0]->term_id) ?' AND tt1.term_taxonomy_id IN ('.$category[0]->term_id.') ':'';
		
	$sql['where']= "AND (({$wpdb->terms}.name LIKE '".get_the_title()."' ".$term." ) OR ( $wpdb->postmeta.meta_key = 'sao_game_id' AND $wpdb->postmeta.meta_value = '".$post->post_name."' ".$term." ) )";	
 	 
    return $sql;
}