<?php 
include_once REZA_PATH . '/inc/blog/blog-module-1.php';  
include_once REZA_PATH . '/inc/blog/blog-module-2.php';  
include_once REZA_PATH . '/inc/blog/blog-module-3.php';  
include_once REZA_PATH . '/inc/blog/blog-module-4.php';  
include_once REZA_PATH . '/inc/blog/single-functions.php'; 

/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																Blog Archive
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_blog_archive($title =false){
	$args=array();
	$args['key'] = 'archive';
	$blog_layout=reza_option('bazinews_blog_layout' );
	
	if($blog_layout=='list'){
		$layout = reza_option('bazinews_blog_list_layout' );
	}else{
		$layout = reza_option('bazinews_blog_grid_layout' );
	}
	$args['option'] = array(
		'archive'			=>  '1',
		'number'			=> get_option('posts_per_page'),	
		'title'				=> $title ,
		'layout'			=> $layout, 
		'title_box_tag'				=> 'h1' ,
  		'excerpt' 			=> reza_option('bazinews_blog_excerpt',true),
		'title_limit' 		=> reza_option('bazinews_title_excerpt_limit'),
		'excerpt_limit' 	=> reza_option('bazinews_blog_excerpt_limit'),
 		'readmore' 			=> reza_option('bazinews_blog_readmore',true),
 		"responsive_column" => reza_option('bazinews_blog_responsive_column'), 
		'meta_category'			=>  reza_option('blog_meta_category',true),
		'meta'			=> array(
		
 				'meta_author'			=> reza_option('bazinews_blog_meta_author',true),
				'meta_date'				=>  reza_option('bazinews_blog_meta_date',true),
				'meta_view'				=>  reza_option('bazinews_blog_meta_view',true),
				'meta_comments'			=>  reza_option('bazinews_blog_meta_comments',true),
		),
		'more_posts'		=>  'pagenavi',
 
     );
	if($blog_layout=='list'){
		echo reza_blog_list_config($args, true);
	}else{
		echo reza_blog_grid_config($args, true);
	}
}

/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																Blog Featured Image Meta
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_blog_featured_image_meta() { 
   if( reza_meta('bazinews_featured_image_meta')  == 'video' ){ ?>
 			<i class="rd-icon-video"></i>
  	<?php
	}elseif( reza_meta('bazinews_featured_image_meta') == 'review' ){  
		reza_review_circular();  
	} 
}  
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																Blog Thumb
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_blog_thumb( $option,$figcaption=false,$image_meta=false,$category=false) { 
 	
	if(has_post_thumbnail()){
		
 		global $post;
		
		$thumb =  reza_data($option,'thumb','full'); 
		$hover_post_icon = reza_data($option,'hover_post_icon',reza_option('bazinews_blog_hover_post_icon')); 
 		$style='';
  		
		$thumbnail= wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), $thumb );
		$the_permalink = get_permalink();
 		if(!empty($thumbnail[0])){
 		?>
            <div class="rd-thumb" > 
            
                <a <?php if(!empty($the_permalink)){?>href="<?php echo esc_url($the_permalink) ?>"  <?php } ?>   >
                
                    <?php the_post_thumbnail($thumb,array('alt'=>esc_attr(get_the_title())));	?>
                    
                    <?php if(reza_data($option,'ratio',reza_option('bazinews_blog_ratio'))!=='rd-ratio-auto'){?>
                        <figure style="background-image:url('<?php echo get_the_post_thumbnail_url($post->ID, $thumb);?>');"></figure>
                    <?php }?>
                    
                 </a>
                 
                 <?php
                 if(empty($image_meta)){
                     reza_blog_featured_image_meta();
                 }
				 if(!empty($category)){
					reza_blog_category($option,1);
				}
                 if($hover_post_icon =='show' && !empty($figcaption)){ ?>
     
                    <figcaption>
                    <?php reza_post_hover_link($the_permalink);?>
                    </figcaption> 
    
                <?php }
				
				 ?>
                  
            </div>
		<?php
		}
	}
}




/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																Blog Post Title
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_blog_post_title($option= false,$font=false) {
	 	$limit = reza_data($option,'title_limit');    

	$the_title = strip_tags(get_the_title());
  	if ( !empty($limit) && strlen($the_title) > $limit){
 		 $content= mb_substr($the_title, 0,$limit).'...';
		 
	} else {
		$content= $the_title;
		$dots='';
	}
  	?>
    
 	<h3 class="rd-title"><a href="<?php the_permalink(); ?>"><?php echo esc_html($content);?></a></h3>
 	 	
	<?php 
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																Blog Excerpt
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_blog_excerpt($option=false) {
	global $post;
	if(empty(reza_meta('sao_show_page_builder')) || has_excerpt()){		  
		 $limit = reza_data($option,'excerpt_limit');
   		$the_excerpt = strip_tags(get_the_excerpt());
		if ( !empty($limit) && strlen($the_excerpt) > $limit){
			 $content= mb_substr($the_excerpt, 0,$limit).'...';
			 
		}else{
			$content= $the_excerpt;
		}
		if(!empty($content)){?>
		<div class="rd-excerpt"><?php echo esc_html($content);?></div>
		<?php 
		}
	}
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																Blog Excerpt Category
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_blog_category($option,$item= 1) {
	$terms = wp_get_post_terms(get_the_ID(),"category");
	$meta = reza_data($option,'meta');
	$meta_category = reza_data($option,'meta_category');
	$class='';
  	if(!empty($meta_category)){
 	$count=0;
 	if(!empty($terms)){
 		echo '<div class="rd-all-category-blog">';
			foreach ( $terms as $term ) { $count++;  
			echo '<a href="'.esc_url(get_term_link($term->term_id)).'">'.esc_html( $term->name).'</a>';
	 
			if($count == $item) { 
				break;
			}
			} 
		echo '</div>';
 	}}
}
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																Blog Meta
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_blog_meta($option =false){ 
	global  $post,$smof_data;
	$meta = reza_data($option,'meta');
   	$meta_author = !empty($meta['meta_author'] )? $meta['meta_author']:'' ;
 	$meta_date = !empty($meta['meta_date'] )? $meta['meta_date']:'' ;
 	$meta_view =!empty( $meta['meta_view'])? $meta['meta_view']:'' ; 
 	$meta_comments =!empty( $meta['meta_comments'])? $meta['meta_comments']:'' ; 
  
   	if( !empty($meta_author) || !empty($meta_comments) || !empty($meta_date) ||!empty($meta_view) || !empty($meta_category)  ){ 
 	
	$class='';
	$layout = reza_option_2('bazinews_blog_meta_layout','layout');
	if($layout=='layout-2' || $layout=='layout-5' ){
		$avatar = get_avatar( get_the_author_meta( 'ID' ), 32 );
	}else{
		$avatar='';
	}
   
   	if($layout=='layout-3'){
 		$by='';
	}else{
		$by = reza_t('by');
	}
	?>
  
	  
		<ul class="rd-meta">
  
  			<?php
 
     		//Meta Author
			if( !empty($meta_author)){ 
 				echo '<li class="rd-author  ">'.wp_kses_post($avatar.esc_html($by)).' ';
					the_author_posts_link();
				echo '</li>';
			}
	 
	  
    
			 if(!empty( $meta_date) ){ 
				echo '<li class="rd-date">';
					reza_get_time();
				echo '</li>';
			} 
    
 			if( !empty($meta_view )){
				echo '<li class="rd-view ">'.reza_getPostViews(get_the_ID()).'</li>';
			}	
 			if( !empty($meta_comments )){
				echo '<li class="rd-comment">'.reza_blog_meta_comments().'</li>';
			}	
			?>
 		 
	</ul> 
      
	<?php
	 }
} 
  
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																Blog Meta Comments
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_blog_meta_comments($no_text =false){ 
	ob_start(); 

 		if(!empty($no_text)){
			  comments_popup_link(reza_t('0'),reza_t('1') ,esc_html('%'), '' , reza_t('0'));
 		} else{
			  comments_popup_link(reza_t('nocommentsyet'),reza_t('1').' '.reza_t('commentalready') ,esc_html('%'.' '.reza_t('commentsalready')), '' , reza_t('commetsoff'));
		}
		   return  ob_get_clean();;

}
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************

																Blog Read More
																		
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_readmore($option =false){ ?>
	 <div class="rd-readmore"><a href="<?php the_permalink();?>"  ><?php echo esc_html(reza_t('read_more'));?></a></div>
	<?php
}