<?php
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															Blog General
																		
*////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

$this->start_controls_section(
	'general',
	[
		'label'			=> __( 'General', 'reza' ),
 	]
); 

$this->add_control(
	'number',
	[
		'label'			=> __( 'Categories Count', 'reza' ),
		'type'			=> \Elementor\Controls_Manager::NUMBER,
		'default'		=> '4',
	]
);
$this->add_control(
	'source',
	[
		'label'			=> __( 'Source', 'reza' ),
		'type'			=> \Elementor\Controls_Manager::SELECT,
		'options'		=> array(
			'' 						=> __( 'Show All', 'reza' ),
			'by_id' 				=> __( 'Manual Selection', 'reza' ),
			'by_parent' 			=> __( 'By Parent', 'reza' ),
			'current_subcategories' => __( 'Current Subcategories', 'reza' ),
		),
 	]
);

$categories = get_terms( 'product_cat' );

$options = array();
	foreach ( $categories as $category ) {
		$options[ $category->term_id ] = $category->name;
}

$this->add_control(
	'categories',
	[
		'label'			=> __( 'Categories', 'reza' ),
		'type'			=> \Elementor\Controls_Manager::SELECT2,
		'options'		=> $options,
		'default'		=> [],
		'label_block'	=> true,
		'multiple'		=> true,
		'condition'		=> array('source' => 'by_id'),
	]
);

$parent_options = [ '0' => __( 'Only Top Level', 'reza' ) ] + $options;
$this->add_control(
	'parent',
	[
		'label'			=> __( 'Parent', 'reza' ),
		'type'			=> \Elementor\Controls_Manager::SELECT,
		'default'		=> '0',
		'options'		=> $parent_options,
		'condition'		=> array('source' => 'by_parent'),
	]
);

$this->add_control(
	'hide_empty',
	[
		'label'			=> __( 'Hide Empty', 'reza' ),
		'type'			=> \Elementor\Controls_Manager::SWITCHER,
		'default'		=> '',
		'label_on'		=> 'Hide',
		'label_off'		=> 'Show',
	]
);

$this->add_control(
	'orderby',
	[
		'label'			=> __( 'Order By', 'reza' ),
		'type'			=> \Elementor\Controls_Manager::SELECT,
		'default'		=> 'name',
		'options'		=> array(
			'name'			=> __( 'Name', 'reza' ),
			'slug'			=> __( 'Slug', 'reza' ),
			'description'	=> __( 'Description', 'reza' ),
			'count'			=> __( 'Count', 'reza' ),
		)
	]
);

$this->add_control(
	'order',
	[
		'label'			=> __( 'Order', 'reza' ),
		'type'			=> \Elementor\Controls_Manager::SELECT,
		'default'		=> 'asc',
		'options'		=> array(
			'asc'			=> __( 'ASC', 'reza' ),
			'desc'			=> __( 'DESC', 'reza' ),
		),
	]
);

$this->add_control(
	'hide_title',
	[
		'label'			=> __( 'Hide Categories Ttile', 'reza' ),
		'type'			=> \Elementor\Controls_Manager::SWITCHER,
		'default'		=> '',
		'label_on'		=> 'Hide',
		'label_off'		=> 'Show',
	]
);
   
$this->add_control(
	'hide_count',
	[
		'label'			=> __( 'Hide Categories Count', 'reza' ),
		'type'			=> \Elementor\Controls_Manager::SWITCHER,
		'default'		=> '',
		'label_on'		=> 'Hide',
		'label_off'		=> 'Show',
	]
);
   
  



 $this->end_controls_section();

