<?php
 
class reza_element_share_icons extends \Elementor\Widget_Base {

 
	public function get_name() {
		return 'bazinews_share_icons';
	}

 	public function get_title() {
		return  __('Share Icons','reza');
	}

 
	public function get_icon() {
		return 'reza-element-share';
	}
	public function get_categories() {
		return [ 'reza' ];
	}


protected function register_controls() {
 		 
   		 $this->register_controls_share_icons();
 		 $this->register_controls_layout();
  		$this->register_controls_style(); 
    
	}
    


 
	 
	 
	protected function register_controls_share_icons(){
 			
		$this->start_controls_section(
			'share_icons',
			[
				'label'			=> __( 'Share Icons', 'reza' ),
			]
		); 	
		 
	$this->add_control(
			'share_url',
			[
				'label'			=> __('URL Share','reza'),
	 			'type'			=> \Elementor\Controls_Manager::TEXT ,
 				"default"		=> "http://google.com",
 				 
 			]
		); 
		
  	foreach ( reza_array_options('share') as $key => $name){
	$this->add_control(
			$key,
			[
				'label'			=> __('Share by','reza').' '.$name,
	 			'type'			=> \Elementor\Controls_Manager::SWITCHER ,
	 			"default"		=> 'yes',
 				 
 			]
		); 
	} 
								 		
	   
  
    
    $this->end_controls_section();

 		 
		
 	} 
 protected function register_controls_layout(){
 			
		$this->start_controls_section(
			'share_layout',
			[
				'label'			=> __('Layout','reza'),
			]
		); 	
		  
	$this->add_control(
			'icon_size',
			[
				'label'			=> __('Share Icon Size','reza'),
				'type'			=> \Elementor\Controls_Manager::NUMBER ,
				'selectors' 	=> array(
					'{{WRAPPER}} [class*="rd-el-"]' => '--rd-scl-sz: {{VALUE}}px',
				),
				 
 			]
		); 	
		$this->add_control(
			'between',
			[
				'label'			=> __('Space Between Item','reza'),
				'type'			=> \Elementor\Controls_Manager::SELECT,
				'options'		=> reza_array_options('between',true),
			]
		);	
	 
  
		$this->add_control(
			'alignment',
			[
				'label'			=> __('Alignment','reza'),
				'type'			=> \Elementor\Controls_Manager::SELECT ,
				"default"		=> "center",
			"options" 		=> reza_array_options('alignment_rtl',true), 
			]
		); 	
 
 
	
    $this->end_controls_section();
 }
 	
	protected function register_controls_style(){
		$this->start_controls_section(
			'style',
			[
				'label'			=> __('Style','reza'),
				'tab'			=> \Elementor\Controls_Manager::TAB_STYLE,
			]
		); 	
		$this->add_control(
			'icon_style',
			[
				'label'			=> __('Icon Style','reza'),
				'type'			=> \Elementor\Controls_Manager::SELECT ,
				"default"		=> "style-1",
				"options"		=> array(
					"style-1" 		=> esc_html__('Style 1: only icon','reza'),
					"style-2" 		=> esc_html__('Style 2: Boxed Icon','reza'),
					"style-3" 		=> esc_html__('Style 3: Boxed Original Color','reza'),
				),					
			]
		); 	
		
		 $this->add_control(
			'icon_color',
			[
				'label'			=>__('Share Icon Color','reza'),
				'type'			=> \Elementor\Controls_Manager::COLOR,
				'condition'		=> array('icon_style' => array('style-1','style-2')),
				
				'selectors' 	=> array(
							'{{WRAPPER}} [class*="rd-el-"]' => '--rd-scl-txt: {{VALUE}}',
					),			
			]
		); 	
	  
		 $this->add_control(
			'icon_background',
			[
				'label'			=>__('Share Icon Background','reza'),
				'type'			=> \Elementor\Controls_Manager::COLOR,
				'condition'		=> array('icon_style' => array('style-2')),
				
				'selectors' 	=> array(
							'{{WRAPPER}} [class*="rd-el-"]' => '--rd-scl-bg: {{VALUE}}',
					),			
			]
		); 	
	  
		 $this->add_control(
			'icon_border_color',
			[
				'label'			=>__('Share Icon Border Color','reza'),
				'type'			=> \Elementor\Controls_Manager::COLOR,
				'condition'		=> array('icon_style' => array('style-2')),
				
				'selectors' 	=> array(
							'{{WRAPPER}} [class*="rd-el-"]' => '--rd-scl-br-cr: {{VALUE}}',
					),			
			]
		); 	
	  
	 
		 $this->add_control(
			'icon_radius',
			[
				'label'			=>__('Share Icon Border Radius','reza'),
				'type'			=> \Elementor\Controls_Manager::SELECT,
				'condition'		=> array('icon_style' => array('style-2','style-3')),
  		"options"		=>  reza_array_options('radius',true),						
				'selectors' 	=> array(
							'{{WRAPPER}} [class*="rd-el-"]' => '--rd-scl-rd: {{VALUE}}',
					),			
			]
		); 	
	  
	 
    $this->end_controls_section();



	}	
			 	 

 	
protected function render() {
	
	
		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			global $elementor_post_id;
			$elementor_post_id= $_GET['post'];
		}
		
 		$option = $this->get_settings_for_display();
 		$args=array();
		$args['key']= $this->get_id();
		
		 
			 
	 
 		$args['option'] = array(
   			'share_url' 							=> reza_settings($option,'share_url'),
   			'between' 							=> reza_settings($option,'between'),
   			'alignment' 						=> reza_settings($option,'alignment'),
 
 			'icon_style' 							=> reza_settings($option,'icon_style'),
			
			 
     	); 
		
		 
				
		foreach ( reza_array_options('share') as $key => $name){
			
 	 		if(reza_settings($option,$key)){
				$args['option'][$key] = reza_settings($option,$key);
			}
		}
									
	 
		
		?>
   
 		 <div class="rd-elementor-<?php echo esc_attr($this->get_id());?>">      
  			
            
            <?php echo reza_share_icons_config($args,true,true);?>
		  
  		 
			<?php if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {?>
                 <div class="rd-elementor-script">     
                        <script type="text/javascript">
                          (function($) {
                            'use strict';
                            jQuery(document).ready(function() {				
                                $('.rd-elementor-<?php echo esc_html($this->get_id());?>').reza_elementor();
        
                             });
                            })(jQuery);
                       </script>
            
                </div>
			<?php }?>	
	
    	</div>
   
		 <?php
		 } 
	
} 