<?php
 
class reza_element_product_cat extends \Elementor\Widget_Base {

 
	public function get_name() {
		return 'bzinews_product_cat';
	}

 
	public function get_title() {
		return __( 'Product Categories', 'reza' );
	}

 
	public function get_icon() {
		return 'reza-element-product-cat';
	}
	public function get_categories() {
		return [ 'reza' ];
	}


	protected function  register_controls() {
 
		$this->register_controls_title_box();
   		$this->register_controls_general();
 		$this->register_controls_layout();
  		$this->register_controls_title_box_style();
  		$this->register_controls_style();
  		$this->register_controls_typography(); 
  
	}
    




	protected function register_controls_title_box(){
 		include  REZA_PATH . '/elementor/product_cat/elementor-product_cat-title-box.php';  
 	}
	 
	 
	protected function register_controls_general(){
 		include  REZA_PATH . '/elementor/product_cat/elementor-product_cat-general.php';  
 	}
	
	protected function register_controls_layout(){
 		include REZA_PATH . '/elementor/product_cat/elementor-product_cat-layout.php';  
 	}
 
 
	protected function register_controls_title_box_style(){
 		include  REZA_PATH . '/elementor/product_cat/elementor-product_cat-title-box-style.php';  
 	}		

 	
	protected function register_controls_style(){
 		include REZA_PATH . '/elementor/product_cat/elementor-product_cat-style.php';  
 	}	 	
	
 
	protected function register_controls_typography(){
 		include  REZA_PATH . '/elementor/product_cat/elementor-product_cat-typography.php';  
 	}	  
	
	protected function render() {
 		$option = $this->get_settings_for_display();
 		$args=array();
		$args['key']= $this->get_id();
		
		
 		$args['option'] = array(
		
		
			/*****************************************************************************************************************
			Title Box
			******************************************************************************************************************/
				'title'						=> reza_settings($option,'title'),
				'title_box_type'			=> reza_settings($option,'title_box_type'),
				'title_box_all'				=> reza_settings($option,'title_box_all'),
				'title_box_list_all' 		=> reza_settings($option,'title_box_list_all'),				
				'tabs'						=> reza_settings($option,'tabs'),
			
			/*****************************************************************************************************************
			General
			******************************************************************************************************************/
				'number'					=> reza_settings($option,'number'),
				'source'					=> reza_settings($option,'source'),
				
				 'categories'				=> reza_multi_cats_array(reza_settings($option,'categories')),
 				'parent' 					=> reza_settings($option,'parent'),
				'hide_empty'				=> 	reza_settings($option,'hide_empty'),
				'orderby'					=>	reza_settings($option,'orderby'),
 				'order'						=>	reza_settings($option,'order'),
				'hide_title'				=>	reza_settings($option,'hide_title'),
 				'hide_count' 				=> reza_settings($option,'hide_count'),
	 
 
			/*****************************************************************************************************************
			Layout
			******************************************************************************************************************/
				'column' 					=> reza_settings($option,'column'),
				'responsive_column' 				=> reza_settings($option,'responsive_column'),
				'between' 					=> reza_settings($option,'between'),
 				'ratio'						=> reza_settings($option,'ratio'),
				'box_layout' 					=> reza_settings($option,'box_layout'),
 
				
  
   		); 
  	 ?>
  		 <div class="rd-elementor-<?php echo esc_attr($this->get_id());?>">      
  			
            
            <?php echo reza_product_cat_config($args,true);?>
		  
  		 
			<?php if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {?>
                 <div class="rd-elementor-script">     
                        <script type="text/javascript">
                          (function($) {
                            'use strict';
                            jQuery(document).ready(function() {				
                                $('.rd-elementor-<?php echo esc_html($this->get_id());?>').reza_elementor();
        
                             });
                            })(jQuery);
                       </script>
            
                </div>
			<?php }?>	
	
    	</div>
   
		 <?php
		 } 
	
} 