<?php
 
class reza_element_image_list extends \Elementor\Widget_Base {

 
	public function get_name() {
		return 'bazinews_image_list';
	}

 
	public function get_title() {
		return __( 'Image List', 'reza' );
	}

 
	public function get_icon() {
		return 'reza-element-image-list';
	}
	public function get_categories() {
		return [ 'reza' ];
	}


protected function register_controls() {
  		$this->register_controls_general();
		$this->register_controls_layout();
		 
  		 
 $this->register_controls_post_style();
  $this->register_controls_typography(); 
 
		//hover animation
 		 //end style tab
	}
    


 
	 
	protected function register_controls_general(){
 		include REZA_PATH . '/elementor/image/elementor-image-general.php';  
 	}
	
	protected function register_controls_layout(){
 		include REZA_PATH  . '/elementor/image/elementor-image-layout.php';  
 	}
 
  

 	
	protected function register_controls_post_style(){
 		include REZA_PATH . '/elementor/image/elementor-image-style.php';  
 	}	
 
	
 
	protected function register_controls_typography(){
 		include  REZA_PATH . '/elementor/image/elementor-image-typography.php';  
 	}	  
	protected function render() {
		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			global $elementor_post_id;
			$elementor_post_id= $_GET['post'];
		}
 		$option = $this->get_settings_for_display();
 		$args=array();
		$key= $this->get_id();
		
 		$option['layout']='list';
		$layout =!empty($option['layout'])?$option['layout']:'list';
 		$between_class =!empty($option['between'])? $option['between']:reza_option('bazinews_blog_between');
  		$image_width =!empty($option['image_width'])? $option['image_width']:reza_option('bazinews_blog_image_width');
		$box_layout =!empty($option['box_layout'])? $option['box_layout']:'boxed-all';
	
		$list_layout =!empty($option['list_layout'])?$option['list_layout']:'list_4';
	
		if($list_layout=='list_5'){
 			$option['list_layout']='list_5c';
		}elseif($list_layout=='list_6'){
 			$option['list_layout']='list_6c';
		}
	
		$layout_class='';
		$layout_class ='rd_img_width_'.$image_width;
		$layout_class.= ' rd-'.$box_layout; 	
		 
		
		$classes = array(
			'rd-el-'.$key,
			'rd-el-image-list',
  			'rd-gap-'.$between_class,
			reza_between_border($option,$box_layout ),
			
  			$layout_class,
 
		); 
 	?>
	<div class="rd-elementor-<?php echo esc_attr($this->get_id());?>">      
	<aside <?php  reza_el_id($option);?> class="<?php echo esc_attr(join( ' ', $classes ));?> " >
	
			
		<div class="rd-gap-content">
		<div class="rd-gap-warp">
		<div class="rd-item-list rd-flex rd-aw <?php  echo esc_attr(reza_post_list_class($option));?>">
				
			<?php 
			if(!empty($option['item'])):
			foreach($option['item'] as $keys => $value):
					
				$thumbnail = !empty($value['image']['id'])? wp_get_attachment_image_src($value['image']['id'], 'full'):'';
				  	$post_thumbnail =!empty($thumbnail[0])?'':'rd-not-thumb';

				$the_permalink = !empty($value['url'])?$value['url']:'';
					
				?>
					<div class="rd-item rd-module-1 <?php echo esc_attr($post_thumbnail);?>">
					<div class="rd-post-blog" >
                                        
						<?php if(!empty($thumbnail[0])){ ?>
							<div class="rd-thumb"> 
								<a <?php if(!empty($the_permalink)){?>href="<?php echo esc_url($the_permalink) ?>"  <?php } ?> ><img src="<?php echo esc_url($thumbnail[0]); ?> "></a>
 							</div>
						<?php }?>   
                                          
                            <div class="rd-details">
                                <?php if(!empty($value['title'])){ ?>
                            	<h3 class="rd-title"><a <?php if(!empty($the_permalink)){?>href="<?php echo esc_url($the_permalink) ?>"  <?php } ?> ><?php echo esc_html($value['title']);?></a></h3>
								<?php }?>     
                                <?php if(!empty($value['content'])){ ?>
                            	<h3 class="rd-excerpt"><?php echo esc_html($value['content']);?></h3>
								<?php }?>  
                            </div>
 					</div>
					</div>
                    
				<?php 
				endforeach; 
				endif; 
				?>
					
		</div>
		</div> 
		</div> 
			
	</aside>   

	
	<?php
  
		
 		?>
  		 
			<?php if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {?>
                 <div class="rd-elementor-script">     
                        <script type="text/javascript">
                          (function($) {
                            'use strict';
                            jQuery(document).ready(function() {				
                                $('.rd-elementor-<?php echo esc_html($this->get_id());?>').reza_elementor();
        
                             });
                            })(jQuery);
                       </script>
            
                </div>
			<?php }?>	
	
    	</div>
   
		 <?php
 	}
	
} 
