<?php
 
class reza_element_content_form_7 extends \Elementor\Widget_Base {

 
	public function get_name() {
		return 'bazinews_contant_form_7';
	}

 
	public function get_title() {
		return __( 'Contant Form 7', 'reza' );
	}

 
	public function get_icon() {
		return 'reza-element-contant-form';
	}
	public function get_categories() {
		return [ 'reza' ];
	}


protected function register_controls() {
 		  
		$this->register_controls_general();
 	  	$this->register_controls_layout();
 	 	$this->register_controls_style();
 		$this->register_controls_typography(); 
  
	}
     
	protected function register_controls_general(){
			$this->start_controls_section(
				'general',
				[
					'label'			=> __( 'General', 'reza' ),
				]
			); 	
 
			$this->add_control(
				'contactform_id',
				[
					'label'			=>__('Contact Form','reza'),
					'type'			=> \Elementor\Controls_Manager::SELECT ,
					"options"		=> reza_category_array_options('contactform'),			
				]
			); 		 
			$this->end_controls_section();


	} 		 

	protected function register_controls_layout(){
			$this->start_controls_section(
				'layout_contact',
				[
					'label'			=> __( 'Layout', 'reza' ),
				]
			); 	
 
			$this->add_control(
				'height',
				[
					'label'			=>__('Field Height','reza'),
					'type'			=> \Elementor\Controls_Manager::NUMBER ,
					'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-input-ht: {{VALUE}}px',
					),			
  			
   				]
			); 	
			
			$this->add_control(
				'textarea_height',
				[
					'label'			=>__('Textarea Height','reza'),
					'type'			=> \Elementor\Controls_Manager::NUMBER ,
					'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-textarea-ht: {{VALUE}}px',
					),		
 
 				]
			); 	
 
			$this->add_control(
				'between',
				[
					'label'			=>__('Between Field','reza'),
					'type'			=> \Elementor\Controls_Manager::SELECT ,
					"options"		=>	reza_array_options('between',true)
							 
 				]
			); 	
  
		 
					 
			$this->end_controls_section();

	} 		 
  
 	
	protected function register_controls_style(){
 			
			
		$this->start_controls_section(
			'style',
			[
				'label'			=> __( 'Style', 'reza' ),
				'tab'			=> \Elementor\Controls_Manager::TAB_STYLE,
			]
		); 	
			
			
		$this->add_control(
			'text_color',
			[
				'label'			=>__('Text Color','reza'),
				'type'			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-main-lk: {{VALUE}}',
					),	
			]
		); 		
			
		$this->add_control(
			'field_background_color',
			[
				'label'			=>__('Field Background Color','reza'),
				'type'			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-form-bg: {{VALUE}}',
					),
				
			]
		); 			
	 
		$this->add_control(
			'field_text_color',
			[
				'label'			=>__('Field Text Color','reza'),
				'type'			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-form-txt: {{VALUE}}',
				),
			]
		); 			
	  
		$this->add_control(
			'field_border_color',
			[
				'label'			=>__('Field Border Color','reza'),
				'type'			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-main-br-cr: {{VALUE}}',
				),
			]
		); 
 							
		$this->add_control(
			'button_background_color',
			[
				'label'			=>__('Button Background Color','reza'),
				'type'			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-primary-bg: {{VALUE}}',
				),
			]
		); 
 		$this->add_control(
			'button_text_color',
			[
				'label'			=>__('Button Text Color','reza'),
				'type'			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-primary-txt: {{VALUE}}',
				),
			]
		);  
		
		
 		$this->add_control(
			'border_radius',
			[
				'label'			=>__('Border Radius','reza'),
				'type'			=> \Elementor\Controls_Manager::SELECT,
				"options"	=>  reza_array_options('radius',true),
				'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-btn-rd: {{VALUE}}',
					),
			]
		);  		
		
		
 		$this->add_control(
			'textarea_radius',
			[
				'label'			=>__('Textarea Border Radius' , 'reza'),
				'type'			=> \Elementor\Controls_Manager::SELECT,
				"options"		=>  reza_array_options('radius_mini',true),
				'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-main-rd: {{VALUE}}',
					),
			]
		);  	
		$this->end_controls_section();
  	

	} 		 
	 
	protected function register_controls_typography(){

		 $this->start_controls_section(
			'typography',
			[
				'label' => __('Typography','reza'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
						
			]
		);
		   
		$this->add_control(
			'text_font_size',
			[
				'label'			=>__('Font Size','reza'),
				'type'			=> \Elementor\Controls_Manager::NUMBER ,
				'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-form-fn-sz: {{VALUE}}px',
				),
				
			]
		); 
		
		$this->add_control(
			'text_font_weight',
			[
				'label'			=>__('Font Weight','reza'),
				'type'			=> \Elementor\Controls_Manager::SELECT ,
				'options'		=> reza_array_options('font_weight'),
				'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-form-fn-wt: {{VALUE}}',
					),
			]
		); 		
		
			$this->end_controls_section();
		
 	}	  
	protected function render() {
		
		
		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			global $elementor_post_id;
			$elementor_post_id= $_GET['post'];
		}
		
 		$option = $this->get_settings_for_display();
 
		
		
 		$args=array();
		$args['key']= $this->get_id();
  		$args['option'] = array(
		
			/*****************************************************************************************************************
			General
			******************************************************************************************************************/
				'contactform_id'					=> reza_settings($option,'contactform_id'),
				'height'							=>reza_settings($option,'height'),
				'textarea_height'					=> reza_settings($option,'textarea_height'),
				'between' 							=> reza_settings($option,'between'),
 
  			/*****************************************************************************************************************
			Style
			******************************************************************************************************************/
				'text_color' 						=> reza_settings($option,'text_color'),
				'field_background_color'			=>  reza_settings($option,'field_background_color'),
				'field_text_color'					=>  reza_settings($option,'field_text_color'),
				'field_border_color'				=> reza_settings($option,'field_border_color'),
				'button_color'			=> array(
					'background'					=> reza_settings($option,'button_background_color'),
					'text'							=> reza_settings($option,'button_text_color'),
				),
				'border_radius' 				=> reza_settings($option,'border_radius'),
				'textarea_radius'				=> reza_settings($option,'textarea_radius'),
 
			/*****************************************************************************************************************
			Typo
			******************************************************************************************************************/
   				'text_typo'					=> reza_elmentor_typo_css($option,'text'),
			
     	); 
 
		
		?>
   
 		 <div class="rd-elementor-<?php echo esc_attr($this->get_id());?>">      
  			
            
            <?php echo reza_contactform_config($args,true);?>
		  
  		 
			<?php if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {?>
                 <div class="rd-elementor-script">     
                        <script type="text/javascript">
                          (function($) {
                            'use strict';
                            jQuery(document).ready(function() {				
                                $('.rd-elementor-<?php echo esc_html($this->get_id());?>').reza_elementor();
        
                             });
                            })(jQuery);
                       </script>
            
                </div>
			<?php }?>	
	
    	</div>
   
		 <?php
		 } 
	
}
