<?php
 
class reza_element_comments extends \Elementor\Widget_Base {

 
	public function get_name() {
		return 'bazinews_comments';
	}

 
	public function get_title() {
		return __( 'Comments', 'reza' );
	}

 
	public function get_icon() {
		return 'reza-element-comments';
	}
	public function get_categories() {
		return [ 'reza' ];
	}


protected function register_controls() {
 		  
  	  	$this->register_controls_layout();
 	 	$this->register_controls_style();
 		$this->register_controls_typography(); 
  
	}
     
	 
	protected function register_controls_layout(){
			$this->start_controls_section(
				'layout_contact',
				[
					'label'			=> __( 'Layout', 'reza' ),
				]
			); 	
 
			$this->add_control(
				'comments_layout_type',
				[
					'label'			=>__('Comments Layout','reza'),
					'type'			=> \Elementor\Controls_Manager::SELECT,
					"options"		=>  array(
							"" 				=>  esc_html__('Default','reza'),
							'rd-thread' 	=> esc_html__('Thread' , 'reza'),
							'rd-list' 		=> esc_html__('List' , 'reza'),
					),	
				]
			); 	
					
			$this->add_control(
				'box_layout',
				[
					'label'			=>__('Box Layout','reza'),
					'type'			=> \Elementor\Controls_Manager::SELECT,
					"options"		=>  array(
						"" 				=>  esc_html__('Default','reza'),
						"none"			=> esc_html__('None','reza'),
						"boxed" 		=> esc_html__('Boxed','reza'),
					),	
				]
			);		
		 
			$this->add_control(
				'height',
				[
					'label'			=>__('Field Height','reza'),
					'type'			=> \Elementor\Controls_Manager::NUMBER ,
					'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-input-ht: {{VALUE}}px',
					),			
  			
   				]
			); 	
			
			$this->add_control(
				'textarea_height',
				[
					'label'			=>__('Textarea Height','reza'),
					'type'			=> \Elementor\Controls_Manager::NUMBER ,
					'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-textarea-ht: {{VALUE}}px',
					),		
 
 				]
			); 	
 
			 
  
		 
					 
			$this->end_controls_section();

	} 		 
  
 	
	protected function register_controls_style(){
 			
			
		$this->start_controls_section(
			'style',
			[
				'label'			=> __( 'Style', 'reza' ),
				'tab'			=> \Elementor\Controls_Manager::TAB_STYLE,
			]
		); 	
			
		 
			

		$this->add_control(
			'background_color',
			[
				'label'			=>__('Background Color','reza'),
				'type'			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-post-bg: {{VALUE}}',
					),	
			]
		); 		
		
		
		$this->add_control(
			'text_color',
			[
				'label'			=>__('Text Color','reza'),
				'type'			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-main-txt: {{VALUE}}',
					),	
			]
		); 				
		
		
		
		$this->add_control(
			'label_color',
			[
				'label'			=>__('Label Color','reza'),
				'type'			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-main-lk: {{VALUE}}',
					),	
			]
		); 				
		
 
			
		$this->add_control(
			'field_background_color',
			[
				'label'			=>__('Field Background Color','reza'),
				'type'			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-form-bg: {{VALUE}}',
					),
				
			]
		); 			
	 
		$this->add_control(
			'field_text_color',
			[
				'label'			=>__('Field Text Color','reza'),
				'type'			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-form-txt: {{VALUE}}',
				),
			]
		); 			
	 
 							
		$this->add_control(
			'button_background_color',
			[
				'label'			=>__('Button Background Color','reza'),
				'type'			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-primary-bg: {{VALUE}}',
				),
			]
		); 
 		$this->add_control(
			'button_text_color',
			[
				'label'			=>__('Button Text Color','reza'),
				'type'			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-primary-txt: {{VALUE}}',
				),
			]
		);  
		
 
		$this->add_control(
			'border_color',
			[
				'label'			=>__('Border Color','reza'),
				'type'			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-main-br-cr: {{VALUE}}',
				),
			]
		); 	
		
		$this->add_control(
			'box_border_color',
			[
				'label'			=>__('Box Shadow Color','reza'),
				'type'			=> \Elementor\Controls_Manager::COLOR,
				'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-post-sd: {{VALUE}}',
				),
			]
		); 	
				
		
 		$this->add_control(
			'border_radius',
			[
				'label'			=>__('Input and Button Border Radius','reza'),
				'type'			=> \Elementor\Controls_Manager::SELECT,
				"options"	=>  reza_array_options('radius',true),
				'selectors' 	=> array(
								'{{WRAPPER}} [class*="rd-el-"]' => '--rd-main-btn-rd: {{VALUE}}',
					),
			]
		);  		
		
		
 		$this->add_control(
			'textarea_radius',
			[
				'label'			=>__('Border Radius' , 'reza'),
				'type'			=> \Elementor\Controls_Manager::SELECT,
				"options"		=>  reza_array_options('radius_mini',true),
				'selectors' 	=> array(
						'{{WRAPPER}} [class*="rd-el-"]' => '--rd-main-rd: {{VALUE}}',
				),
			]
		);  	
		$this->end_controls_section();
  	

	} 		 
	 
	protected function register_controls_typography(){

		 $this->start_controls_section(
			'typography',
			[
				'label' => __('Typography','reza'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
						
			]
		);
		   
		 //*****************************************---------Title Typography------------------********************************************
		$this->add_control(
			'author_typo',
			[
				'label' 		=>__('Author Typography','reza'),
				'type' 			=> \Elementor\Controls_Manager::HEADING,
				'separator'		=> 'before',
			]
		);
		 
		 
		 
		$this->add_control(
			'author_font_size',
			[
				'label'			=>__('Font Size','reza'),
				'type'			=> \Elementor\Controls_Manager::NUMBER ,
				'selectors' 	=> array(
							'{{WRAPPER}} [class*="rd-el-"]' => '--rd-at-fn-sz: {{VALUE}}px',
					),	
			]
		);  
		$this->add_control(
			'author_font_weight',
			[
				'label'			=>__('Font Weight','reza'),
				'type'			=> \Elementor\Controls_Manager::SELECT ,
				'options'		=> reza_array_options('font_weight'),
				'selectors' 	=> array(
							'{{WRAPPER}} [class*="rd-el-"]' => '--rd-at-fn-wt: {{VALUE}}',
					),
				
			] 
		);
		
		
		//*****************************************---------Title Typography------------------********************************************
		$this->add_control(
			'comments_typo',
			[
				'label' 		=>__('Comments Typography','reza'),
				'type' 			=> \Elementor\Controls_Manager::HEADING,
				'separator'		=> 'before',
			]
		);
		 
		 
		 
		$this->add_control(
			'comments_font_size',
			[
				'label'			=>__('Font Size','reza'),
				'type'			=> \Elementor\Controls_Manager::NUMBER ,
				'selectors' 	=> array(
							'{{WRAPPER}} [class*="rd-el-"]' => '--rd-cm-fn-sz: {{VALUE}}px',
					),	
			]
		);  
		$this->add_control(
			'comments_font_weight',
			[
				'label'			=>__('Font Weight','reza'),
				'type'			=> \Elementor\Controls_Manager::SELECT ,
				'options'		=> reza_array_options('font_weight'),
				'selectors' 	=> array(
							'{{WRAPPER}} [class*="rd-el-"]' => '--rd-cm-fn-wt: {{VALUE}}',
					),
				
			] 
		);
		
		//*****************************************---------Title Typography------------------********************************************
		$this->add_control(
			'text_typo',
			[
				'label' 		=>__('Title Typography','reza'),
				'type' 			=> \Elementor\Controls_Manager::HEADING,
				'separator'		=> 'before',
			]
		);
		 
		 
		 
		$this->add_control(
			'text_font_size',
			[
				'label'			=>__('Font Size','reza'),
				'type'			=> \Elementor\Controls_Manager::NUMBER ,
				'selectors' 	=> array(
							'{{WRAPPER}} [class*="rd-el-"]' => '--rd-form-fn-sz: {{VALUE}}px',
					),	
			]
		);  
		$this->add_control(
			'text_font_weight',
			[
				'label'			=>__('Font Weight','reza'),
				'type'			=> \Elementor\Controls_Manager::SELECT ,
				'options'		=> reza_array_options('font_weight'),
				'selectors' 	=> array(
							'{{WRAPPER}} [class*="rd-el-"]' => '--rd-form-fn-wt: {{VALUE}}',
					),
				
			] 
		);
				
		
		
		
			$this->end_controls_section();
		
 	}	  
	protected function render() {
 		$option = $this->get_settings_for_display();
 		$args=array();
		$args['key']= $this->get_id();
		
		 
		
 		$args['option'] = array(
   			'comments_layout_type'				=> reza_settings($option,'comments_layout_type'),
  			'box_layout'						=> reza_settings($option,'box_layout'),
 
     	); 
		
		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			global $elementor_post_id;
			$elementor_post_id= $_GET['post'];
		}
		?>
   
 		 <div class="rd-elementor-<?php echo esc_attr($this->get_id());?>">      
  			
            
            <?php echo reza_comments_config($args,true);?>
		  
  		 
			<?php if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {?>
                 <div class="rd-elementor-script">     
                        <script type="text/javascript">
                          (function($) {
                            'use strict';
                            jQuery(document).ready(function() {				
                                $('.rd-elementor-<?php echo esc_html($this->get_id());?>').reza_elementor();
        
                             });
                            })(jQuery);
                       </script>
            
                </div>
			<?php }?>	
	
    	</div>
   
		 <?php
		 } 
	
}
  