<?php
 
class reza_element_blog_text extends \Elementor\Widget_Base {

 
	public function get_name() {
		return 'bazinews_blog_text';
	}

 
	public function get_title() {
		return esc_html__('Blog Text','reza');
	}

 
	public function get_icon() {
		return 'reza-element-blog-text';
	}
	public function get_categories() {
		return [ 'reza' ];
	}


	protected function register_controls() {
	 
		$this->register_controls_title_box();
 		$this->register_controls_general();
		$this->register_controls_layout();
 		$this->register_controls_title_box_style();
		$this->register_controls_post_style();
 		$this->register_controls_typography(); 
  
	}
    




	protected function register_controls_title_box(){
		
 		include  REZA_PATH . '/elementor/blog/elementor-blog-title-box.php';  
 	}
	 
	 
	protected function register_controls_general(){
		
		$excerpt =true;
		$meta =true;
		$meta_text =true;
		$more_page_posts=true;	
		$box_layout_text =true;
 		
	
 		include  REZA_PATH . '/elementor/blog/elementor-blog-general.php';  
 	}
	
	protected function register_controls_layout(){
		$excerpt =true;	
		$meta =true;
		$meta_text =true;
		$more_page_posts=true;	
		$box_layout_text =true;
 		
		$this->start_controls_section('layout_section',['label' => __( 'Layout', 'reza' ),]);
	 	
		$column=__('Column','reza');
		$layout=__('Layout','reza');
		$this->add_control(
			'text_layout',
			array(
				'label'			=> __('Layout','reza'),
				'type' 			=> \Elementor\Controls_Manager::SELECT,
				'default' 		=> 'text_1',
 				"options"		=> array(
				
						"text_1"		=> "1 $column", 
						"text_2"		=> "2 $column", 
						"text_3"		=> "3 $column", 
						"text_4"		=> "4 $column"
		 
						
				),
			)	 
		);
		
		$this->add_control(
			'responsive_column',
			[ 	
				"label"			=> __('Column in Tablet and Mobile','reza'),
				'type'			=> \Elementor\Controls_Manager::SELECT,
				"options" 		=> reza_array_options('responsive_column',true), 
		
				]
		);
							
		
 		include REZA_PATH . '/elementor/blog/elementor-blog-layout.php';  
 	}
 
 
	protected function register_controls_title_box_style(){
 		include REZA_PATH . '/elementor/general/elementor-title-box-style.php';  
 	}		

 	
	protected function register_controls_post_style(){
		
	 
		$box_layout_text =true;

 		include REZA_PATH . '/elementor/blog/elementor-blog-post-style.php';  
 	}	
	protected function register_controls_caption_style(){
	
		$image =true;	
		
 		include REZA_PATH . '/elementor/general/elementor-caption-style.php';  
 	}		
	
 
	protected function register_controls_typography(){
 		include  REZA_PATH . '/elementor/blog/elementor-blog-typography.php';  
 	}	  
	protected function render() {
		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			global $elementor_post_id;
			$elementor_post_id= $_GET['post'];
		}
		
		
		$option = $this->get_settings_for_display();
 		$args=array();
		$args['key']= $this->get_id();
		
		
 		$args['option'] = array(
		
			/*****************************************************************************************************************
			Title Box
			******************************************************************************************************************/
				'title'						=> reza_settings($option,'title'),
				'title_box_type'			=> reza_settings($option,'title_box_type'),
				'title_box_all'				=> reza_settings($option,'title_box_all'),
				'title_box_list_all' 		=> reza_settings($option,'title_box_list_all'),
				'tabs'						=> reza_settings($option,'tabs'),
			
			
			/*****************************************************************************************************************
			General
			******************************************************************************************************************/
				'number'					=> reza_settings($option,'number'),
				'multi_cats'				=> reza_multi_cats_array(reza_settings($option,'multi_cats')),
				'orderby'					=> reza_settings($option,'orderby'),
				'platforms'					=> reza_settings($option,'platforms'),
				'ignore_sticky_posts'		=> reza_settings($option,'ignore_sticky_posts'),
				'title_limit'				=> reza_settings($option,'title_limit'),
				'excerpt' 					=> reza_settings($option,'excerpt'),
				'excerpt_limit'				=> reza_settings($option,'excerpt_limit'),
				'meta'=> array(
					'meta_author'				=> 	reza_settings($option,'meta_author'),
					'meta_date'					=>	reza_settings($option,'meta_date'),
					'meta_view'					=>	reza_settings($option,'meta_view'),
					'meta_comments'				=>	reza_settings($option,'meta_comments'),
				),
				'readmore' 					=> reza_settings($option,'readmore'),
 				'more_posts' 				=> reza_settings($option,'more_posts'),
	 
 
			/*****************************************************************************************************************
			Layout
			******************************************************************************************************************/
 				'layout' 				=> reza_settings($option,'list_layout'),
 				'responsive_column'			=> reza_settings($option,'responsive_column'),
				'between' 					=> reza_settings($option,'between'),
				'alignment' 				=> reza_settings($option,'alignment'),
				'box_layout' 				=> reza_settings($option,'box_layout'),
 
			/*****************************************************************************************************************
			Title Box Style
			******************************************************************************************************************/

				'title_box_style' 			=> reza_settings($option,'title_box_style'),
				'title_box_color'		=> 	reza_settings($option,'title_box_color'),
 				'title_box_tab_color'		=>  reza_settings($option,'title_box_tab_text'),
 				'title_box_active_color'	=>  reza_settings($option,'title_box_active_text'),
 				'title_box_border_color' 		=> reza_settings($option,'title_box_border_color'),

 

 			/*****************************************************************************************************************
			Blog Style
			******************************************************************************************************************/
				'background_color' 			=> reza_settings($option,'background_color'),
 				'title_color'				=>  reza_settings($option,'title_color'),
				'excerpt_color'				=>  reza_settings($option,'excerpt_color'),
				'meta_color'				=>  reza_settings($option,'meta_color'),
 				'between_border' 				=> reza_settings($option,'between_border'),				
				'box_border_color' 				=> reza_settings($option,'box_border_color'),
				'radius' 					=> reza_settings($option,'radius'),
			
  		
				
  			/*****************************************************************************************************************
			Typo Grap
			******************************************************************************************************************/
				'title_box_main_typo'		=> reza_elmentor_typo_css($option,'title_box_main'),
				'title_box_tab_typo'		=> reza_elmentor_typo_css($option,'title_box_tab'),
				'post_title_typo'			=> reza_elmentor_typo_css($option,'post_title'),
				'excerpt_typo'				=> reza_elmentor_typo_css($option,'excerpt'),
				'meta_typo'					=> reza_elmentor_typo_css($option,'meta'),
 
   		); 
 
  	 ?>
  		 <div class="rd-elementor-<?php echo esc_attr($this->get_id());?>">      
  			
            
            <?php echo reza_blog_text_config($args,true);?>
		 
			<?php if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {?>
                 <div class="rd-elementor-script">     
                        <script type="text/javascript">
                          (function($) {
                            'use strict';
                            jQuery(document).ready(function() {				
                                $('.rd-elementor-<?php echo esc_html($this->get_id());?>').reza_elementor();
        
                             });
                            })(jQuery);
                       </script>
            
                </div>
			<?php }?>	
	
    	</div>
   
		 <?php
		 } 
	
} 