<?php
 
class reza_element_blog_featured extends \Elementor\Widget_Base {

 
	public function get_name() {
		return 'bazinews_blog_featured';
	}

 
	public function get_title() {
		return esc_html__('Blog Glider','reza');
	}

 
	public function get_icon() {
		return 'reza-element-blog-featured';
	}
	public function get_categories() {
		return [ 'reza' ];
	}


	protected function register_controls() {
	 
		$this->register_controls_title_box();
 		$this->register_controls_general();
		$this->register_controls_layout();
 		$this->register_controls_title_box_style();
		$this->register_controls_post_style();
  		$this->register_controls_typography(); 
  
	}
    




	protected function register_controls_title_box(){
		
 		include  REZA_PATH . '/elementor/blog/elementor-blog-title-box.php';  
 	}
	 
	 
	protected function register_controls_general(){
		
		$layout_2_fold=['featured_layout' => [
			'featured_9','featured_10','featured_11','featured_12','featured_13','featured_14','featured_15','featured_16','featured_17','featured_18','featured_19',
			'featured_20','featured_21','featured_22','featured_23','featured_24','featured_25','featured_26','featured_27','featured_28','featured_29','featured_30','featured_31','featured_32'
			]];	
		$title=true;	
		$excerpt=true;	
		$excerpt_2=true;	
		$meta=true;	
		$more_page_posts=true;
		$ratio =true;	
		$ratio_2 =true;	
		$image_size =true;	
		$image_size_2 =true;	
		$caption_layout =true;
		$image =true;
		$featured =true;
								
	
 		include  REZA_PATH . '/elementor/blog/elementor-blog-general.php';  
 	}
	
	protected function register_controls_layout(){
		$layout_2_fold=['featured_layout' => [
			'featured_9','featured_10','featured_11','featured_12','featured_13','featured_14','featured_15','featured_16','featured_17','featured_18','featured_19',
			'featured_20','featured_21','featured_22','featured_23','featured_24','featured_25','featured_26','featured_27','featured_28','featured_29','featured_30','featured_31','featured_32'
			]];	
			
			
		$title=true;	
		$excerpt=true;	
		$excerpt_2=true;	
		$meta=true;	
		$more_page_posts=true;
		$ratio =true;	
		$ratio_2 =true;	
		$image_size =true;	
		$image_size_2 =true;	
		$caption_layout =true;
		$image =true;
		$featured =true;
 

		$this->start_controls_section('layout_section',['label' => __( 'Layout', 'reza' ),]);
	 	
		$column=__('Column','reza');
		$layout=__('Layout','reza');
		$this->add_control(
			'featured_layout',
			[
				'label'			=> __('Glider Layout','reza'),
				'type'			=> \Elementor\Controls_Manager::SELECT,
				'default'		=> 'featured_1',
 				"options"		=> array(
						"featured_1"		=> "1 $column", 
						"featured_2"		=> "2 $column", 
						"featured_3"		=> "3 $column", 
						"featured_4"		=> "4 $column", 
						"featured_5"		=> "5 $column", 
						"featured_6"		=> "6 $column", 
						"featured_7"		=> "7 $column", 
						"featured_8"		=> "8 $column",
						"featured_9"		=> "$layout 9 ",
						"featured_10"		=> "$layout 10",
						"featured_11"		=> "$layout 11",
						"featured_12"		=> "$layout 12",
						"featured_13"		=> "$layout 13",
						"featured_14"		=> "$layout 14",
						"featured_15"		=> "$layout 15",
						"featured_16"		=> "$layout 16",
						"featured_17"		=> "$layout 17",
						"featured_18"		=> "$layout 18", 
						"featured_19"		=> "$layout 19",
						"featured_20"		=> "$layout 20",
						"featured_21"		=> "$layout 21",
						"featured_22"		=> "$layout 22",
						"featured_23"		=> "$layout 23",
						"featured_24"		=> "$layout 24",
						"featured_25"		=> "$layout 25",
						"featured_26"		=> "$layout 26",
						"featured_27"		=> "$layout 27",
						"featured_28"		=> "$layout 28",
						"featured_29"		=> "$layout 29",
						"featured_30"		=> "$layout 30",
						"featured_31"		=> "$layout 31",
						"featured_32"		=> "$layout 32",
					
				)
			]
		  );	
	
		
		$this->add_control(
			'responsive_column',
			[ 	
				"label"			=> __('Column in Tablet and Mobile','reza'),
				'type'			=> \Elementor\Controls_Manager::SELECT,
				"options" 		=> reza_array_options('first_responsive_column',true), 
		
				]
		);
							
		
 		include REZA_PATH . '/elementor/blog/elementor-blog-layout.php';  
 	}
 
 
	protected function register_controls_title_box_style(){
				$featured=true;			

 		include REZA_PATH . '/elementor/general/elementor-title-box-style.php';  
 	}		
	protected function register_controls_post_style(){
	 		
		$featured=true;			
 		include REZA_PATH . '/elementor/blog/elementor-blog-post-style.php';  
 	}	
 	
 
	protected function register_controls_typography(){
 		include  REZA_PATH . '/elementor/blog/elementor-blog-typography.php';  
 	}	  
	protected function render() {
		
		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			global $elementor_post_id;
			$elementor_post_id= $_GET['post'];
		}
			
		
		
 		$option = $this->get_settings_for_display();
 		$args=array();
		$args['key']= $this->get_id();
		
		
 		$args['option'] = array(
		
			/*****************************************************************************************************************
			Title Box
			******************************************************************************************************************/
				'title'						=> reza_settings($option,'title'),
				'title_box_type'			=> reza_settings($option,'title_box_type'),
				'title_box_all'				=> reza_settings($option,'title_box_all'),
				'title_box_list_all' 		=> reza_settings($option,'title_box_list_all'),
				'tabs'						=> reza_settings($option,'tabs'),
			
			
			/*****************************************************************************************************************
			General
			******************************************************************************************************************/
				'number'					=> reza_settings($option,'number'),
				'multi_cats'				=> reza_multi_cats_array(reza_settings($option,'multi_cats')),
				'orderby'					=> reza_settings($option,'orderby'),
				'platforms'					=> reza_settings($option,'platforms'),
				'ignore_sticky_posts'		=> reza_settings($option,'ignore_sticky_posts'),
				'title_limit'				=> reza_settings($option,'title_limit'),
				'post_title'				=> reza_settings($option,'post_title'),
				'excerpt' 					=> reza_settings($option,'excerpt'),
				'excerpt_2' 					=> reza_settings($option,'excerpt_2'),
				'excerpt_limit'				=> reza_settings($option,'excerpt_limit'),
				 'meta_category'				=>	reza_settings($option,'meta_category'),
				'meta'=> array(
					'meta_author'				=> 	reza_settings($option,'meta_author'),
 					'meta_date'					=>	reza_settings($option,'meta_date'),
					'meta_view'					=>	reza_settings($option,'meta_view'),
					'meta_comments'				=>	reza_settings($option,'meta_comments'),
				),
				'readmore' 					=> reza_settings($option,'readmore'),
				'hover_post_icon'			=> reza_settings($option,'hover_post_icon'),
				'more_posts' 				=> reza_settings($option,'more_posts'),
	 
 
			/*****************************************************************************************************************
			Layout
			******************************************************************************************************************/
				'layout' 				=> reza_settings($option,'featured_layout'),
 				'responsive_column'			=> reza_settings($option,'responsive_column'),
				'between' 					=> reza_settings($option,'between'),
				'ratio' 					=> reza_settings($option,'ratio'),
				'ratio_2' 					=> reza_settings($option,'ratio_2'),
				'image_width'				=> reza_settings($option,'image_width'),
				'image_width_2'				=> reza_settings($option,'image_width_2'),
				'thumb'						=> reza_settings($option,'thumb'),
				'thumb_2'					=> reza_settings($option,'thumb_2'),
				'alignment' 				=> reza_settings($option,'alignment'),
				'box_layout' 				=> reza_settings($option,'box_layout'),
				'vertical' 					=> reza_settings($option,'vertical'),
 
	  
			/*****************************************************************************************************************
			Title Box Style
			******************************************************************************************************************/
				'title_box_style' 			=> reza_settings($option,'title_box_style'),
				'title_box_color'		=> 	reza_settings($option,'title_box_color'),
 				'title_box_tab_color'		=>  reza_settings($option,'title_box_tab_text'),
 				'title_box_active_color'	=>  reza_settings($option,'title_box_active_text'),
 				'title_box_border_color' 		=> reza_settings($option,'title_box_border_color'),
 			/*****************************************************************************************************************
			Blog Style
			******************************************************************************************************************/
		 
				'radius' 					=> reza_settings($option,'radius'),
			
   			/*****************************************************************************************************************
			Typo Grap
			******************************************************************************************************************/
				'title_box_main_typo'		=> reza_elmentor_typo_css($option,'title_box_main'),
				'title_box_tab_typo'		=> reza_elmentor_typo_css($option,'title_box_tab'),
				'post_title_typo'			=> reza_elmentor_typo_css($option,'post_title'),
				'excerpt_typo'				=> reza_elmentor_typo_css($option,'excerpt'),
				'meta_typo'					=> reza_elmentor_typo_css($option,'meta'),
 
   		); 
  	 ?>
  		 <div class="rd-elementor-<?php echo esc_attr($this->get_id());?>">      
  			
            
            <?php echo reza_blog_featured_config($args,true);?>
		 
			<?php if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {?>
                 <div class="rd-elementor-script">     
                        <script type="text/javascript">
                          (function($) {
                            'use strict';
                            jQuery(document).ready(function() {				
                                $('.rd-elementor-<?php echo esc_html($this->get_id());?>').reza_elementor();
        
                             });
                            })(jQuery);
                       </script>
            
                </div>
			<?php }?>	
	       	<?php if(reza_settings($option,'elementor_padding')){?>
                <style>	.elementor-section .elementor-element-<?php echo $this->get_id();?> .elementor-widget-container  {padding:<?php echo reza_settings($option,'elementor_padding');?>;}</style>
 		 		<?php }?>
	
    	</div>
   
		 <?php
		 } 
	
} 