<?php
 
class reza_element_blog_carousel extends \Elementor\Widget_Base {

 
	public function get_name() {
		return 'reza_blog_carousel';
	}

 
	public function get_title() {
		return __( 'Blog Carousel', 'reza' );
	}

 
	public function get_icon() {
		return 'reza-element-blog-carousel';
	}
	public function get_categories() {
		return [ 'reza' ];
	}


	protected function register_controls() {
		$this->register_controls_title_box();
		$this->register_controls_general();
		$this->register_controls_slider();
		$this->register_controls_layout();
 		$this->register_controls_title_box_style();
		$this->register_controls_post_style();
		$this->register_controls_slider_style();
  		$this->register_controls_typography(); 
	}
    




	protected function register_controls_title_box(){
 		include  REZA_PATH . '/elementor/blog/elementor-blog-title-box.php';  
 	}
	 
	 
	protected function register_controls_general(){
		$title =true;	
		$title_layout=['layout' => 'featured'];
 		$excerpt =true;	
		$ratio =true;	
		$image_size =true;
		$meta =true;	
		$alignment =true;
		$box_layout =true;
		$caption_layout =true;
		$image =true;	
 		include  REZA_PATH . '/elementor/blog/elementor-blog-general.php';  
 	}
	protected function register_controls_slider(){
 		include REZA_PATH . '/elementor/general/elementor-slider.php';  
 	}
	protected function register_controls_layout(){
		
	 
		$title =true;	
		$excerpt =true;	
		$ratio =true;	
		$image_size =true;
		$meta =true;	
		$alignment =true;
		$box_layout =true;
		$caption_layout =true;
		$image =true;
			
		
		$this->start_controls_section('layout_section',['label' => __( 'Layout', 'reza' ),]);
 
 		$this->add_control(
			'layout',
			[
				'label'			=> __('Layout','reza'),
				'type'			=> \Elementor\Controls_Manager::SELECT,
				'default'		=> 'grid',
				"options"		=> array(
				
						"list"			=> __('List','reza'),
						"grid"			=>  __('Grid','reza'), 
						"featured"		=> __('Glider','reza'), 
						
				),
			]	 
		);
		$column=__('Column','reza');
		
		$this->add_control(
			'column',
			[
				'label' => __('Column Layout','reza'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '3',
				"options"		=> [
				
					"1"	=> "1 $column", 
					"2"	=> "2 $column", 
					"3"	=> "3 $column", 
					"4"	=> "4 $column",  
					"5"	=> "5 $column", 
					"6"	=> "6 $column", 
					"7"	=> "7 $column", 
					"8"	=> "8 $column", 
						
					],
			]	 
		);	  
  
		$this->add_control(
			'responsive_column',
			[
				'label'			=> __('Column Width in Tablet and Mobile','reza'),
				'type'			=> \Elementor\Controls_Manager::SELECT,
				"options"		=> array(
				
						''				=>	esc_html__('Default','reza'),
						"150"			=> '150px',
						"200"			=> '200px',
						"250"			=> '250px',
						"300"			=> '300px',
						"350"			=> '350px',
						"400"			=> '400px',
						),
			]	 
		);	  
		  
		
		
 		include REZA_PATH . '/elementor/blog/elementor-blog-layout.php';  
 	}
	
  
	protected function register_controls_title_box_style(){
 		include REZA_PATH . '/elementor/general/elementor-title-box-style.php';  
 	}		

 	
	protected function register_controls_post_style(){
		$box_layout =true;
 		include REZA_PATH . '/elementor/blog/elementor-blog-post-style.php';  
 	}	
 
	protected function register_controls_slider_style(){
 		include REZA_PATH . '/elementor/general/elementor-slider-style.php';  
 	}	 
 
	protected function register_controls_typography(){
 		include  REZA_PATH . '/elementor/blog/elementor-blog-typography.php';  
 	}	  
	
	
	
	
	
	protected function render() {
		
		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			global $elementor_post_id;
			$elementor_post_id= $_GET['post'];
		}
		
		
		
 		$option = $this->get_settings_for_display();
 		$args=array();
		$args['key']= $this->get_id();
		
		
 		$args['option'] = array(
		
			/*****************************************************************************************************************
			Title Box
			******************************************************************************************************************/
				'title'						=> reza_settings($option,'title'),
				'title_box_type'			=> reza_settings($option,'title_box_type'),
				'title_box_all'				=> reza_settings($option,'title_box_all'),
				'title_box_list_all' 		=> reza_settings($option,'title_box_list_all'),
				'tabs'						=> reza_settings($option,'tabs'),
			
			
			/*****************************************************************************************************************
			General
			******************************************************************************************************************/
				'number'					=> reza_settings($option,'number'),
				'multi_cats'				=> reza_multi_cats_array(reza_settings($option,'multi_cats')),
				'orderby'					=> reza_settings($option,'orderby'),
				'platforms'					=> reza_settings($option,'platforms'),
				'ignore_sticky_posts'		=> reza_settings($option,'ignore_sticky_posts'),
				'post_title'				=> reza_settings($option,'post_title'),
				'title_limit'				=> reza_settings($option,'title_limit'),
				'excerpt' 					=> reza_settings($option,'excerpt'),
				'excerpt_limit'				=> reza_settings($option,'excerpt_limit'),
			 	'meta_category'				=>	reza_settings($option,'meta_category'),
				'meta'=> array(
					'meta_author'				=> 	reza_settings($option,'meta_author'),
 					'meta_date'					=>	reza_settings($option,'meta_date'),
					'meta_view'					=>	reza_settings($option,'meta_view'),
					'meta_comments'				=>	reza_settings($option,'meta_comments'),
				),
				'readmore' 					=> reza_settings($option,'readmore'),
				'hover_post_icon'			=> reza_settings($option,'hover_post_icon'),
 			
			
			/*****************************************************************************************************************
			Slider
			******************************************************************************************************************/
				'pager'						=>  reza_settings($option,'pager'),
				'arrows' 					=> reza_settings($option,'arrows'),
				'arrow_layout'				=> array(
					'location'					=>	reza_settings($option,'arrow_location'),
					'layout'					=>	reza_settings($option,'arrow_layout'),
					'size'						=>	reza_settings($option,'arrow_size'),
				),
				'auto' 						=> reza_settings($option,'auto'),
				'speed' 					=> reza_settings($option,'speed'),
				'pause' 					=> reza_settings($option,'pause'),
 
 
			/*****************************************************************************************************************
			Layout
			******************************************************************************************************************/
				'layout' 					=> reza_settings($option,'layout'),
				'column' 					=> reza_settings($option,'column'),
				'responsive_column' 		=> reza_settings($option,'responsive_column'),
				'between' 					=> reza_settings($option,'between'),
				'ratio' 					=> reza_settings($option,'ratio'),
				'image_width'				=> reza_settings($option,'image_width'),
				'thumb'						=> reza_settings($option,'thumb'),
				'alignment' 				=> reza_settings($option,'alignment'),
				'vertical' 				=> reza_settings($option,'vertical'),
				'box_layout' 				=> reza_settings($option,'box_layout'),
 
			/*****************************************************************************************************************
			Title Box Style
			******************************************************************************************************************/
				'title_box_style' 			=> reza_settings($option,'title_box_style'),
				'title_box_color'		=> 	reza_settings($option,'title_box_color'),
 				'title_box_tab_color'		=>  reza_settings($option,'title_box_tab_text'),
 				'title_box_active_color'	=>  reza_settings($option,'title_box_active_text'),
 				'title_box_border_color' 		=> reza_settings($option,'title_box_border_color'),
 			 
			/*****************************************************************************************************************
			Blog Style
			******************************************************************************************************************/
				'background_color' 			=> reza_settings($option,'background_color'),
				'title_color'				=>  reza_settings($option,'title_color'),
 				'excerpt_color'				=>  reza_settings($option,'excerpt_color'),
				'meta_color'				=>  reza_settings($option,'meta_color'),
 				'between_border' 				=> reza_settings($option,'between_border'),
				'box_border_color' 				=> reza_settings($option,'box_border_color'),
				'radius' 					=> reza_settings($option,'radius'),
			/*****************************************************************************************************************
			Slider Style
			******************************************************************************************************************/
				'arrow_color'		=> array(
					'background'				=>	reza_settings($option,'arrow_background_color'),
					'text'						=>	reza_settings($option,'arrow_text_color')
				),
 	
	 
  			/*****************************************************************************************************************
			Typo Grap
			******************************************************************************************************************/
				'title_box_main_typo'		=> reza_elmentor_typo_css($option,'title_box_main'),
				'title_box_tab_typo'		=> reza_elmentor_typo_css($option,'title_box_tab'),
				'post_title_typo'			=> reza_elmentor_typo_css($option,'post_title'),
				'excerpt_typo'				=> reza_elmentor_typo_css($option,'excerpt'),
				'meta_typo'					=> reza_elmentor_typo_css($option,'meta'),	
				
  
   		); ?>
  
  		 <div class="rd-elementor-<?php echo esc_attr($this->get_id());?>">      
  			
			<?php echo reza_blog_carousel_config($args,true);?>
		  
  			<?php if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {?>
            
                 <div class="rd-elementor-script">    
					<script src='<?php echo  REZA_DIR . '/js/lib/lightslider.min.js'?>' id='sao_lightslider_script-js'></script>    
 
                        <script type="text/javascript">
                          (function($) {
                            'use strict';
                            jQuery(document).ready(function() {				
                                $('.rd-elementor-<?php echo esc_html($this->get_id());?>').reza_elementor();
        
                             });
                            })(jQuery);
                       </script>
            
                </div>
			<?php }?>	
            	 
		</div>	 
 	<?php
	}
	
}
  