<?php
/**
 * The template for displaying Comments
 *
 * The area of the page that contains comments and the comment form.
 *
 * @package WordPress
 * @subpackage Twenty_Thirteen
 * @since Twenty Thirteen 1.0
 */

/*
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */
global  $smof_data;
if( reza_option('bazinews_hide_comments') !== 'hide' ){
$reza_comments_layout_type = isset( $smof_data['bazinews_comments_layout_type']) ? $smof_data['bazinews_comments_layout_type'] : 'rd-list';

if ($reza_comments_layout_type =='rd-thread'){
	$reza_comments_type = 'rd-thread';
	
 } else {
	$reza_comments_type = 'rd-list';
}
 
 $box_layout_single = reza_box_layout_single('blog');
 
   
   	?>
 
 	
	<?php
 
if ( post_password_required() )
	return;
   
     
	$get_post = get_post( get_the_ID() );
	$comment_status= !empty($get_post->comment_status)? $get_post->comment_status :'';
 ?>
  
  	<?php 
 	if($box_layout_single!=='rd-single-boxed' && $comment_status!=='closed' ){ ?>
  		<div class="rd-el-line "></div>
	<?php }?> 
    
    
	<aside class="rd-el-comments rd-comments  <?php echo esc_attr($box_layout_single);?>  <?php echo 'rd-comment-status-'.esc_attr($comment_status);?>  <?php echo esc_attr($reza_comments_type) ?> rd-aw <?php if ( have_comments() ) echo esc_attr('rd-have-comments');?>">
 	<div id="comments" class="comments-area   ">

	<?php if ( have_comments() ) { ?>
		<h2 class="comments-title">
	 	<span><?php comments_number(esc_html(reza_t('nocommentsyet')), reza_t('1').' '.reza_t('commentalready') , esc_html('% '.reza_t('commentsalready'))); ?></span>

		</h2>

		<ol class="comment-list <?php  echo esc_attr($reza_comments_layout_type)?>">
 			  <?php wp_list_comments( array( 'callback' => 'reza_custom_comments', 'short_ping'  => true ) ); ?>
		</ol><!-- .comment-list -->

		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) {?>
		<nav class="rd-comment-navi">
			<?php  paginate_comments_links(); ?> 
		</nav><!-- .comment-navigation -->
		<?php } ?>

		<?php if ( ! comments_open() && get_comments_number() ){ ?>
		<p class="no-comments"><?php echo esc_html( reza_t('commentsclosed')); ?></p>
		<?php }?>

	<?php  } ?>

	<?php comment_form(); ?>

 	</div>
	</aside>
<?php  


if( is_singular() && comments_open() && ( get_option( 'thread_comments' ) == 1) ) {
        wp_enqueue_script( 'comment-reply', 'wp-includes/js/comment-reply', array(), false, true );
}
}
?>