<?php
// افزودن قسمت تنظیمات برای آپلود آواتار کاربر
function custom_avatar_settings( $profileuser ) {
    if ( current_user_can( 'upload_files' ) ) { ?>
        <h3><?php _e( 'تصویر پروفایل', 'text-domain' ); ?></h3>
        <table class="form-table">
            <tr>
                <th><label for="avatar"><?php _e( 'انتخاب آواتار', 'text-domain' ); ?></label></th>
                <td>
                    <input type="file" id="avatar" name="avatar" />
                    <p class="description"><?php _e( 'لطفاً یک تصویر پروفایل انتخاب کنید.', 'text-domain' ); ?></p>
                </td>
            </tr>
        </table>
    <?php }
}
add_action( 'show_user_profile', 'custom_avatar_settings' );
add_action( 'edit_user_profile', 'custom_avatar_settings' );

// ذخیره آواتار کاربر در پروفایل کاربری
function save_custom_avatar( $user_id ) {
    if ( current_user_can( 'edit_user', $user_id ) && isset( $_FILES['avatar'] ) ) {
        // فایل آپلود شده را بررسی می‌کنیم
        $file_data = wp_handle_upload( $_FILES['avatar'], array( 'test_form' => false ) );

        if ( ! empty( $file_data ) && ! isset( $file_data['error'] ) ) {
            // آدرس فایل آپلود شده را در پروفایل کاربری ذخیره می‌کنیم
            update_user_meta( $user_id, 'avatar', $file_data['url'] );
        }
    }
}
add_action( 'personal_options_update', 'save_custom_avatar' );
add_action( 'edit_user_profile_update', 'save_custom_avatar' );

// نمایش آواتار در صفحه نمایه کاربری
function display_custom_avatar( $user ) {
    $avatar_url = get_user_meta( $user->ID, 'avatar', true );
    if ( $avatar_url ) {
        ?>
        <h3><?php _e( 'آواتار', 'text-domain' ); ?></h3>
        <img src="<?php echo esc_url( $avatar_url ); ?>" alt="<?php echo esc_attr( $user->display_name ); ?>" width="100" height="100" />
        <?php
    }
}
add_action( 'show_user_profile', 'display_custom_avatar' );
add_action( 'edit_user_profile', 'display_custom_avatar' );