<?php


/*****************************************************************************************************************************************************
******************************************************************************************************************************************************

															post Display thumbnail column

*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function reza_game_post_type() {
	$labels = array(
		'name' 					=> __('Games','reza'),
		'singular_name'			=> __('Game','reza'),
		'add_new'				=> __('Add New','reza'),
		'add_new_item'			=>__('Add New Game','reza'),
		'edit_item'				=> __('Edit Game','reza'),
		'new_item'				=> __('New Game','reza'),
		'view_item'				=> __('View Game','reza'),
 		'all_items'				=>__('All Games','reza'),
 		'search_items'			=> __('Search Games','reza'),
		'not_found'				=>  __('No Game found','reza'),
		'not_found_in_trash'	=>__('No Game found in trash','reza'),
		'parent_item_colon'		=> '',
		'menu_name'				=> __('Games','reza')
	);
	
	$args = array(
		'labels'				=> $labels,
		'public'				=> true,
		'publicly_queryable'	=> true,
		'show_ui'				=> true, 
		'show_in_menu'			=> true, 
		'query_var'				=> true,
		'rewrite'				=> true,
		'capability_type'		=> 'post',
		'has_archive'			=> true, 
		'hierarchical'			=> false,
		'menu_position'			=> null,
		'supports' => array( 'title', 'thumbnail' ,'editor')
	); 

	register_post_type( 'game', $args );
}
add_action( 'init', 'reza_game_post_type' );




/*********************************************************************************************
category
*********************************************************************************************///
add_action( 'init', 'reza_game_categories_taxonomy',1  );
function reza_game_categories_taxonomy() {
 
   $labels = array(
    'name'							=> __( 'Categories','reza' ),
    'singular_name'					=> __( 'Category','reza'  ),
    'search_items'					=> __( 'Search Categories' ,'reza' ),
    'popular_items'					=> __( 'Popular Categories','reza'  ),
    'all_items' 					=> __( 'All Categories' ,'reza' ),
    'parent_item'					=> __( 'Parent Category' ,'reza' ),
    'edit_item'						=> __( 'Edit Topic','reza' ), 
    'update_item' 					=> __( 'Update Category','reza'  ),
    'add_new_item'					=> __( 'Add New Category','reza'  ),
    'new_item_name'			 		=> __( 'New Topic Name' ,'reza' ),
    'separate_items_with_commas'	=> __( 'Separate Categories with commas' ,'reza' ),
    'add_or_remove_items'			=> __( 'Add or remove Categories','reza'  ),
    'choose_from_most_used' 		=> __( 'Choose from the most used Categories','reza'  ),
    'menu_name' 					=> __( 'Categories' ,'reza' ),
  ); 


// Now register the taxonomy

  register_taxonomy('game_category','game', array(
    'hierarchical' 					=> true,
    'labels' 						=> $labels,
    'show_ui' 						=> true,
    'show_admin_column'				=> true,
    'query_var'						=> true,
    'rewrite' 						=> array( 'slug' => 'game_category' ),
  ));

}
add_action('manage_sao_game_posts_custom_column', 'reza_display_thumbnails_column', 5, 2);


/*********************************************************************************************
Developer
*********************************************************************************************///
add_action( 'init', 'reza_game_developer_taxonomies',1 );
function reza_game_developer_taxonomies() 
{
  // Add new taxonomy, NOT hierarchical (like Developers)
  $labels = array(
    'name' => __( 'Developers','reza'),
    'singular_name' => __( 'Developer','reza'),
    'search_items' =>  __( 'Search Developers','reza'),
    'popular_items' => __( 'Popular Developers','reza'),
    'all_items' => __( 'All Developers','reza'),
    'parent_item' => null,
    'parent_item_colon' => null,
    'edit_item' => __( 'Edit Developer' ,'reza'),
    'update_item' => __( 'Update Developer','reza'),
    'add_new_item' => __( 'Add New Developer','reza'),
    'new_item_name' => __( 'New Developer Name','reza'),
    'separate_items_with_commas' => __( 'Separate Developers with commas' ,'reza'),
    'add_or_remove_items' => __( 'Add or remove Developers' ,'reza'),
    'choose_from_most_used' => __( 'Choose from the most used Developers','reza'),
    'menu_name' => __( 'Developers','reza'),

  ); 

  register_taxonomy('developer','game',array(
    'hierarchical' => false,
    'labels' => $labels,
    'show_ui' => true,
    'update_count_callback' => '_update_post_term_count',
'capabilities' => array(
		   'manage_terms' => 'edit_posts', 
			'edit_terms' => 'edit_posts',
			'delete_terms' => 'edit_posts',
			'assign_terms' => 'edit_posts'  
		),
    'query_var' => true,
    'rewrite' => array( 'slug' => 'developer' ),
  ));
}
 


/*********************************************************************************************
publisher
*********************************************************************************************///
 add_action( 'init', 'reza_game_publisher_taxonomies',1  );
function reza_game_publisher_taxonomies() 
{
	  $labels = array(
		'name' => __( 'Publishers','reza'),
		'singular_name' => __( 'Publisher','reza'),
		'search_items' =>  __( 'Search Publishers' ,'reza'),
		'popular_items' => __( 'Popular Publishers','reza'),
		'all_items' => __( 'All Publishers','reza'),
		'parent_item' => null,
		'parent_item_colon' => null,
		'edit_item' => __( 'Edit Publisher','reza'),
		'update_item' => __( 'Update Publisher' ,'reza'),
		'add_new_item' => __( 'Add New Publisher' ,'reza'),
		'new_item_name' => __( 'New Publisher Name' ,'reza'),
		'separate_items_with_commas' => __( 'Separate Publishers with commas','reza'),
		'add_or_remove_items' => __( 'Add or remove Publishers','reza'),
		'choose_from_most_used' => __( 'Choose from the most used Publishers','reza'),
		'menu_name' => __( 'Publishers','reza'),
	  ); 
	
	  register_taxonomy('publisher','game',array(
		'hierarchical' => false,
		'labels' => $labels,
		'show_ui' => true,
		'update_count_callback' => '_update_post_term_count',
		'capabilities' => array(
		   'manage_terms' => 'edit_posts', 
			'edit_terms' => 'edit_posts',
			'delete_terms' => 'edit_posts',
			'assign_terms' => 'edit_posts'  
		),
		'query_var' => true,
		'rewrite' => array( 'slug' => 'publisher' ),
	  ));
}
/*********************************************************************************************
genre
*********************************************************************************************///
add_action( 'init', 'reza_game_genre_taxonomy',1  );
function reza_game_genre_taxonomy() {
 
   $labels = array(
    'name'							=> __( 'Genres','reza' ),
    'singular_name'					=> __( 'Genre','reza'  ),
    'search_items'					=> __( 'Search Genres' ,'reza' ),
    'popular_items'					=> __( 'Popular Genres','reza'  ),
    'all_items' 					=> __( 'All Genres' ,'reza' ),
    'parent_item'					=> __( 'Parent Genre' ,'reza' ),
    'edit_item'						=> __( 'Edit Topic','reza' ), 
    'update_item' 					=> __( 'Update Genre','reza'  ),
    'add_new_item'					=> __( 'Add New Genre','reza'  ),
    'new_item_name'			 		=> __( 'New Topic Name' ,'reza' ),
    'separate_items_with_commas'	=> __( 'Separate Genres with commas' ,'reza' ),
    'add_or_remove_items'			=> __( 'Add or remove Genres','reza'  ),
    'choose_from_most_used' 		=> __( 'Choose from the most used Genres','reza'  ),
    'menu_name' 					=> __( 'Genres' ,'reza' ),
  ); 


// Now register the taxonomy

  register_taxonomy('genre','game', array(
    'hierarchical' 					=> true,
    'labels' 						=> $labels,
    'show_ui' 						=> true,
    'show_admin_column'				=> true,
    'query_var'						=> true,
    'rewrite' 						=> array( 'slug' => 'genre' ),
  ));

}

/*********************************************************************************************
Platform
*********************************************************************************************///
add_action( 'init', 'reza_game_platform_taxonomy' ,1 );
function reza_game_platform_taxonomy() {
 
   $labels = array(
    'name'							=> __( 'Platforms','reza' ),
    'singular_name'					=> __( 'Platform','reza'  ),
    'search_items'					=> __( 'Search Platforms' ,'reza' ),
    'popular_items'					=> __( 'Popular Platforms','reza'  ),
    'all_items' 					=> __( 'All Platforms' ,'reza' ),
    'parent_item'					=> __( 'Parent Platform' ,'reza' ),
    'edit_item'						=> __( 'Edit Topic','reza' ), 
    'update_item' 					=> __( 'Update Platform','reza'  ),
    'add_new_item'					=> __( 'Add New Platform','reza'  ),
    'new_item_name'			 		=> __( 'New Topic Name' ,'reza' ),
    'separate_items_with_commas'	=> __( 'Separate Platforms with commas' ,'reza' ),
    'add_or_remove_items'			=> __( 'Add or remove Platforms','reza'  ),
    'choose_from_most_used' 		=> __( 'Choose from the most used Platforms','reza'  ),
    'menu_name' 					=> __( 'Platforms' ,'reza' ),
  ); 


// Now register the taxonomy

  register_taxonomy('platform',array( 'game','post' ), array(
    'hierarchical' 					=> true,
    'labels' 						=> $labels,
    'show_ui' 						=> true,
    'show_admin_column'				=> true,
    'query_var'						=> true,
    'rewrite' 						=> array( 'slug' => 'platform' ),
  ));
 

}
 

 

function reza_get_game_platforms() {
$terms = get_terms("platforms");
 foreach ( $terms as $term ) { echo $term->name; } 
}
 

add_filter('manage_game_posts_columns', 'reza_game_add_thumbnail_column',1);
function reza_game_add_thumbnail_column($columns){
   $columns['new_post_thumb'] = __('Featured Image','reza');
  return $columns;
} 


add_action('manage_game_posts_custom_column', 'reza_game_display_thumbnail_column', 1, 2);
function reza_game_display_thumbnail_column($column_name, $post_id){
  switch($column_name){
    case 'new_post_thumb':
      $post_thumbnail_id =  get_post_thumbnail_id($post_id);
		$thumbnail = !empty($post_thumbnail_id)? wp_get_attachment_image_src($post_thumbnail_id, 'thumbnail'):'';

       if (!empty($thumbnail[0])) {
         echo '<img width="100" src="' . esc_url($thumbnail[0]) . '" />';
      }
      break;
  }
}