<?php
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
														 			Page Metabox
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
add_action( 'add_meta_boxes', 'reza_page_metabox' );
function reza_page_metabox($post){
      add_meta_box('reza_page_general_metabox',esc_html__('General Options','reza'), 'reza_page_general_metabox', 'page', 'normal' , 'high');
}
/*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
														 			Page General Metabox
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function reza_page_general_metabox($post){
	global $post;
	wp_nonce_field( basename(__FILE__), 'reza_page_meta_nonce' );
 	
	   $custom = get_post_custom($post->ID);
	$sidebars  = reza_category_array_options('sidebars');
 
   	$full_width_value = get_post_meta($post->ID, 'bazinews_full_width', true);
     if($full_width_value == "yes"){ $full_width_checked = 'checked="checked"';}else{$full_width_checked='';} 

    $hide_banner_below = get_post_meta($post->ID, 'bazinews_hide_banner_below', true);
    $hide_comments = get_post_meta($post->ID, 'bazinews_hide_comments', true);
    $primary_color = get_post_meta($post->ID, 'bazinews_primary_color', true);
 	$primary_color_1 = !empty($primary_color['color'] )?$primary_color['color']:'';
	$primary_color_2 = !empty($primary_color['text'] )?$primary_color['text']:'';
	
    $body_background_color = get_post_meta($post->ID, 'bazinews_body_bg_color', true);
    $body_background_type = get_post_meta($post->ID, 'bazinews_body_background_type', true);
    $body_background_image = get_post_meta($post->ID, 'bazinews_body_background_image', true);
    $body_background_image_medium = get_post_meta($post->ID, 'bazinews_body_background_image_medium', true);
    $body_background_pattern = get_post_meta($post->ID, 'bazinews_body_background_pattern', true);
	?>
	 
	<table class="form-table meta_box">     
		<tbody>
           
 
       <tr class="meta_bazinews_full_width bazinews_meta_radio">
                <th ><label for="bazinews_full_width"><?php echo esc_html__('Full Width Post','reza');?></label></th>
                <td>
                  		<?php
					 reza_radio_buttons(
						'bazinews_full_width',
						array(
							''	=>__('Disable','reza'),
							'yes'	=>__('Enable','reza'),
						),
						$full_width_value
					);
					?> 
                
                 </td>
            </tr>             
      
           <tr class="meta_bazinews_hide_banner_below bazinews_meta_radio">
                <th ><label for="bazinews_hide_banner_below"><?php echo esc_html__('Hide Below Ads Widget','reza');?></label></th>
                <td>
            	<?php
					 reza_radio_buttons(
						'bazinews_hide_banner_below',
						array(
							''	=>__('Default','reza'),
							'hide'	=>__('Hide','reza'),
						),
						$hide_banner_below
					);
					?> 
                </td>
            </tr>            

            <tr class="meta_bazinews_hide_comments bazinews_meta_radio">
                <th ><label for="bazinews_hide_comments"><?php echo esc_html__('Hide Comments','reza');?></label></th>
                <td>
                     
                     <?php
					 reza_radio_buttons(
						'bazinews_hide_comments',
						array(
							''	=>__('Default','reza'),
							'hide'	=>__('Hide','reza'),
						),
						$hide_comments
					);
					?> 
                </td>
            </tr>   
            
   			   <tr class="meta_bazinews_primary_color meta_bazinews_color">
                <th><label for="bazinews_primary_color"><?php echo esc_html__('Primary Color','reza');?></label></th>
                <td>
                	<span>
               		 <label for="bazinews_primary_color[color]"><?php echo esc_html__('Background Color','reza');?></label>
               		 <input  class="reza-coloris rd-color"  data-rgba="false" type="text" name="bazinews_primary_color[color]" id="bazinews_primary_color[color]" value="<?php echo esc_attr($primary_color_1);?>">
                     </span>
                	<span>
               		 <label for="bazinews_primary_color[text]"><?php echo esc_html__('Text Color','reza');?></label>
               		 <input  class="reza-coloris rd-color"  data-rgba="false" type="text" name="bazinews_primary_color[text]" id="bazinews_primary_color[text]" value="<?php echo esc_attr($primary_color_2);?>">
                     </span>                     
                 </td>
               
            </tr>
              
                        
            <tr class="meta_bazinews_body_background_color meta_bazinews_color">
                <th ><label for="body_background_color"><?php echo esc_html__('Background Color','reza');?></label></th>
                <td>
               		 <input  class="reza-coloris rd-color"  data-rgba="false" type="text" name="bazinews_body_bg_color" id="body_background_color" value="<?php echo esc_attr($body_background_color);?>">
                 </td>
            </tr> 
                        
         	<tr class="meta_bazinews_body_background_type bazinews_meta_radio">
                <th ><label for="body_background_type"><?php echo esc_html__('Background Type','reza');?></label></th>
                <td> <?php
							 reza_radio_buttons(
						'bazinews_body_background_type',
						array(
							''	=>__('Default','reza'),
							'none'	=>__('None','reza'),
							'pattern'	=>__('Pattern','reza'),
							'custom'	=>__('Custom Image','reza'),
						),
						$body_background_type
					);
					?> 
                </td>
            </tr>            
            <tr class="meta_bazinews_body_background_pattern">
                <th ><label for="body_background_pattern"><?php echo esc_html__('Background Pattern','reza');?></label></th>
                <td>
 					<?php for ($i = 1; $i <= 23; $i++) {
						
						$bg='bg'.$i;  ?>
                        <li>
                            <input  name="bazinews_body_background_pattern" id="body_background_pattern-default"  value="<?php echo esc_attr($bg) ?>" type="radio" <?php checked( $body_background_pattern, $bg );?>>
                            <a><img src="<?php echo REZA_DIR;?>/images/bg/<?php echo esc_attr($bg)?>.png"></a>
                         </li>                    
 					<?php }?>                      
                     
                </td>
            </tr> 
            
            <tr class="meta_bazinews_body_background_image">
                <th ><label for="body_background_image"><?php echo esc_html__('Custom Background Image','reza');?></label></th>
                <td> 
 	  	 		<a class="rd_add_image button button-small"  data-uploader-title="<?php echo esc_attr__('Choose Image','reza');?>" data-remove="<?php echo esc_attr__('Remove','reza');?>"  data-uploader-button-text="<?php echo esc_attr__('Use This Image','reza');?>"> <?php echo esc_html__('Upload','reza')?></a>
 				<input type="hidden" name="bazinews_body_background_image" value="<?php echo esc_url($body_background_image);?>">
 		
				<?php if(!empty($body_background_image)){     ?>
 	   			<a class="rd_remove_image button button-small" ><?php echo  esc_html__('Remove','reza');?></a>
 		 		<img   src="<?php echo esc_url($body_background_image) ?>"/> 
                <?php }?>
               	</td>
            </tr>               
                                                                       
                        
     	</tbody>
     </table>
    <?php
}  
 /*****************************************************************************************************************************************************
******************************************************************************************************************************************************
 
														 			Save Page Metabox
 
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
add_action('save_post', 'reza_save_page_metabox');
function reza_save_page_metabox( $post_id){ 
    global $post;
    if (!isset($_POST['reza_page_meta_nonce']) || !wp_verify_nonce($_POST['reza_page_meta_nonce'], basename(__FILE__))) return;

    if (!current_user_can('edit_post', $post_id)) return;

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

  if (defined('DOING_AJAX') ) {
	return $post_id;
   }
	
	
	if (  isset($_POST['bazinews_page_right']) ) {
		update_post_meta($post_id, 'bazinews_page_right', $_POST['bazinews_page_right']);
	}else{
		delete_post_meta($post_id, 'bazinews_page_right');
	}			 
	
	if (  isset($_POST['bazinews_page_left']) ) {
		update_post_meta($post_id, 'bazinews_page_left', $_POST['bazinews_page_left']);
	}else{
		delete_post_meta($post_id, 'bazinews_page_left');
	}			 	
	   			 	
	   

	 	
	if ( isset($_POST['bazinews_full_width']) ) {
		update_post_meta($post_id, 'bazinews_full_width', $_POST['bazinews_full_width']);
	}else{
		delete_post_meta($post_id, 'bazinews_full_width');
	}
	
	
if ( isset($_POST['bazinews_hide_banner_below']) ) {
		update_post_meta($post_id, 'bazinews_hide_banner_below', $_POST['bazinews_hide_banner_below']);
	}else{
		delete_post_meta($post_id, 'bazinews_hide_banner_below');
	}	
	
	if ( isset($_POST['bazinews_hide_comments']) ) {
		update_post_meta($post_id, 'bazinews_hide_comments', $_POST['bazinews_hide_comments']);
	}else{
		delete_post_meta($post_id, 'bazinews_hide_comments');
	}	 	  
	   
	  
	
 
	if ( isset($_POST['bazinews_primary_color']) ) {
		update_post_meta($post_id, 'bazinews_primary_color', $_POST['bazinews_primary_color']);
	}else{
		delete_post_meta($post_id, 'bazinews_primary_color');
	}	
	
	if ( isset($_POST['bazinews_body_bg_color']) ) {
		update_post_meta($post_id, 'bazinews_body_bg_color', $_POST['bazinews_body_bg_color']);
	}else{
		delete_post_meta($post_id, 'bazinews_body_bg_color');
	}		

	if (isset($_POST['bazinews_body_background_type']) ) {
		update_post_meta($post_id, 'bazinews_body_background_type', $_POST['bazinews_body_background_type']);
	}else{
		delete_post_meta($post_id, 'bazinews_body_background_type');
	}
	
	 		 	   


	if (  isset($_POST['bazinews_body_background_image']) ) {
		update_post_meta($post_id, 'bazinews_body_background_image', $_POST['bazinews_body_background_image']);
	}else{
		delete_post_meta($post_id, 'bazinews_body_background_image');
	}
 
	
	if (  isset($_POST['bazinews_body_background_pattern']) ) {
		update_post_meta($post_id, 'bazinews_body_background_pattern', $_POST['bazinews_body_background_pattern']);
	}else{
		delete_post_meta($post_id, 'bazinews_body_background_pattern');
	}			    
	 
 
	 		    
}