<?php
add_action( 'add_meta_boxes', 'reza_game_custom_meta_box' );

function reza_game_custom_meta_box($post){
    add_meta_box('reza_game_meta_box',esc_html__('General Options','reza'), 'reza_game_metabox', 'game', 'normal' , 'high');
    add_meta_box('reza_gallery', esc_html__('Gallery','reza'), 'reza_game_gallery_meta_callback', 'game', 'normal' , 'high');
 
	
  }
 
 
 
 
//General Options 
function reza_game_metabox($post){
	global $post;
	wp_nonce_field( basename(__FILE__), 'sao_game_meta_nonce' );
	$release_month = get_post_meta($post->ID, 'sao_game_release_month', true);
	$release_day = get_post_meta($post->ID, 'sao_game_release_day', true);
	$release_year = get_post_meta($post->ID, 'sao_game_release_year', true);
 
	
	$summary = get_post_meta($post->ID, 'sao_game_summary', true);
    $body_background_image = get_post_meta($post->ID, 'sao_game_body_background_image', true);
	$review_short = get_post_meta($post->ID, 'sao_game_review_short', true);
	$review_score = get_post_meta($post->ID, 'sao_game_review_score', true);
	$metacritic = get_post_meta($post->ID, 'sao_game_metacritic', true);
	$game_shop = get_post_meta($post->ID, 'sao_game_shop', true);
	$data_array=array(
		''=> esc_html__('Month','reza'),
		'01'=> esc_html__('01-Jan','reza'),
		'02'=> esc_html__('02-Feb','reza'),
		'03'=> esc_html__('03-Mar','reza'),
		'04'=> esc_html__('04-Apr','reza'),
		'05'=> esc_html__('05-May','reza'),
		'06'=> esc_html__('06-Jun','reza'),
		'07'=> esc_html__('07-Jul','reza'),
		'08'=> esc_html__('08-Aug','reza'),
		'09'=> esc_html__('09-Sep','reza'),
		'10'=> esc_html__('10-Oct','reza'),
		'11'=> esc_html__('11-Nov','reza'),
		'12'=> esc_html__('12-Dec','reza'),
	);
	
     	?>
	 
	<table class="form-table meta_box">     
		<tbody>
            <tr class="meta_sao_game_release ">
			<th style="width:20%"><label for="sao_game_data"><?php echo esc_html__('Release Data','reza');?></label></th>
                <td> 

           			<select name="sao_game_release_month" id="sao_game_release_month">
                          	<?php foreach ($data_array as $key => $name){  ?>
                    			<option value="<?php echo esc_attr($key) ?>" <?php  if ( $release_month  == $key ){ echo 'selected=""';} ?>><?php echo esc_html($name);?></option> 
							<?php }?>                      
                    </select>
                    <input type="text" name="sao_game_release_day" maxlength="2" id="sao_game_release_day" placeholder="<?php echo esc_html__('day','reza');?>"   value="<?php echo $release_day;?>" />
                    <input type="text" name="sao_game_release_year" maxlength="4" id="sao_game_release_year" placeholder="<?php echo esc_html__('Year','reza');?>"  value="<?php echo $release_year;?>" />
                          <td> 

            </tr> 
            
            <tr class="meta_sao_game_summary meta_sao_game_color">
                <th style="width:20%"><label for="sao_game_summary"><?php echo esc_html__('Summary','reza');?></label></th>
                <td>
               		 <textarea name="sao_game_summary" id="sao_game_summary" ><?php echo esc_attr($summary);?></textarea>
                 </td>
            </tr>  
                        
         
            
            <tr class="meta_sao_game_body_background_image">
                <th style="width:20%"><label for="sao_game_body_background_image"><?php echo esc_html__('Custom Background Header','reza');?></label></th>
                <td> 
 	  	 		<a class="sao_game_add_image button button-small"  data-uploader-title="<?php echo esc_attr__('Choose Image','reza');?>" data-uploader-button-text="<?php echo esc_attr__('Use This Image','reza');?>"  data-remove-text="<?php echo esc_attr__('Remove','reza');?>"><?php echo esc_html__('Upload','reza')?></a>
 				<input type="hidden" name="sao_game_body_background_image" value="<?php echo esc_attr($body_background_image);?>">
 		
				<?php if(!empty($body_background_image)){
					
                 $body_background_image= wp_get_attachment_image_src($body_background_image,'medium');
					?>
 	   			<a class="sao_game_remove_image button button-small" ><?php echo  esc_html__('Remove','reza');?></a>
                
 
 		 		<img src="<?php echo esc_url($body_background_image[0]) ?>"/> 
                <?php }?>
               	</td>
            </tr>               
                    
            <tr class="sao_game_review_score">
                <th style="width:20%"><label for="sao_game_review_score"><?php echo esc_html__('Review Score','reza');?></label></th>
 					<td>
                    <input type="text" name="sao_game_review_score" id="sao_game_review_score" value="<?php if(!empty($review_score))echo  esc_attr($review_score); ?>" />
                    <span class="description"><?php echo esc_html__('Between 0 to 100','reza');?></span>
                    </td>
                </td>
            </tr>
            
              <tr class="meta_sao_game_review_short">
                <th style="width:20%"><label for="sao_game_review_short"><?php echo esc_html__('Text Appears Under The Total Score','reza');?></label></th>
					<td>
					<input type="text" name="sao_game_review_short" id="sao_game_review_short" value="<?php if(!empty($review_short))echo  esc_attr($review_short); ?>" />
                    </td>
                </td>
            </tr>     
                                                                    
            <tr class="sao_game_metacritic">
                <th style="width:20%"><label for="sao_game_metacritic"><?php echo esc_html__('Metacritic','reza');?></label></th>
 					<td>
                    <input type="text" name="sao_game_metacritic" id="sao_game_metacritic" value="<?php if(!empty($metacritic))echo  esc_attr($metacritic); ?>" />
                    <span class="description"><?php echo esc_html__('Between 0 to 100','reza');?></span>
                    </td>
                </td>
            </tr>
                             
            <tr class="sao_game_shop">
                <th style="width:20%"><label for="sao_game_shop"><?php echo esc_html__('If you want to sell the products, just put the link here','reza');?></label></th>
 					<td>
                    <input type="text" name="sao_game_shop" style="width:100% !important;" id="sao_game_shop" value="<?php if(!empty($game_shop))echo  $game_shop; ?>" />
                     </td>
                </td>
            </tr>
                             
                        
                        
     	</tbody>
     </table>
    <?php
}
 
 
 
function reza_game_save_metabox( $post_id){ 
    global $post;
 // Bail if we're doing an auto save
 
	
    if (!isset($_POST['sao_game_meta_nonce']) || !wp_verify_nonce($_POST['sao_game_meta_nonce'], basename(__FILE__))) return;

    if (!current_user_can('edit_post', $post_id)) return;

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

	if (defined('DOING_AJAX') ) {
		return $post_id;
	}
	
	
	
	
	
	
	if ( !empty($_POST['sao_game_release_month']) ) {
		$month = $_POST['sao_game_release_month'];
  		update_post_meta($post_id, 'sao_game_release_month', $_POST['sao_game_release_month']);
	}else{
		$month= 12;
	
		delete_post_meta($post_id, 'sao_game_release_month');
	}
  
	if ( !empty($_POST['sao_game_release_day']) ) {
		$day = $_POST['sao_game_release_day'];
		update_post_meta($post_id, 'sao_game_release_day', $_POST['sao_game_release_day']);
 	}else{
 		$day = 31;
 		delete_post_meta($post_id, 'sao_game_release_day');
	}
  
	if ( !empty($_POST['sao_game_release_year']) ) {
		
 		update_post_meta($post_id, 'sao_game_release_year', $_POST['sao_game_release_year']);
		$year = $_POST['sao_game_release_year'];
		$date = $year.'-'.$month.'-'.$day;
 		update_post_meta($post_id, 'sao_game_release', $date);
	}else{
		delete_post_meta($post_id, 'sao_game_release_year');
  		update_post_meta($post_id, 'sao_game_release', '9991-01-01');
	}
 	
	if ( isset($_POST['sao_game_summary']) ) {
		update_post_meta($post_id, 'sao_game_summary', $_POST['sao_game_summary']);
	}else{
		delete_post_meta($post_id, 'sao_game_summary');
	}
	
	if ( isset($_POST['sao_game_body_background_image']) ) {
		update_post_meta($post_id, 'sao_game_body_background_image', $_POST['sao_game_body_background_image']);
	}else{
		delete_post_meta($post_id, 'sao_game_body_background_image');
	}
 
	if ( isset($_POST['sao_game_body_background_image']) ) {
		update_post_meta($post_id, 'sao_game_body_background_image', $_POST['sao_game_body_background_image']);
	}else{
		delete_post_meta($post_id, 'sao_game_body_background_image');
	}
  
	
	if ( isset($_POST['sao_game_review_score']) ) {
		update_post_meta($post_id, 'sao_game_review_score', $_POST['sao_game_review_score']);
	}else{
		delete_post_meta($post_id, 'sao_game_review_score');
	}
 
	if ( isset($_POST['sao_game_review_short']) ) {
		update_post_meta($post_id, 'sao_game_review_short', $_POST['sao_game_review_short']);
	}else{
		delete_post_meta($post_id, 'sao_game_review_short');
	} 
	
	if ( isset($_POST['sao_game_metacritic']) ) {
		update_post_meta($post_id, 'sao_game_metacritic', $_POST['sao_game_metacritic']);
	}else{
		delete_post_meta($post_id, 'sao_game_metacritic');
	} 
	

	if ( isset($_POST['sao_game_shop']) ) {
		update_post_meta($post_id, 'sao_game_shop', $_POST['sao_game_shop']);
	}else{
		delete_post_meta($post_id, 'sao_game_shop');
	} 
		
		
		
}
add_action('save_post', 'reza_game_save_metabox');

/*
 * @author    Daan Vos de Wael
 * @copyright Copyright (c) 2013, Daan Vos de Wael, http://www.daanvosdewael.com
 * @license   http://en.wikipedia.org/wiki/MIT_License The MIT License
*/
function reza_game_gallery_meta_callback($post) {
    wp_nonce_field( basename(__FILE__), 'sao_gallery_meta_nonce' );
	
	
    $ids = get_post_meta($post->ID, 'sao_gallery_id', true);
	
	if(!empty($ids['json'])){
			$ids = json_decode($ids['json']);	
	}else{
  	  $ids = get_post_meta($post->ID, 'sao_gallery_id', true);
	}
    $json = !empty($ids['json'])? $ids['json']:'';
      ?>
    <table class="form-table">
      <tr><td>
        <a class="sao-gallery-add button" href="#"  data-uploader-title="<?php echo esc_html__('Add image(s) to gallery','reza');?>" data-change="<?php echo esc_html__('Change image','reza');?>" data-remove="<?php echo esc_html__('Remove image','reza');?>"  data-uploader-button-text="<?php echo esc_html__('Add image(s)','reza');?>"><?php echo esc_html__('Add image(s)','reza');?></a>

        <ul id="sao-gallery-metabox-list">
        <?php if ($ids) : foreach ($ids as $key => $value) : $image = wp_get_attachment_image_src($value); ?>

          <li data-id="<?php echo $value; ?>" data-key="<?php echo $key; ?>">
             <img class="image-preview" src="<?php echo $image[0]; ?>">
            <a class="change-image button button-small" href="#" data-uploader-title="<?php echo esc_html__('Change image','reza');?>" data-uploader-button-text="<?php echo esc_html__('Change image','reza');?>"><?php echo esc_html__('Change image','reza');?></a><br>
            <small><a class="remove-image" href="#"><?php echo esc_html__('Remove image','reza');?></a></small>
          </li>

        <?php endforeach; endif; ?>
        </ul>
 		<textarea name="sao_gallery_id[json]" id="sao_gallery_id_json" style="display:none !important;"><?php echo $json;?></textarea>
      </td></tr>
    </table>
  <?php }

function reza_game_gallery_meta_save($post_id) {
	
    if (!isset($_POST['sao_gallery_meta_nonce']) || !wp_verify_nonce($_POST['sao_gallery_meta_nonce'], basename(__FILE__))) return;

    if (!current_user_can('edit_post', $post_id)) return;

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

	if (defined('DOING_AJAX') ) {
		return $post_id;
	}
    if(isset($_POST['sao_gallery_id'])) {
      update_post_meta($post_id, 'sao_gallery_id', $_POST['sao_gallery_id']);
    } else {
      delete_post_meta($post_id, 'sao_gallery_id');
    }
}
add_action('save_post', 'reza_game_gallery_meta_save');

